/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.info;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.elf.info.ElfInfoItem;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StringUTF8DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ElfComment
implements ElfInfoItem {
    public static final String SECTION_NAME = ".comment";
    private final List<String> commentStrings;
    private final List<Integer> commentStringLengths;

    public static ElfComment fromProgram(Program program) {
        ElfInfoItem.ItemWithAddress<ElfComment> wrappedItem = ElfInfoItem.readItemFromSection(program, SECTION_NAME, ElfComment::read);
        return wrappedItem != null ? wrappedItem.item() : null;
    }

    public static ElfComment read(BinaryReader br, Program program) {
        try {
            ArrayList<String> commentStrings = new ArrayList<String>();
            ArrayList<Integer> commentStringLengths = new ArrayList<Integer>();
            while (br.hasNext()) {
                long start = br.getPointerIndex();
                String str = br.readNextUtf8String();
                commentStrings.add(str);
                commentStringLengths.add((int)(br.getPointerIndex() - start));
            }
            return new ElfComment(commentStrings, commentStringLengths);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public ElfComment(List<String> commentStrings, List<Integer> commentStringLengths) {
        this.commentStrings = commentStrings;
        this.commentStringLengths = commentStringLengths;
    }

    public List<String> getCommentStrings() {
        return this.commentStrings;
    }

    @Override
    public void markupProgram(Program program, Address address) {
        try {
            Options progInfo = program.getOptions("Program Information");
            SymbolTable symTable = program.getSymbolTable();
            for (int commentNum = 0; commentNum < this.commentStrings.size(); ++commentNum) {
                String commentStr = this.commentStrings.get(commentNum);
                Integer strLen = this.commentStringLengths.get(commentNum);
                progInfo.setString("Elf Comment[%d]".formatted(commentNum), commentStr);
                symTable.createLabel(address, "ElfComment[%d]".formatted(commentNum), SourceType.IMPORTED);
                DataUtilities.createData((Program)program, (Address)address, (DataType)StringUTF8DataType.dataType, (int)strLen, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
                address = address.addWrap((long)strLen.intValue());
            }
        }
        catch (CodeUnitInsertionException | InvalidInputException e) {
            Msg.error((Object)this, (Object)"Failed to markup ElfComment at %s: %s".formatted(address, this));
        }
    }

    public String toString() {
        return String.format("ElfComment [commentStrings=%s]", this.commentStrings);
    }
}

