/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.mz;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class MzRelocation
implements StructConverter {
    public static final String NAME = "OLD_IMAGE_DOS_RELOC";
    private int segment;
    private int offset;

    public MzRelocation(BinaryReader reader) throws IOException {
        this.offset = Short.toUnsignedInt(reader.readNextShort());
        this.segment = Short.toUnsignedInt(reader.readNextShort());
    }

    public int getSegment() {
        return this.segment;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(WORD, "offset", null);
        struct.add(WORD, "segment", null);
        struct.setCategoryPath(new CategoryPath("/DOS"));
        return struct;
    }

    public String toString() {
        return String.format("%04x:%04x", this.segment, this.offset);
    }
}

