/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryResult;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class LoadSpec {
    private Loader loader;
    private long imageBase;
    private LanguageCompilerSpecPair lcs;
    private boolean isPreferred;
    private boolean requiresLanguageCompilerSpec;

    public LoadSpec(Loader loader, long imageBase, LanguageCompilerSpecPair languageCompilerSpec, boolean isPreferred) {
        this.loader = loader;
        this.imageBase = imageBase;
        this.lcs = languageCompilerSpec;
        this.isPreferred = isPreferred;
        this.requiresLanguageCompilerSpec = this.lcs != null || !isPreferred;
    }

    public LoadSpec(Loader loader, long imageBase, QueryResult languageCompilerSpecQueryResult) {
        this(loader, imageBase, languageCompilerSpecQueryResult.pair, languageCompilerSpecQueryResult.preferred);
    }

    public LoadSpec(Loader loader, long imageBase, boolean requiresLanguageCompilerSpec) {
        this(loader, imageBase, null, !requiresLanguageCompilerSpec);
    }

    public Loader getLoader() {
        return this.loader;
    }

    public long getDesiredImageBase() {
        return this.imageBase;
    }

    public LanguageCompilerSpecPair getLanguageCompilerSpec() {
        return this.lcs;
    }

    public boolean isPreferred() {
        return this.isPreferred;
    }

    public boolean requiresLanguageCompilerSpec() {
        return this.requiresLanguageCompilerSpec;
    }

    public boolean isComplete() {
        return !this.requiresLanguageCompilerSpec || this.lcs != null;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

