/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import ghidra.app.nav.Navigatable;
import ghidra.app.util.viewer.field.AnnotatedStringHandler;
import ghidra.app.util.viewer.field.AnnotationException;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ExecutableTaskStringHandler
implements AnnotatedStringHandler {
    private static final String INVALID_SYMBOL_TEXT = "@execute annotation must have an executable name";
    private static final String[] SUPPORTED_ANNOTATIONS = new String[]{"execute"};

    @Override
    public AttributedString createAnnotatedString(AttributedString prototypeString, String[] text, Program program) throws AnnotationException {
        if (text.length <= 1) {
            throw new AnnotationException(INVALID_SYMBOL_TEXT);
        }
        String displayText = this.getDisplayText(text);
        if (displayText == null) {
            throw new AnnotationException(INVALID_SYMBOL_TEXT);
        }
        return new AttributedString(displayText, prototypeString.getColor(0), prototypeString.getFontMetrics(0), true, prototypeString.getColor(0));
    }

    private String getDisplayText(String[] text) {
        if (text.length == 4) {
            return text[3];
        }
        if (text.length != 2) {
            throw new AnnotationException("Invalid number of inputs - " + (text.length - 1) + " found - 1 or 3 required");
        }
        String programInfo = text[1];
        return this.getDisplayTextForFilePathOrName(programInfo);
    }

    private String getDisplayTextForFilePathOrName(String fileString) {
        File file = new File(fileString);
        if (file.isAbsolute() && file.exists()) {
            return file.getName();
        }
        return fileString;
    }

    @Override
    public String getDisplayString() {
        return "Execute";
    }

    @Override
    public String getPrototypeString() {
        return "{@execute \"executable_path_and_name\" \"arg1 arg2\" \"Display Text\"}";
    }

    @Override
    public String[] getSupportedAnnotations() {
        return SUPPORTED_ANNOTATIONS;
    }

    @Override
    public boolean handleMouseClick(String[] annotationParts, Navigatable sourceNavigatable, ServiceProvider serviceProvider) {
        String executableName = annotationParts[1];
        ArrayList<String> command = new ArrayList<String>();
        command.add(executableName);
        if (annotationParts.length > 2) {
            String commandParameterString = annotationParts[2];
            StringTokenizer tokenizer = new StringTokenizer(commandParameterString, " ");
            while (tokenizer.hasMoreTokens()) {
                command.add(tokenizer.nextToken());
            }
        }
        new ProcessThread(command).start();
        return true;
    }

    @Override
    public String getPrototypeString(String displayText) {
        return "{@execute " + displayText.trim() + "}";
    }

    private static class ProcessThread
    extends Thread {
        private final List<String> command;

        ProcessThread(List<String> command) {
            super("Process Runner - " + command.get(0));
            this.command = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ProcessBuilder processBuilder = new ProcessBuilder(this.command);
            processBuilder = processBuilder.redirectErrorStream(true);
            IOThread ioThread = null;
            StringBuilder buffer = new StringBuilder();
            int exitValue = 1;
            InputStream inputStream = null;
            Process process = null;
            String executableName = this.command.get(0);
            try {
                Msg.info((Object)this, (Object)("Launching process: " + executableName));
                process = processBuilder.start();
                inputStream = process.getInputStream();
                ioThread = new IOThread(buffer, inputStream);
                ioThread.start();
                exitValue = process.waitFor();
                ioThread.join();
                inputStream.close();
            }
            catch (Exception e) {
                Msg.showError((Object)this, null, (String)"Error Launching Executable", (Object)("Unexpected exception trying to launch process: " + executableName), (Throwable)e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (exitValue != 0) {
                Msg.warn((Object)this, (Object)("Process \"" + executableName + "\" exited abnormally with value: " + exitValue));
            }
        }
    }

    private static class IOThread
    extends Thread {
        private BufferedReader shellOutput;
        private StringBuilder buffer;

        IOThread(StringBuilder buffer, InputStream input) {
            super("IO Thread - Executable Annotation Task");
            this.buffer = buffer;
            this.shellOutput = new BufferedReader(new InputStreamReader(input));
        }

        @Override
        public void run() {
            String line = null;
            try {
                while ((line = this.shellOutput.readLine()) != null) {
                    this.buffer.append(line).append('\n');
                }
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)"Exception reading output for executable annotation", (Throwable)e);
                this.buffer = null;
            }
        }
    }
}

