/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.codecompare.panel;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.widgets.tabbedpane.DockingTabRenderer;
import generic.theme.GIcon;
import ghidra.features.base.codecompare.listing.ListingCodeComparisonPanel;
import ghidra.features.base.codecompare.panel.AddressSetComparisonData;
import ghidra.features.base.codecompare.panel.CodeComparisonPanel;
import ghidra.features.base.codecompare.panel.ComparisonData;
import ghidra.features.base.codecompare.panel.DataComparisonData;
import ghidra.features.base.codecompare.panel.FunctionComparisonData;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.datastruct.Duo;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FunctionComparisonPanel
extends JPanel
implements ChangeListener {
    private static final String ORIENTATION_PROPERTY_NAME = "ORIENTATION";
    private static final String DEFAULT_CODE_COMPARISON_VIEW = "Listing View";
    private static final String COMPARISON_VIEW_DISPLAYED = "COMPARISON_VIEW_DISPLAYED";
    private static final String CODE_COMPARISON_LOCK_SCROLLING_TOGETHER = "CODE_COMPARISON_LOCK_SCROLLING_TOGETHER";
    private static final HelpService help = Help.getHelpService();
    private static final String HELP_TOPIC = "FunctionComparison";
    private static final Icon SYNC_SCROLLING_ICON = new GIcon("icon.plugin.functioncompare.scroll.lock");
    private static final Icon UNSYNC_SCROLLING_ICON = new GIcon("icon.plugin.functioncompare.scroll.unlock");
    private static final String SCROLLING_GROUP = "A9_SCROLLING";
    private static final String DUAL_SCROLLING_ACTION_GROUP = "DualScrolling";
    private static final String DUAL_SCROLLING_HELP_TOPIC = "FunctionComparison";
    private JTabbedPane tabbedPane;
    private Map<String, JComponent> tabNameToComponentMap;
    private List<CodeComparisonPanel> codeComparisonPanels;
    private ToggleScrollLockAction toggleScrollLockAction;
    private boolean syncScrolling = false;
    private Duo<ComparisonData> comparisonData = new Duo((Object)ComparisonData.EMPTY, (Object)ComparisonData.EMPTY);

    public FunctionComparisonPanel(PluginTool tool, String owner) {
        this.codeComparisonPanels = this.getCodeComparisonPanels(tool, owner);
        this.tabNameToComponentMap = new HashMap<String, JComponent>();
        this.createMainPanel();
        this.createActions(owner);
        this.setScrollingSyncState(true);
        help.registerHelp((Object)this, new HelpLocation("FunctionComparison", "Function Comparison"));
    }

    public void loadFunctions(Function leftFunction, Function rightFunction) {
        ComparisonData left = leftFunction == null ? ComparisonData.EMPTY : new FunctionComparisonData(leftFunction);
        ComparisonData right = rightFunction == null ? ComparisonData.EMPTY : new FunctionComparisonData(rightFunction);
        this.loadComparisons(left, right);
    }

    public void loadData(Data leftData, Data rightData) {
        DataComparisonData left = new DataComparisonData(leftData, rightData.getLength());
        DataComparisonData right = new DataComparisonData(rightData, leftData.getLength());
        this.loadComparisons(left, right);
    }

    public void loadComparisons(ComparisonData left, ComparisonData right) {
        this.comparisonData = new Duo((Object)left, (Object)right);
        CodeComparisonPanel activePanel = this.getActiveComparisonPanel();
        if (activePanel != null) {
            activePanel.loadComparisons(left, right);
        }
    }

    public void loadAddresses(Program leftProgram, Program rightProgram, AddressSetView leftAddresses, AddressSetView rightAddresses) {
        AddressSetComparisonData left = new AddressSetComparisonData(leftProgram, leftAddresses);
        AddressSetComparisonData right = new AddressSetComparisonData(rightProgram, rightAddresses);
        this.loadComparisons(left, right);
    }

    public DockingAction[] getActions() {
        DockingAction[] actions = new DockingAction[]{this.toggleScrollLockAction};
        return actions;
    }

    public String getDescription() {
        String leftShort = ((ComparisonData)this.comparisonData.get(Duo.Side.LEFT)).getShortDescription();
        String rightShort = ((ComparisonData)this.comparisonData.get(Duo.Side.LEFT)).getShortDescription();
        return leftShort + " & " + rightShort;
    }

    public void clear() {
        this.comparisonData = new Duo((Object)ComparisonData.EMPTY, (Object)ComparisonData.EMPTY);
        CodeComparisonPanel activePanel = this.getActiveComparisonPanel();
        if (activePanel != null) {
            activePanel.clearComparisons();
        }
    }

    public boolean isEmpty() {
        return ((ComparisonData)this.comparisonData.get(Duo.Side.LEFT)).isEmpty() || ((ComparisonData)this.comparisonData.get(Duo.Side.RIGHT)).isEmpty();
    }

    public ListingCodeComparisonPanel getDualListingPanel() {
        for (CodeComparisonPanel codeComparisonPanel : this.codeComparisonPanels) {
            if (!(codeComparisonPanel instanceof ListingCodeComparisonPanel)) continue;
            ListingCodeComparisonPanel listingPanel = (ListingCodeComparisonPanel)codeComparisonPanel;
            return listingPanel;
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.tabChanged();
    }

    public boolean setCurrentTabbedComponent(String name) {
        JComponent component = this.tabNameToComponentMap.get(name);
        if (component != null) {
            if (this.tabbedPane.getSelectedComponent() == component) {
                this.tabChanged();
            }
            this.tabbedPane.setSelectedComponent(component);
        }
        return component != null;
    }

    public String getCurrentComponentName() {
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        if (selectedIndex >= 0) {
            return this.tabbedPane.getTitleAt(selectedIndex);
        }
        return null;
    }

    int getNumberOfTabbedComponents() {
        return this.tabNameToComponentMap.size();
    }

    public void dispose() {
        this.tabbedPane.removeAll();
        this.setVisible(false);
        for (CodeComparisonPanel codeComparisonPanel : this.codeComparisonPanels) {
            codeComparisonPanel.dispose();
        }
    }

    public void programClosed(Program program) {
        for (CodeComparisonPanel codeComparisonPanel : this.codeComparisonPanels) {
            codeComparisonPanel.programClosed(program);
        }
    }

    public CodeComparisonPanel getCodeComparisonPanelByName(String name) {
        for (CodeComparisonPanel codeComparisonPanel : this.codeComparisonPanels) {
            if (!name.equals(codeComparisonPanel.getName())) continue;
            return codeComparisonPanel;
        }
        return null;
    }

    private void createMainPanel() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.setPreferredSize(new Dimension(200, 300));
        for (CodeComparisonPanel codeComparisonPanel : this.codeComparisonPanels) {
            this.tabbedPane.add(codeComparisonPanel.getName(), codeComparisonPanel);
            this.tabNameToComponentMap.put(codeComparisonPanel.getName(), codeComparisonPanel);
        }
    }

    private void tabChanged() {
        CodeComparisonPanel activePanel = this.getActiveComparisonPanel();
        if (activePanel == null) {
            return;
        }
        activePanel.loadComparisons((ComparisonData)this.comparisonData.get(Duo.Side.LEFT), (ComparisonData)this.comparisonData.get(Duo.Side.RIGHT));
    }

    private CodeComparisonPanel getActiveComparisonPanel() {
        return (CodeComparisonPanel)this.tabbedPane.getSelectedComponent();
    }

    public void readConfigState(String prefix, SaveState saveState) {
        String currentTabView = saveState.getString(prefix + COMPARISON_VIEW_DISPLAYED, DEFAULT_CODE_COMPARISON_VIEW);
        this.setCurrentTabbedComponent(currentTabView);
        this.setScrollingSyncState(saveState.getBoolean(prefix + CODE_COMPARISON_LOCK_SCROLLING_TOGETHER, true));
        for (CodeComparisonPanel panel : this.codeComparisonPanels) {
            String key = prefix + panel.getName() + ORIENTATION_PROPERTY_NAME;
            panel.setSideBySide(saveState.getBoolean(key, true));
        }
    }

    public void writeConfigState(String prefix, SaveState saveState) {
        String currentComponentName = this.getCurrentComponentName();
        if (currentComponentName != null) {
            saveState.putString(prefix + COMPARISON_VIEW_DISPLAYED, this.getCurrentComponentName());
        }
        saveState.putBoolean(prefix + CODE_COMPARISON_LOCK_SCROLLING_TOGETHER, this.isScrollingSynced());
        for (CodeComparisonPanel panel : this.codeComparisonPanels) {
            String key = prefix + panel.getName() + ORIENTATION_PROPERTY_NAME;
            boolean sideBySide = panel.isSideBySide();
            saveState.putBoolean(key, sideBySide);
        }
    }

    public DockingAction[] getCodeComparisonActions() {
        ArrayList<DockingAction> dockingActionList = new ArrayList<DockingAction>();
        DockingAction[] functionComparisonActions = this.getActions();
        for (DockingAction dockingAction : functionComparisonActions) {
            dockingActionList.add(dockingAction);
        }
        for (CodeComparisonPanel codeComparisonPanel : this.codeComparisonPanels) {
            dockingActionList.addAll(codeComparisonPanel.getActions());
        }
        return dockingActionList.toArray(new DockingAction[dockingActionList.size()]);
    }

    public void setTitlePrefixes(String leftTitlePrefix, String rightTitlePrefix) {
        Component[] components;
        for (Component component : components = this.tabbedPane.getComponents()) {
            if (!(component instanceof CodeComparisonPanel)) continue;
            ((CodeComparisonPanel)component).setTitlePrefixes(leftTitlePrefix, rightTitlePrefix);
        }
    }

    public ActionContext getActionContext(MouseEvent event, ComponentProvider componentProvider) {
        CodeComparisonPanel activePanel = this.getDisplayedPanel();
        if (activePanel != null) {
            return activePanel.getActionContext(componentProvider, event);
        }
        return null;
    }

    public final boolean isScrollingSynced() {
        return this.syncScrolling;
    }

    public void setScrollingSyncState(boolean syncScrolling) {
        if (this.isScrollingSynced() == syncScrolling) {
            return;
        }
        this.toggleScrollLockAction.setSelected(syncScrolling);
        this.toggleScrollLockAction.setToolBarData(new ToolBarData(syncScrolling ? SYNC_SCROLLING_ICON : UNSYNC_SCROLLING_ICON, SCROLLING_GROUP));
        for (CodeComparisonPanel codeComparisonPanel : this.codeComparisonPanels) {
            codeComparisonPanel.setSynchronizedScrolling(syncScrolling);
        }
        this.syncScrolling = syncScrolling;
    }

    public CodeComparisonPanel getDisplayedPanel() {
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        Component component = this.tabbedPane.getComponentAt(selectedIndex);
        return (CodeComparisonPanel)component;
    }

    public void updateActionEnablement() {
        for (CodeComparisonPanel codeComparisonPanel : this.codeComparisonPanels) {
            codeComparisonPanel.updateActionEnablement();
        }
    }

    public CodeComparisonPanel getCurrentComponent() {
        return (CodeComparisonPanel)this.tabbedPane.getSelectedComponent();
    }

    boolean isTabClick(MouseEvent event) {
        Component component = event.getComponent();
        int tabCount = this.tabbedPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            DockingTabRenderer renderer = (DockingTabRenderer)this.tabbedPane.getTabComponentAt(i);
            if (!SwingUtilities.isDescendingFrom(component, (Component)renderer)) continue;
            return true;
        }
        return false;
    }

    private void createActions(String owner) {
        this.toggleScrollLockAction = new ToggleScrollLockAction(owner);
    }

    public List<CodeComparisonPanel> getComparisonPanels() {
        return this.codeComparisonPanels;
    }

    private List<CodeComparisonPanel> getCodeComparisonPanels(PluginTool tool, String owner) {
        if (this.codeComparisonPanels == null) {
            this.codeComparisonPanels = this.createAllPossibleCodeComparisonPanels(tool, owner);
            this.codeComparisonPanels.sort((p1, p2) -> p1.getName().compareTo(p2.getName()));
        }
        return this.codeComparisonPanels;
    }

    private List<CodeComparisonPanel> createAllPossibleCodeComparisonPanels(PluginTool tool, String owner) {
        ArrayList<CodeComparisonPanel> instances = new ArrayList<CodeComparisonPanel>();
        List classes = ClassSearcher.getClasses(CodeComparisonPanel.class);
        for (Class panelClass : classes) {
            try {
                Constructor constructor = panelClass.getConstructor(String.class, PluginTool.class);
                CodeComparisonPanel panel = (CodeComparisonPanel)constructor.newInstance(owner, tool);
                instances.add(panel);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                Msg.showError((Object)this, null, (String)"Error Creating Extension Point", (Object)("Error creating class " + panelClass.getName() + " when creating extension points for " + CodeComparisonPanel.class.getName()), (Throwable)e);
            }
        }
        return instances;
    }

    private class ToggleScrollLockAction
    extends ToggleDockingAction {
        ToggleScrollLockAction(String owner) {
            super("Synchronize Scrolling of Dual View", owner);
            this.setDescription("Lock/Unlock Synchronized Scrolling of Dual View");
            this.setToolBarData(new ToolBarData(UNSYNC_SCROLLING_ICON, FunctionComparisonPanel.SCROLLING_GROUP));
            this.setEnabled(true);
            MenuData menuData = new MenuData(new String[]{"Synchronize Scrolling"}, FunctionComparisonPanel.DUAL_SCROLLING_ACTION_GROUP);
            this.setMenuBarData(menuData);
            this.setHelpLocation(new HelpLocation("FunctionComparison", "Synchronize Scrolling of Dual View"));
        }

        public void actionPerformed(ActionContext context) {
            FunctionComparisonPanel.this.setScrollingSyncState(this.isSelected());
        }
    }
}

