/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser.filehandlers;

import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import docking.widgets.dialogs.MultiLineMessageDialog;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.formats.gfilesystem.fileinfo.FileAttribute;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeTypeGroup;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.framework.model.DomainFile;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBComponentProvider;
import ghidra.plugins.fsbrowser.FSBFileHandler;
import ghidra.plugins.fsbrowser.FSBFileHandlerContext;
import ghidra.plugins.fsbrowser.FSBIcons;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.io.FilenameUtils;

public class GetInfoFSBFileHandler
implements FSBFileHandler {
    public static final String FSB_GET_INFO = "FSB Get Info";
    private FSBFileHandlerContext context;
    private static final Function<Object, String> PLAIN_TOSTRING = o -> o.toString();
    private static final Function<Object, String> SIZE_TOSTRING = o -> o instanceof Long ? FSUtilities.formatSize((Long)o) : o.toString();
    private static final Function<Object, String> UNIX_ACL_TOSTRING = o -> o instanceof Number ? String.format("%05o", (Number)o) : o.toString();
    private static final Function<Object, String> DATE_TOSTRING = o -> o instanceof Date ? FSUtilities.formatFSTimestamp((Date)o) : o.toString();
    private static final Function<Object, String> FSRL_TOSTRING = o -> o instanceof FSRL ? ((FSRL)o).toPrettyString().replace("|", "|\n\t") : o.toString();
    private static final Map<FileAttributeType, Function<Object, String>> FAT_TOSTRING_FUNCS = Map.ofEntries(Map.entry(FileAttributeType.FSRL_ATTR, FSRL_TOSTRING), Map.entry(FileAttributeType.SIZE_ATTR, SIZE_TOSTRING), Map.entry(FileAttributeType.COMPRESSED_SIZE_ATTR, SIZE_TOSTRING), Map.entry(FileAttributeType.CREATE_DATE_ATTR, DATE_TOSTRING), Map.entry(FileAttributeType.MODIFIED_DATE_ATTR, DATE_TOSTRING), Map.entry(FileAttributeType.ACCESSED_DATE_ATTR, DATE_TOSTRING), Map.entry(FileAttributeType.UNIX_ACL_ATTR, UNIX_ACL_TOSTRING));

    @Override
    public void init(FSBFileHandlerContext context) {
        this.context = context;
    }

    @Override
    public List<DockingAction> createActions() {
        return List.of((DockingAction)new ActionBuilder(FSB_GET_INFO, this.context.plugin().getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getFSRL(true) != null).popupMenuPath(new String[]{"Get Info"}).popupMenuGroup("A", "A").popupMenuIcon(FSBIcons.INFO).description("Show information about a file").onAction(ac -> {
            FSRL fsrl = ac.getFSRL(true);
            FSBComponentProvider fsbComp = ac.getComponentProvider();
            fsbComp.runTask(monitor -> this.showInfoForFile((Component)ac.getSourceComponent(), fsrl, monitor));
        }).build());
    }

    private void showInfoForFile(Component parentComp, FSRL fsrl, TaskMonitor monitor) {
        if (fsrl == null) {
            Msg.showError((Object)this, (Component)parentComp, (String)"Missing File", (Object)"Unable to retrieve information");
            return;
        }
        List<FSRL> fsrls = fsrl instanceof FSRLRoot && ((FSRLRoot)fsrl).hasContainer() ? List.of(((FSRLRoot)fsrl).getContainer(), fsrl) : List.of(fsrl);
        String title = "Info about " + fsrls.get(0).getName();
        ArrayList<FileAttributes> fattrs = new ArrayList<FileAttributes>();
        for (FSRL fsrl2 : fsrls) {
            try {
                fattrs.add(this.getAttrsFor(fsrl2, monitor));
            }
            catch (IOException e) {
                Msg.warn((Object)this, (Object)("Failed to get info for file " + String.valueOf(fsrl2)), (Throwable)e);
            }
            catch (CancelledException e) {
                return;
            }
        }
        String html = this.getHTMLInfoStringForAttributes(fattrs);
        MultiLineMessageDialog.showMessageDialog((Component)parentComp, (String)title, null, (String)html, (int)1);
    }

    private FileAttributes getAttrsFor(FSRL fsrl, TaskMonitor monitor) throws CancelledException, IOException {
        try (RefdFile refdFile = this.context.fsService().getRefdFile(fsrl, monitor);){
            GFileSystem fs = refdFile.fsRef.getFilesystem();
            GFile file = refdFile.file;
            FileAttributes fattrs = fs.getFileAttributes(file, monitor);
            if (fattrs == null) {
                fattrs = FileAttributes.EMPTY;
            }
            fattrs = fattrs.clone();
            DomainFile associatedDomainFile = this.context.projectIndex().findFirstByFSRL(fsrl);
            if (associatedDomainFile != null) {
                fattrs.add(FileAttributeType.PROJECT_FILE_ATTR, (Object)associatedDomainFile.getPathname());
            }
            if (!fattrs.contains(FileAttributeType.NAME_ATTR)) {
                fattrs.add(FileAttributeType.NAME_ATTR, (Object)file.getName());
            }
            if (!fattrs.contains(FileAttributeType.PATH_ATTR)) {
                fattrs.add(FileAttributeType.PATH_ATTR, (Object)FilenameUtils.getFullPath((String)file.getPath()));
            }
            if (!fattrs.contains(FileAttributeType.FSRL_ATTR)) {
                fattrs.add(FileAttributeType.FSRL_ATTR, (Object)file.getFSRL());
            }
            FileAttributes fileAttributes = fattrs;
            return fileAttributes;
        }
    }

    private String getHTMLInfoStringForAttributes(List<FileAttributes> fileAttributesList) {
        StringBuilder sb = new StringBuilder("<html>\n<table>\n");
        sb.append("<tr><th>Property</th><th>Value</th></tr>\n");
        for (FileAttributes fattrs : fileAttributesList) {
            if (fattrs != fileAttributesList.get(0)) {
                sb.append("<tr><td colspan=2><hr></td></tr>");
            }
            List<FileAttribute<?>> sortedAttribs = fattrs.getAttributes();
            Collections.sort(sortedAttribs, (o1, o2) -> Integer.compare(o1.getAttributeType().ordinal(), o2.getAttributeType().ordinal()));
            FileAttributeTypeGroup group = null;
            for (FileAttribute<?> attr : sortedAttribs) {
                if (attr.getAttributeType().getGroup() != group && (group = attr.getAttributeType().getGroup()) != FileAttributeTypeGroup.GENERAL_INFO) {
                    sb.append("<tr><td><b>").append(group.getDescriptiveName()).append("</b></td><td><hr></td></tr>\n");
                }
                String valStr = FAT_TOSTRING_FUNCS.getOrDefault((Object)attr.getAttributeType(), PLAIN_TOSTRING).apply(attr.getAttributeValue());
                String html = HTMLUtilities.escapeHTML((String)valStr);
                html = html.replace("\n", "<br>\n");
                sb.append("<tr><td>").append(attr.getAttributeDisplayName()).append(":</td><td>").append(html).append("</td></tr>\n");
            }
        }
        sb.append("</table>");
        return sb.toString();
    }
}

