/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.importer.batch;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.plugins.importer.batch.BatchGroupLoadSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;

public class BatchSegregatingCriteria {
    private final Set<BatchGroupLoadSpec> groupLoadSpecs = new HashSet<BatchGroupLoadSpec>();
    private final String fileExt;
    private final String loader;

    public BatchSegregatingCriteria(Loader loader, Collection<LoadSpec> loadSpecs, ByteProvider provider) {
        for (LoadSpec loadSpec : loadSpecs) {
            this.groupLoadSpecs.add(new BatchGroupLoadSpec(loadSpec));
        }
        this.loader = loader.getName();
        this.fileExt = FilenameUtils.getExtension((String)loader.getPreferredFileName(provider));
    }

    public String getFileExt() {
        return this.fileExt;
    }

    public String getLoader() {
        return this.loader;
    }

    public List<BatchGroupLoadSpec> getBatchGroupLoadSpecs() {
        ArrayList<BatchGroupLoadSpec> result = new ArrayList<BatchGroupLoadSpec>(this.groupLoadSpecs);
        Collections.sort(result);
        return result;
    }

    public BatchGroupLoadSpec getFirstPreferredLoadSpec() {
        for (BatchGroupLoadSpec groupLoadSpec : this.groupLoadSpecs) {
            if (!groupLoadSpec.preferred) continue;
            return groupLoadSpec;
        }
        return null;
    }

    public String toString() {
        return "[ext: " + (this.fileExt != null ? this.fileExt : "") + ", loader: " + this.loader + ", load specs: " + this.groupLoadSpecs.toString() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileExt == null ? 0 : this.fileExt.hashCode());
        result = 31 * result + (this.loader == null ? 0 : this.loader.hashCode());
        result = 31 * result + (this.groupLoadSpecs == null ? 0 : this.groupLoadSpecs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchSegregatingCriteria)) {
            return false;
        }
        BatchSegregatingCriteria other = (BatchSegregatingCriteria)obj;
        if (this.fileExt == null ? other.fileExt != null : !this.fileExt.equals(other.fileExt)) {
            return false;
        }
        if (this.loader == null ? other.loader != null : !this.loader.equals(other.loader)) {
            return false;
        }
        return !(this.groupLoadSpecs == null ? other.groupLoadSpecs != null : !this.groupLoadSpecs.equals(other.groupLoadSpecs));
    }
}

