/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ProgramLocation;
import ghidra.util.table.column.AbstractGhidraColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.ProgramLocationTableColumnExtensionPoint;
import java.awt.Component;
import javax.swing.JLabel;

public class ReferenceTypeTableColumn
extends ProgramLocationTableColumnExtensionPoint<Reference, RefType> {
    private ReferenceTypeTableCellRenderer reftypeRenderer = new ReferenceTypeTableCellRenderer();

    public String getColumnDisplayName(Settings settings) {
        return this.getColumnName();
    }

    public String getColumnName() {
        return "Ref Type";
    }

    public RefType getValue(Reference rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
        Instruction instruction;
        Listing listing = program.getListing();
        RefType referenceType = rowObject.getReferenceType();
        if (referenceType == RefType.INDIRECTION && (instruction = listing.getInstructionAt(rowObject.getFromAddress())) != null) {
            FlowType flowType = instruction.getFlowType();
            return flowType;
        }
        return referenceType;
    }

    @Override
    public ProgramLocation getProgramLocation(Reference rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
        return null;
    }

    public GColumnRenderer<RefType> getColumnRenderer() {
        return this.reftypeRenderer;
    }

    private class ReferenceTypeTableCellRenderer
    extends AbstractGhidraColumnRenderer<RefType> {
        private ReferenceTypeTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(data);
            RefType value = (RefType)data.getValue();
            label.setText(value.getDisplayString());
            return label;
        }

        public String getFilterString(RefType t, Settings settings) {
            return t.getDisplayString();
        }
    }
}

