/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.equates;

import com.google.gson.JsonElement;
import ghidra.program.model.symbol.Equate;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import sarif.export.AbstractExtWriter;
import sarif.export.SarifObject;
import sarif.export.equates.ExtEquate;
import sarif.managers.EquatesSarifMgr;

public class SarifEquateWriter
extends AbstractExtWriter {
    private List<Equate> equates;

    public SarifEquateWriter(List<Equate> request, Writer baseWriter) throws IOException {
        super(baseWriter);
        this.equates = request;
    }

    @Override
    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        this.genCode(monitor);
        this.root.add("equates", (JsonElement)this.objects);
    }

    private void genCode(TaskMonitor monitor) throws CancelledException, IOException {
        monitor.initialize((long)this.equates.size());
        for (Equate equate : this.equates) {
            ExtEquate isf = new ExtEquate(equate);
            SarifObject sarif = new SarifObject(EquatesSarifMgr.SUBKEY, EquatesSarifMgr.KEY, this.getTree(isf), null);
            this.objects.add(this.getTree(sarif));
            monitor.increment();
        }
    }
}

