/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import com.google.gson.JsonArray;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sarif.SarifProgramOptions;
import sarif.export.SarifWriterTask;
import sarif.export.ep.SarifEntryPointWriter;
import sarif.managers.SarifMgr;

public class ExtEntryPointSarifMgr
extends SarifMgr {
    public static String KEY = "ENTRY_POINTS";
    public static String SUBKEY = "Entry Point";
    private SymbolTable symbolTable;

    ExtEntryPointSarifMgr(Program program, MessageLog log) {
        super(KEY, program, log);
        this.symbolTable = program.getSymbolTable();
    }

    @Override
    public boolean read(Map<String, Object> result, SarifProgramOptions options, TaskMonitor monitor) throws AddressFormatException, CancelledException {
        try {
            Address addr = this.getLocation(result);
            this.symbolTable.addExternalEntryPoint(addr);
            return true;
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
            return false;
        }
    }

    void write(JsonArray results, AddressSetView set, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Writing ENTRY POINTS ...");
        ArrayList<Address> request = new ArrayList<Address>();
        AddressIterator iter = this.symbolTable.getExternalEntryPointIterator();
        while (iter.hasNext()) {
            request.add(iter.next());
        }
        ExtEntryPointSarifMgr.writeAsSARIF(request, results);
    }

    public static void writeAsSARIF(List<Address> request, JsonArray results) throws IOException {
        SarifEntryPointWriter writer = new SarifEntryPointWriter(request, null);
        new TaskLauncher((Task)new SarifWriterTask(SUBKEY, writer, results), null);
    }
}

