/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sarif;

import com.contrastsecurity.sarif.ArtifactLocation;
import com.contrastsecurity.sarif.ConfigurationOverride;
import com.contrastsecurity.sarif.EnvironmentVariables;
import com.contrastsecurity.sarif.Notification;
import com.contrastsecurity.sarif.PropertyBag;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"commandLine", "arguments", "responseFiles", "startTimeUtc", "endTimeUtc", "exitCode", "ruleConfigurationOverrides", "notificationConfigurationOverrides", "toolExecutionNotifications", "toolConfigurationNotifications", "exitCodeDescription", "exitSignalName", "exitSignalNumber", "processStartFailureMessage", "executionSuccessful", "machine", "account", "processId", "executableLocation", "workingDirectory", "environmentVariables", "stdin", "stdout", "stderr", "stdoutStderr", "properties"})
public class Invocation {
    @JsonProperty(value="commandLine")
    @JsonPropertyDescription(value="The command line used to invoke the tool.")
    private String commandLine;
    @JsonProperty(value="arguments")
    @JsonPropertyDescription(value="An array of strings, containing in order the command line arguments passed to the tool from the operating system.")
    private List<String> arguments = null;
    @JsonProperty(value="responseFiles")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="The locations of any response files specified on the tool's command line.")
    private Set<ArtifactLocation> responseFiles = null;
    @JsonProperty(value="startTimeUtc")
    @JsonPropertyDescription(value="The Coordinated Universal Time (UTC) date and time at which the invocation started. See \"Date/time properties\" in the SARIF spec for the required format.")
    private Date startTimeUtc;
    @JsonProperty(value="endTimeUtc")
    @JsonPropertyDescription(value="The Coordinated Universal Time (UTC) date and time at which the invocation ended. See \"Date/time properties\" in the SARIF spec for the required format.")
    private Date endTimeUtc;
    @JsonProperty(value="exitCode")
    @JsonPropertyDescription(value="The process exit code.")
    private Long exitCode;
    @JsonProperty(value="ruleConfigurationOverrides")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of configurationOverride objects that describe rules related runtime overrides.")
    private Set<ConfigurationOverride> ruleConfigurationOverrides = null;
    @JsonProperty(value="notificationConfigurationOverrides")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of configurationOverride objects that describe notifications related runtime overrides.")
    private Set<ConfigurationOverride> notificationConfigurationOverrides = null;
    @JsonProperty(value="toolExecutionNotifications")
    @JsonPropertyDescription(value="A list of runtime conditions detected by the tool during the analysis.")
    private List<Notification> toolExecutionNotifications = null;
    @JsonProperty(value="toolConfigurationNotifications")
    @JsonPropertyDescription(value="A list of conditions detected by the tool that are relevant to the tool's configuration.")
    private List<Notification> toolConfigurationNotifications = null;
    @JsonProperty(value="exitCodeDescription")
    @JsonPropertyDescription(value="The reason for the process exit.")
    private String exitCodeDescription;
    @JsonProperty(value="exitSignalName")
    @JsonPropertyDescription(value="The name of the signal that caused the process to exit.")
    private String exitSignalName;
    @JsonProperty(value="exitSignalNumber")
    @JsonPropertyDescription(value="The numeric value of the signal that caused the process to exit.")
    private Long exitSignalNumber;
    @JsonProperty(value="processStartFailureMessage")
    @JsonPropertyDescription(value="The reason given by the operating system that the process failed to start.")
    private String processStartFailureMessage;
    @JsonProperty(value="executionSuccessful")
    @JsonPropertyDescription(value="Specifies whether the tool's execution completed successfully.")
    private Boolean executionSuccessful;
    @JsonProperty(value="machine")
    @JsonPropertyDescription(value="The machine on which the invocation occurred.")
    private String machine;
    @JsonProperty(value="account")
    @JsonPropertyDescription(value="The account under which the invocation occurred.")
    private String account;
    @JsonProperty(value="processId")
    @JsonPropertyDescription(value="The id of the process in which the invocation occurred.")
    private Long processId;
    @JsonProperty(value="executableLocation")
    @JsonPropertyDescription(value="Specifies the location of an artifact.")
    private ArtifactLocation executableLocation;
    @JsonProperty(value="workingDirectory")
    @JsonPropertyDescription(value="Specifies the location of an artifact.")
    private ArtifactLocation workingDirectory;
    @JsonProperty(value="environmentVariables")
    @JsonPropertyDescription(value="The environment variables associated with the analysis tool process, expressed as key/value pairs.")
    private EnvironmentVariables environmentVariables;
    @JsonProperty(value="stdin")
    @JsonPropertyDescription(value="Specifies the location of an artifact.")
    private ArtifactLocation stdin;
    @JsonProperty(value="stdout")
    @JsonPropertyDescription(value="Specifies the location of an artifact.")
    private ArtifactLocation stdout;
    @JsonProperty(value="stderr")
    @JsonPropertyDescription(value="Specifies the location of an artifact.")
    private ArtifactLocation stderr;
    @JsonProperty(value="stdoutStderr")
    @JsonPropertyDescription(value="Specifies the location of an artifact.")
    private ArtifactLocation stdoutStderr;
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="commandLine")
    public String getCommandLine() {
        return this.commandLine;
    }

    @JsonProperty(value="commandLine")
    public void setCommandLine(String commandLine) {
        this.commandLine = commandLine;
    }

    public Invocation withCommandLine(String commandLine) {
        this.commandLine = commandLine;
        return this;
    }

    @JsonProperty(value="arguments")
    public List<String> getArguments() {
        return this.arguments;
    }

    @JsonProperty(value="arguments")
    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public Invocation withArguments(List<String> arguments) {
        this.arguments = arguments;
        return this;
    }

    @JsonProperty(value="responseFiles")
    public Set<ArtifactLocation> getResponseFiles() {
        return this.responseFiles;
    }

    @JsonProperty(value="responseFiles")
    public void setResponseFiles(Set<ArtifactLocation> responseFiles) {
        this.responseFiles = responseFiles;
    }

    public Invocation withResponseFiles(Set<ArtifactLocation> responseFiles) {
        this.responseFiles = responseFiles;
        return this;
    }

    @JsonProperty(value="startTimeUtc")
    public Date getStartTimeUtc() {
        return this.startTimeUtc;
    }

    @JsonProperty(value="startTimeUtc")
    public void setStartTimeUtc(Date startTimeUtc) {
        this.startTimeUtc = startTimeUtc;
    }

    public Invocation withStartTimeUtc(Date startTimeUtc) {
        this.startTimeUtc = startTimeUtc;
        return this;
    }

    @JsonProperty(value="endTimeUtc")
    public Date getEndTimeUtc() {
        return this.endTimeUtc;
    }

    @JsonProperty(value="endTimeUtc")
    public void setEndTimeUtc(Date endTimeUtc) {
        this.endTimeUtc = endTimeUtc;
    }

    public Invocation withEndTimeUtc(Date endTimeUtc) {
        this.endTimeUtc = endTimeUtc;
        return this;
    }

    @JsonProperty(value="exitCode")
    public Long getExitCode() {
        return this.exitCode;
    }

    @JsonProperty(value="exitCode")
    public void setExitCode(Long exitCode) {
        this.exitCode = exitCode;
    }

    public Invocation withExitCode(Long exitCode) {
        this.exitCode = exitCode;
        return this;
    }

    @JsonProperty(value="ruleConfigurationOverrides")
    public Set<ConfigurationOverride> getRuleConfigurationOverrides() {
        return this.ruleConfigurationOverrides;
    }

    @JsonProperty(value="ruleConfigurationOverrides")
    public void setRuleConfigurationOverrides(Set<ConfigurationOverride> ruleConfigurationOverrides) {
        this.ruleConfigurationOverrides = ruleConfigurationOverrides;
    }

    public Invocation withRuleConfigurationOverrides(Set<ConfigurationOverride> ruleConfigurationOverrides) {
        this.ruleConfigurationOverrides = ruleConfigurationOverrides;
        return this;
    }

    @JsonProperty(value="notificationConfigurationOverrides")
    public Set<ConfigurationOverride> getNotificationConfigurationOverrides() {
        return this.notificationConfigurationOverrides;
    }

    @JsonProperty(value="notificationConfigurationOverrides")
    public void setNotificationConfigurationOverrides(Set<ConfigurationOverride> notificationConfigurationOverrides) {
        this.notificationConfigurationOverrides = notificationConfigurationOverrides;
    }

    public Invocation withNotificationConfigurationOverrides(Set<ConfigurationOverride> notificationConfigurationOverrides) {
        this.notificationConfigurationOverrides = notificationConfigurationOverrides;
        return this;
    }

    @JsonProperty(value="toolExecutionNotifications")
    public List<Notification> getToolExecutionNotifications() {
        return this.toolExecutionNotifications;
    }

    @JsonProperty(value="toolExecutionNotifications")
    public void setToolExecutionNotifications(List<Notification> toolExecutionNotifications) {
        this.toolExecutionNotifications = toolExecutionNotifications;
    }

    public Invocation withToolExecutionNotifications(List<Notification> toolExecutionNotifications) {
        this.toolExecutionNotifications = toolExecutionNotifications;
        return this;
    }

    @JsonProperty(value="toolConfigurationNotifications")
    public List<Notification> getToolConfigurationNotifications() {
        return this.toolConfigurationNotifications;
    }

    @JsonProperty(value="toolConfigurationNotifications")
    public void setToolConfigurationNotifications(List<Notification> toolConfigurationNotifications) {
        this.toolConfigurationNotifications = toolConfigurationNotifications;
    }

    public Invocation withToolConfigurationNotifications(List<Notification> toolConfigurationNotifications) {
        this.toolConfigurationNotifications = toolConfigurationNotifications;
        return this;
    }

    @JsonProperty(value="exitCodeDescription")
    public String getExitCodeDescription() {
        return this.exitCodeDescription;
    }

    @JsonProperty(value="exitCodeDescription")
    public void setExitCodeDescription(String exitCodeDescription) {
        this.exitCodeDescription = exitCodeDescription;
    }

    public Invocation withExitCodeDescription(String exitCodeDescription) {
        this.exitCodeDescription = exitCodeDescription;
        return this;
    }

    @JsonProperty(value="exitSignalName")
    public String getExitSignalName() {
        return this.exitSignalName;
    }

    @JsonProperty(value="exitSignalName")
    public void setExitSignalName(String exitSignalName) {
        this.exitSignalName = exitSignalName;
    }

    public Invocation withExitSignalName(String exitSignalName) {
        this.exitSignalName = exitSignalName;
        return this;
    }

    @JsonProperty(value="exitSignalNumber")
    public Long getExitSignalNumber() {
        return this.exitSignalNumber;
    }

    @JsonProperty(value="exitSignalNumber")
    public void setExitSignalNumber(Long exitSignalNumber) {
        this.exitSignalNumber = exitSignalNumber;
    }

    public Invocation withExitSignalNumber(Long exitSignalNumber) {
        this.exitSignalNumber = exitSignalNumber;
        return this;
    }

    @JsonProperty(value="processStartFailureMessage")
    public String getProcessStartFailureMessage() {
        return this.processStartFailureMessage;
    }

    @JsonProperty(value="processStartFailureMessage")
    public void setProcessStartFailureMessage(String processStartFailureMessage) {
        this.processStartFailureMessage = processStartFailureMessage;
    }

    public Invocation withProcessStartFailureMessage(String processStartFailureMessage) {
        this.processStartFailureMessage = processStartFailureMessage;
        return this;
    }

    @JsonProperty(value="executionSuccessful")
    public Boolean getExecutionSuccessful() {
        return this.executionSuccessful;
    }

    @JsonProperty(value="executionSuccessful")
    public void setExecutionSuccessful(Boolean executionSuccessful) {
        this.executionSuccessful = executionSuccessful;
    }

    public Invocation withExecutionSuccessful(Boolean executionSuccessful) {
        this.executionSuccessful = executionSuccessful;
        return this;
    }

    @JsonProperty(value="machine")
    public String getMachine() {
        return this.machine;
    }

    @JsonProperty(value="machine")
    public void setMachine(String machine) {
        this.machine = machine;
    }

    public Invocation withMachine(String machine) {
        this.machine = machine;
        return this;
    }

    @JsonProperty(value="account")
    public String getAccount() {
        return this.account;
    }

    @JsonProperty(value="account")
    public void setAccount(String account) {
        this.account = account;
    }

    public Invocation withAccount(String account) {
        this.account = account;
        return this;
    }

    @JsonProperty(value="processId")
    public Long getProcessId() {
        return this.processId;
    }

    @JsonProperty(value="processId")
    public void setProcessId(Long processId) {
        this.processId = processId;
    }

    public Invocation withProcessId(Long processId) {
        this.processId = processId;
        return this;
    }

    @JsonProperty(value="executableLocation")
    public ArtifactLocation getExecutableLocation() {
        return this.executableLocation;
    }

    @JsonProperty(value="executableLocation")
    public void setExecutableLocation(ArtifactLocation executableLocation) {
        this.executableLocation = executableLocation;
    }

    public Invocation withExecutableLocation(ArtifactLocation executableLocation) {
        this.executableLocation = executableLocation;
        return this;
    }

    @JsonProperty(value="workingDirectory")
    public ArtifactLocation getWorkingDirectory() {
        return this.workingDirectory;
    }

    @JsonProperty(value="workingDirectory")
    public void setWorkingDirectory(ArtifactLocation workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public Invocation withWorkingDirectory(ArtifactLocation workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    @JsonProperty(value="environmentVariables")
    public EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @JsonProperty(value="environmentVariables")
    public void setEnvironmentVariables(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public Invocation withEnvironmentVariables(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    @JsonProperty(value="stdin")
    public ArtifactLocation getStdin() {
        return this.stdin;
    }

    @JsonProperty(value="stdin")
    public void setStdin(ArtifactLocation stdin) {
        this.stdin = stdin;
    }

    public Invocation withStdin(ArtifactLocation stdin) {
        this.stdin = stdin;
        return this;
    }

    @JsonProperty(value="stdout")
    public ArtifactLocation getStdout() {
        return this.stdout;
    }

    @JsonProperty(value="stdout")
    public void setStdout(ArtifactLocation stdout) {
        this.stdout = stdout;
    }

    public Invocation withStdout(ArtifactLocation stdout) {
        this.stdout = stdout;
        return this;
    }

    @JsonProperty(value="stderr")
    public ArtifactLocation getStderr() {
        return this.stderr;
    }

    @JsonProperty(value="stderr")
    public void setStderr(ArtifactLocation stderr) {
        this.stderr = stderr;
    }

    public Invocation withStderr(ArtifactLocation stderr) {
        this.stderr = stderr;
        return this;
    }

    @JsonProperty(value="stdoutStderr")
    public ArtifactLocation getStdoutStderr() {
        return this.stdoutStderr;
    }

    @JsonProperty(value="stdoutStderr")
    public void setStdoutStderr(ArtifactLocation stdoutStderr) {
        this.stdoutStderr = stdoutStderr;
    }

    public Invocation withStdoutStderr(ArtifactLocation stdoutStderr) {
        this.stdoutStderr = stdoutStderr;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public Invocation withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Invocation.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("commandLine");
        sb.append('=');
        sb.append(this.commandLine == null ? "<null>" : this.commandLine);
        sb.append(',');
        sb.append("arguments");
        sb.append('=');
        sb.append(this.arguments == null ? "<null>" : this.arguments);
        sb.append(',');
        sb.append("responseFiles");
        sb.append('=');
        sb.append(this.responseFiles == null ? "<null>" : this.responseFiles);
        sb.append(',');
        sb.append("startTimeUtc");
        sb.append('=');
        sb.append(this.startTimeUtc == null ? "<null>" : this.startTimeUtc);
        sb.append(',');
        sb.append("endTimeUtc");
        sb.append('=');
        sb.append(this.endTimeUtc == null ? "<null>" : this.endTimeUtc);
        sb.append(',');
        sb.append("exitCode");
        sb.append('=');
        sb.append(this.exitCode == null ? "<null>" : this.exitCode);
        sb.append(',');
        sb.append("ruleConfigurationOverrides");
        sb.append('=');
        sb.append(this.ruleConfigurationOverrides == null ? "<null>" : this.ruleConfigurationOverrides);
        sb.append(',');
        sb.append("notificationConfigurationOverrides");
        sb.append('=');
        sb.append(this.notificationConfigurationOverrides == null ? "<null>" : this.notificationConfigurationOverrides);
        sb.append(',');
        sb.append("toolExecutionNotifications");
        sb.append('=');
        sb.append(this.toolExecutionNotifications == null ? "<null>" : this.toolExecutionNotifications);
        sb.append(',');
        sb.append("toolConfigurationNotifications");
        sb.append('=');
        sb.append(this.toolConfigurationNotifications == null ? "<null>" : this.toolConfigurationNotifications);
        sb.append(',');
        sb.append("exitCodeDescription");
        sb.append('=');
        sb.append(this.exitCodeDescription == null ? "<null>" : this.exitCodeDescription);
        sb.append(',');
        sb.append("exitSignalName");
        sb.append('=');
        sb.append(this.exitSignalName == null ? "<null>" : this.exitSignalName);
        sb.append(',');
        sb.append("exitSignalNumber");
        sb.append('=');
        sb.append(this.exitSignalNumber == null ? "<null>" : this.exitSignalNumber);
        sb.append(',');
        sb.append("processStartFailureMessage");
        sb.append('=');
        sb.append(this.processStartFailureMessage == null ? "<null>" : this.processStartFailureMessage);
        sb.append(',');
        sb.append("executionSuccessful");
        sb.append('=');
        sb.append(this.executionSuccessful == null ? "<null>" : this.executionSuccessful);
        sb.append(',');
        sb.append("machine");
        sb.append('=');
        sb.append(this.machine == null ? "<null>" : this.machine);
        sb.append(',');
        sb.append("account");
        sb.append('=');
        sb.append(this.account == null ? "<null>" : this.account);
        sb.append(',');
        sb.append("processId");
        sb.append('=');
        sb.append(this.processId == null ? "<null>" : this.processId);
        sb.append(',');
        sb.append("executableLocation");
        sb.append('=');
        sb.append(this.executableLocation == null ? "<null>" : this.executableLocation);
        sb.append(',');
        sb.append("workingDirectory");
        sb.append('=');
        sb.append(this.workingDirectory == null ? "<null>" : this.workingDirectory);
        sb.append(',');
        sb.append("environmentVariables");
        sb.append('=');
        sb.append(this.environmentVariables == null ? "<null>" : this.environmentVariables);
        sb.append(',');
        sb.append("stdin");
        sb.append('=');
        sb.append(this.stdin == null ? "<null>" : this.stdin);
        sb.append(',');
        sb.append("stdout");
        sb.append('=');
        sb.append(this.stdout == null ? "<null>" : this.stdout);
        sb.append(',');
        sb.append("stderr");
        sb.append('=');
        sb.append(this.stderr == null ? "<null>" : this.stderr);
        sb.append(',');
        sb.append("stdoutStderr");
        sb.append('=');
        sb.append(this.stdoutStderr == null ? "<null>" : this.stdoutStderr);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.endTimeUtc == null ? 0 : this.endTimeUtc.hashCode());
        result = result * 31 + (this.stdin == null ? 0 : this.stdin.hashCode());
        result = result * 31 + (this.stdout == null ? 0 : this.stdout.hashCode());
        result = result * 31 + (this.workingDirectory == null ? 0 : this.workingDirectory.hashCode());
        result = result * 31 + (this.exitSignalNumber == null ? 0 : this.exitSignalNumber.hashCode());
        result = result * 31 + (this.exitCodeDescription == null ? 0 : this.exitCodeDescription.hashCode());
        result = result * 31 + (this.executableLocation == null ? 0 : this.executableLocation.hashCode());
        result = result * 31 + (this.processId == null ? 0 : this.processId.hashCode());
        result = result * 31 + (this.exitCode == null ? 0 : this.exitCode.hashCode());
        result = result * 31 + (this.toolConfigurationNotifications == null ? 0 : this.toolConfigurationNotifications.hashCode());
        result = result * 31 + (this.notificationConfigurationOverrides == null ? 0 : this.notificationConfigurationOverrides.hashCode());
        result = result * 31 + (this.processStartFailureMessage == null ? 0 : this.processStartFailureMessage.hashCode());
        result = result * 31 + (this.stderr == null ? 0 : this.stderr.hashCode());
        result = result * 31 + (this.ruleConfigurationOverrides == null ? 0 : this.ruleConfigurationOverrides.hashCode());
        result = result * 31 + (this.toolExecutionNotifications == null ? 0 : this.toolExecutionNotifications.hashCode());
        result = result * 31 + (this.machine == null ? 0 : this.machine.hashCode());
        result = result * 31 + (this.environmentVariables == null ? 0 : this.environmentVariables.hashCode());
        result = result * 31 + (this.stdoutStderr == null ? 0 : this.stdoutStderr.hashCode());
        result = result * 31 + (this.arguments == null ? 0 : this.arguments.hashCode());
        result = result * 31 + (this.responseFiles == null ? 0 : this.responseFiles.hashCode());
        result = result * 31 + (this.commandLine == null ? 0 : this.commandLine.hashCode());
        result = result * 31 + (this.executionSuccessful == null ? 0 : this.executionSuccessful.hashCode());
        result = result * 31 + (this.startTimeUtc == null ? 0 : this.startTimeUtc.hashCode());
        result = result * 31 + (this.account == null ? 0 : this.account.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        result = result * 31 + (this.exitSignalName == null ? 0 : this.exitSignalName.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Invocation)) {
            return false;
        }
        Invocation rhs = (Invocation)other;
        return (this.endTimeUtc == rhs.endTimeUtc || this.endTimeUtc != null && this.endTimeUtc.equals(rhs.endTimeUtc)) && (this.stdin == rhs.stdin || this.stdin != null && this.stdin.equals(rhs.stdin)) && (this.stdout == rhs.stdout || this.stdout != null && this.stdout.equals(rhs.stdout)) && (this.workingDirectory == rhs.workingDirectory || this.workingDirectory != null && this.workingDirectory.equals(rhs.workingDirectory)) && (this.exitSignalNumber == rhs.exitSignalNumber || this.exitSignalNumber != null && this.exitSignalNumber.equals(rhs.exitSignalNumber)) && (this.exitCodeDescription == rhs.exitCodeDescription || this.exitCodeDescription != null && this.exitCodeDescription.equals(rhs.exitCodeDescription)) && (this.executableLocation == rhs.executableLocation || this.executableLocation != null && this.executableLocation.equals(rhs.executableLocation)) && (this.processId == rhs.processId || this.processId != null && this.processId.equals(rhs.processId)) && (this.exitCode == rhs.exitCode || this.exitCode != null && this.exitCode.equals(rhs.exitCode)) && (this.toolConfigurationNotifications == rhs.toolConfigurationNotifications || this.toolConfigurationNotifications != null && this.toolConfigurationNotifications.equals(rhs.toolConfigurationNotifications)) && (this.notificationConfigurationOverrides == rhs.notificationConfigurationOverrides || this.notificationConfigurationOverrides != null && this.notificationConfigurationOverrides.equals(rhs.notificationConfigurationOverrides)) && (this.processStartFailureMessage == rhs.processStartFailureMessage || this.processStartFailureMessage != null && this.processStartFailureMessage.equals(rhs.processStartFailureMessage)) && (this.stderr == rhs.stderr || this.stderr != null && this.stderr.equals(rhs.stderr)) && (this.ruleConfigurationOverrides == rhs.ruleConfigurationOverrides || this.ruleConfigurationOverrides != null && this.ruleConfigurationOverrides.equals(rhs.ruleConfigurationOverrides)) && (this.toolExecutionNotifications == rhs.toolExecutionNotifications || this.toolExecutionNotifications != null && this.toolExecutionNotifications.equals(rhs.toolExecutionNotifications)) && (this.machine == rhs.machine || this.machine != null && this.machine.equals(rhs.machine)) && (this.environmentVariables == rhs.environmentVariables || this.environmentVariables != null && this.environmentVariables.equals(rhs.environmentVariables)) && (this.stdoutStderr == rhs.stdoutStderr || this.stdoutStderr != null && this.stdoutStderr.equals(rhs.stdoutStderr)) && (this.arguments == rhs.arguments || this.arguments != null && this.arguments.equals(rhs.arguments)) && (this.responseFiles == rhs.responseFiles || this.responseFiles != null && this.responseFiles.equals(rhs.responseFiles)) && (this.commandLine == rhs.commandLine || this.commandLine != null && this.commandLine.equals(rhs.commandLine)) && (this.executionSuccessful == rhs.executionSuccessful || this.executionSuccessful != null && this.executionSuccessful.equals(rhs.executionSuccessful)) && (this.startTimeUtc == rhs.startTimeUtc || this.startTimeUtc != null && this.startTimeUtc.equals(rhs.startTimeUtc)) && (this.account == rhs.account || this.account != null && this.account.equals(rhs.account)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties)) && (this.exitSignalName == rhs.exitSignalName || this.exitSignalName != null && this.exitSignalName.equals(rhs.exitSignalName));
    }
}

