/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.initialization.EvaluateSettingsBuildOperationType;
import org.gradle.initialization.SettingsLocation;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.initialization.SettingsState;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;

public class BuildOperationSettingsProcessor
implements SettingsProcessor {
    private static final EvaluateSettingsBuildOperationType.Result RESULT = new EvaluateSettingsBuildOperationType.Result(){};
    private final SettingsProcessor settingsProcessor;
    private final BuildOperationRunner buildOperationRunner;

    public BuildOperationSettingsProcessor(SettingsProcessor settingsProcessor, BuildOperationRunner buildOperationRunner) {
        this.settingsProcessor = settingsProcessor;
        this.buildOperationRunner = buildOperationRunner;
    }

    @Override
    public SettingsState process(final GradleInternal gradle, final SettingsLocation settingsLocation, final ClassLoaderScope buildRootClassLoaderScope, final StartParameter startParameter) {
        return (SettingsState)this.buildOperationRunner.call((CallableBuildOperation)new CallableBuildOperation<SettingsState>(){

            public SettingsState call(BuildOperationContext context) {
                SettingsState state = BuildOperationSettingsProcessor.this.settingsProcessor.process(gradle, settingsLocation, buildRootClassLoaderScope, startParameter);
                context.setResult((Object)RESULT);
                return state;
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)gradle.contextualize("Evaluate settings")).progressDisplayName("Evaluating settings").details((Object)new EvaluateSettingsBuildOperationType.Details(){

                    public String getBuildPath() {
                        return gradle.getIdentityPath().toString();
                    }

                    public String getSettingsDir() {
                        return settingsLocation.getSettingsDir().getAbsolutePath();
                    }

                    public String getSettingsFile() {
                        File settingsFile = settingsLocation.getSettingsFile();
                        return settingsFile != null ? settingsFile.getPath() : null;
                    }
                });
            }
        });
    }
}

