/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.typehandling;

import java.util.Optional;

public class GroovyCastException
extends ClassCastException {
    private static final long serialVersionUID = 6859089155641797356L;

    public GroovyCastException(Object objectToCast, Class classToCastTo, Exception cause) {
        super(GroovyCastException.makeMessage(objectToCast, classToCastTo) + " due to: " + cause.getClass().getName() + Optional.ofNullable(cause.getMessage()).map(msg -> ": " + msg).orElse(""));
    }

    public GroovyCastException(Object objectToCast, Class classToCastTo) {
        super(GroovyCastException.makeMessage(objectToCast, classToCastTo));
    }

    public GroovyCastException(String message) {
        super(message);
    }

    private static String makeMessage(Object object, Class<?> target) {
        if (object == null) {
            return "Cannot cast 'null' to class '" + target.getName() + "'" + GroovyCastException.getWrapper(target);
        }
        return "Cannot cast object '" + object + "' with class '" + object.getClass().getName() + "' to class '" + target.getName() + "'";
    }

    private static String getWrapper(Class<?> cls) {
        Class<Object> ncls = cls;
        if (cls == Byte.TYPE) {
            ncls = Byte.class;
        } else if (cls == Short.TYPE) {
            ncls = Short.class;
        } else if (cls == Character.TYPE) {
            ncls = Character.class;
        } else if (cls == Integer.TYPE) {
            ncls = Integer.class;
        } else if (cls == Long.TYPE) {
            ncls = Long.class;
        } else if (cls == Float.TYPE) {
            ncls = Float.class;
        } else if (cls == Double.TYPE) {
            ncls = Double.class;
        }
        if (cls != null && ncls != cls) {
            String msg = ". Try '" + ncls.getName() + "' instead";
            return msg;
        }
        return "";
    }
}

