#     Copyright (C) 2023 Intel Corporation.  All Rights Reserved.

#     This file is part of SEP Development Kit

#     SEP Development Kit is free software; you can redistribute it
#     and/or modify it under the terms of the GNU General Public License
#     version 2 as published by the Free Software Foundation.

#     SEP Development Kit is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     You should have received a copy of the GNU General Public License
#     along with SEP Development Kit; if not, write to the Free Software
#     Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#     As a special exception, you may use this file as part of a free software
#     library without restriction.  Specifically, if other files instantiate
#     templates or use macros or inline functions from this file, or you compile
#     this file and link it with other files to produce an executable, this
#     file does not by itself cause the resulting executable to be covered by
#     the GNU General Public License.  This exception does not however
#     invalidate any other reasons why the executable file might be covered by
#     the GNU General Public License.

# Description: Specification for building an RPM package for SEP kernel modules


Name: %{NAME}
Version: %{VERS}
Release: %{BUILD_RELEASE}
Summary: SEP/EMON Driver for Intel(R) VTune Amplifier XE for Systems
%define _rpmfilename %{NAME}-%{VERS}-%{release}.%{ARCH}.rpm

Group:		System/Kernel
License:	Private
URL: 	    http://software.intel.com/en-US/software-tools-for-developers-worldwide
Distribution: 	Intel Corporation
Source0:	%{name}-%{VERS}.tar.gz
BuildRoot:	%(mktemp -ud %{_tmppath}/%{name}-%{kernel_version}-%{release}-XXXXXX)

%{?systemd_requires}

%description
Intel VTune Sampling Drivers

%prep
%setup -q

%install
mkdir -p %{buildroot}/opt/intel/%{name}-%{kernel_version}
cp %{SEP_DRIVER_NAME}-%{ARCH}-%{kernel_version}%{ARITY}.ko %{buildroot}/opt/intel/%{name}-%{kernel_version}
cp insmod-sep %{buildroot}/opt/intel/%{name}-%{kernel_version}
cp rmmod-sep %{buildroot}/opt/intel/%{name}-%{kernel_version}
cp boot-script %{buildroot}/opt/intel/%{name}-%{kernel_version}
mkdir -p %{buildroot}/opt/intel/%{name}-%{kernel_version}/pax
cp pax/pax-%{ARCH}-%{kernel_version}%{ARITY}.ko %{buildroot}/opt/intel/%{name}-%{kernel_version}/pax
cp pax/insmod-pax %{buildroot}/opt/intel/%{name}-%{kernel_version}/pax
cp pax/rmmod-pax %{buildroot}/opt/intel/%{name}-%{kernel_version}/pax
%if %{IS_VTUNE_BUILD} == 1
mkdir -p %{buildroot}/opt/intel/%{name}-%{kernel_version}/vtsspp
cp vtsspp/vtsspp-%{ARCH}-%{kernel_version}%{ARITY}.ko %{buildroot}/opt/intel/%{name}-%{kernel_version}/vtsspp
cp vtsspp/insmod-vtsspp %{buildroot}/opt/intel/%{name}-%{kernel_version}/vtsspp
cp vtsspp/rmmod-vtsspp %{buildroot}/opt/intel/%{name}-%{kernel_version}/vtsspp
mkdir -p %{buildroot}/opt/intel/%{name}-%{kernel_version}/socwatch/drivers
cp socwatch/drivers/socwatch2_15-%{ARCH}-%{kernel_version}%{ARITY}.ko %{buildroot}/opt/intel/%{name}-%{kernel_version}/socwatch/drivers
cp socwatch/drivers/insmod-socwatch %{buildroot}/opt/intel/%{name}-%{kernel_version}/socwatch/drivers
cp socwatch/drivers/rmmod-socwatch %{buildroot}/opt/intel/%{name}-%{kernel_version}/socwatch/drivers
%endif

%post
/opt/intel/%{name}-%{kernel_version}/rmmod-sep -s
/opt/intel/%{name}-%{kernel_version}/boot-script -i -g %{DRIVER_GROUP}

%preun
/opt/intel/%{name}-%{kernel_version}/rmmod-sep -s
/opt/intel/%{name}-%{kernel_version}/boot-script -u

%postun
rm -rf /opt/intel/%{name}-%{kernel_version}

%files
%defattr(-,root,root,-)
/opt/intel/%{name}-%{kernel_version}/%{SEP_DRIVER_NAME}-%{ARCH}-%{kernel_version}%{ARITY}.ko
/opt/intel/%{name}-%{kernel_version}/insmod-sep
/opt/intel/%{name}-%{kernel_version}/rmmod-sep
/opt/intel/%{name}-%{kernel_version}/boot-script
/opt/intel/%{name}-%{kernel_version}/pax/pax-%{ARCH}-%{kernel_version}%{ARITY}.ko
/opt/intel/%{name}-%{kernel_version}/pax/insmod-pax
/opt/intel/%{name}-%{kernel_version}/pax/rmmod-pax
%if %{IS_VTUNE_BUILD} == 1
/opt/intel/%{name}-%{kernel_version}/vtsspp/vtsspp-%{ARCH}-%{kernel_version}%{ARITY}.ko
/opt/intel/%{name}-%{kernel_version}/vtsspp/insmod-vtsspp
/opt/intel/%{name}-%{kernel_version}/vtsspp/rmmod-vtsspp
/opt/intel/%{name}-%{kernel_version}/socwatch/drivers/socwatch2_15-%{ARCH}-%{kernel_version}%{ARITY}.ko
/opt/intel/%{name}-%{kernel_version}/socwatch/drivers/insmod-socwatch
/opt/intel/%{name}-%{kernel_version}/socwatch/drivers/rmmod-socwatch
%endif
