/*******************************************************************************
* Copyright (C) 2005 Intel Corporation
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
 *
 * dfftw_plan_dft_r2c_1d - FFTW3 Fortran 77 wrapper to Intel(R) oneAPI Math Kernel Library (Intel(R) oneMKL).
 *
 ******************************************************************************
 */

#include "fftw3_mkl_f77.h"
#ifdef DFT_ENABLE_OFFLOAD
#include "oneapi/mkl/export.hpp"
#include "fftw3_omp_offload_common.h"

DLL_EXPORT void
dfftw_plan_dft_r2c_1d_omp_offload(PLAN *p, INTEGER *n, REAL8 *in, COMPLEX16 *out,
                      INTEGER *flags, void *interopObj)
{
    INTEGER one = 1;
    dfftw_plan_dft_r2c_omp_offload_impl(p, &one, n, in, out, flags, interopObj);
}

DLL_EXPORT void
dfftw_plan_dft_r2c_1d_cpu(PLAN *p, INTEGER *n, REAL8 *in, COMPLEX16 *out,
                      INTEGER *flags)
{
    dfftw_plan_dft_r2c_1d(p, n, in, out, flags);
}
#else
void
dfftw_plan_dft_r2c_1d(PLAN *p, INTEGER *n, REAL8 *in, COMPLEX16 *out,
                      INTEGER *flags)
{
    INTEGER one = 1;
    dfftw_plan_dft_r2c(p, &one, n, in, out, flags);
}
#endif
