from.base_row import BaseRow,Traffic,prepare_memory_objects
from.import cpurow_helpers as Row
from apm_helpers.justifiedbool import JustifiedBool
from apm_helpers.decorator import cached_cls_prop,cached_cls_prop_extra
from apm_helpers.messages import Messages as msg
NonOffloadReasons=msg.NonOffload.Reasons
from functools import reduce
from collections import defaultdict
import re
import sys
maxsize=float('inf')
_TD_ROW_SUPPORTED_REGION_DESC={'omp':{'detect':Row.is_openmp,'find_loops':Row.find_inner_loops,},'dpcpp':{'detect':Row.is_opencl_kernel_call,'find_loops':Row.find_inner_loops,},'daal':{'detect':Row.is_daal_threader,'find_loops':Row.find_inner_loops,},'tbb':{'detect':Row.is_tbb_dispatch_loop,'find_loops':Row.find_outer_user_loop,},'ocl':{'detect':lambda:False,'find_loops':lambda:[],},}
class CpuRow(BaseRow):
 ignored_module_types=[]
 force_ignore_assembly=False
 def exclude_extra_cache_levels(self):
  if self._baseline_cache_sizes:
   for mem_type,cache_sizes in self._baseline_cache_sizes.items():
    if mem_type not in self._traffic:
     continue
    expected_lvls=len(cache_sizes)
    try:
     traffic=self._traffic[mem_type].by_level
     if len(traffic)>expected_lvls+1:
      self._traffic[mem_type].by_level=traffic[:expected_lvls]+[traffic[-1]]
    except KeyError:
     raise
  else:
   for mem_type,traffic in self._traffic.items():
    if len(traffic.by_level)<2:
     continue
    last_idx=len(traffic.by_level)-1
    while last_idx>0 and not any(traffic.by_level[last_idx-1]):
     last_idx-=1
    traffic.by_level=traffic.by_level[:last_idx]+[traffic.by_level[-1]]
 def set_base_memory_config(self,*args,**kwargs):
  super().set_base_memory_config(*args,**kwargs)
  self.exclude_extra_cache_levels()
 def get_flex_mem_traffic(self,cache_sizes):
  res={}
  for key in cache_sizes:
   if self._row.bottom_up:
    res[key]=list((self._callchain_weight*r,self._callchain_weight*w)for r,w in self._row.bottom_up.get_flex_cachesim_data(cache_sizes[key]))
   else:
    res[key]=self._row.top_down.get_flex_cachesim_data(cache_sizes[key])
  return res
 def get_time_in_library(self,library_name):
  return Row.get_time_in_library(self._row,library_name)
def get_dependency(row):
 if row._is_function or not row._bu_row:
  return{}
 res={}
 dep_type,has_dep=Row.get_dependency_type(row._bu_row)
 res['dependency_type']=dep_type
 res['has_dependency']=has_dep
 res['dependency_key']=Row.get_dependency_key(dep_type)
 res['dependent_iterations_distance']=1 if has_dep else maxsize
 return res
class HotspotRow(CpuRow):
 @staticmethod
 def get_key(row):
  return(row['key_column'],row.is_bottomup)
 SUPPORTED_REGION_DESC=_TD_ROW_SUPPORTED_REGION_DESC
 check_bottom_up=True
 lazy_data=[{'items':['dependency_type','dependency_key','dependent_iterations_distance','has_dependency',],'getter':get_dependency,}]
 @property
 def basic_blocks(self):
  try:
   return Row.get_basic_blocks(self._row)
  except AttributeError:
   return[]
 def __init__(self,row,key,minor_rows):
  def get_total_val(rows,getter,combiner=lambda x,y:x+y,fallback=0):
   return reduce(combiner,(getter(row)for row in rows))if rows else fallback
  super().__init__(row,key,minor_rows)
  self._data['key_column']=key[0]
  for t,s in(('unique_index','unique_index'),('loop_function_id','loop_function_id'),('source_location','source_location'),('function_call_sites_and_loops','function_call_sites_and_loops'),('type','type'),('module','module'),):
   self._data[t]=row[s]
  for t,s in(('total_time','total_time',),('total_elapsed_time','total_elapsed_time',),('self_time','self_time',),('self_elapsed_time','self_elapsed_time',),('self_time_per_largest_thread','self_time_per_largest_thread',0.0),('total_time_per_largest_thread','total_time_per_largest_thread',0.0),('total_gflop','total_gflop'),('self_gflop','self_gflop'),):
   self._data[t]=get_total_val(self._all_rows,lambda x:float(x[s])if x[s]else 0.0)
  for t,s in(('total_gflops','total_gflops'),('loop_height','loop_height'),):
   try:
    self._data[t]=float(row[s])
   except ValueError:
    self._data[t]=0.0
  self._is_bottomup=row.is_bottomup
  self._instruction_mix,instr_mix_type,asm_ins_mix_status=Row.get_instruction_mix(row,ignore_assembly=CpuRow.force_ignore_assembly)
  if instr_mix_type==Row.InstructionMixType.ASSEMBLY and Row.is_inlined_function(row):
   instr_mix_type=None
   asm_ins_mix_status=None
   self._instruction_mix={}
  self._source=row.source
  self.sync=row.sync
  self._is_executed=Row.is_executed(row)
  self._is_function=Row.is_function(row)
  self._is_user_function=Row.is_user_function(row)
  self._is_loop=Row.is_loop(row)
  if not row.is_bottomup:
   self._is_offload_candidate=Row.is_offload_candidate(row,relaxed=False)
  self._is_scalar=Row.is_scalar(row)
  if Row.is_in_library(row,'mpi'):
   self._module_type='MPI'
  elif not self._is_user_function:
   self._module_type='SYS'
  self._data['vector_length']=Row.get_vector_length(row)[0]
  self._data['call_count']=Row.get_call_count(row,check_bottom_up=HotspotRow.check_bottom_up)
  self._data['trip_count_total']=Row.get_trip_count_total(row)
  self._data['trip_count_average']=Row.get_avg_trip_count(row)
  self._data['execution_count']=Row.get_ex_count(row)
  self._data['location']=Row.get_location(row)
  ex_count=self._data['source_execution_count']=get_total_val(self._all_rows,lambda x:Row.get_ex_count(x)*Row.get_vector_length(x)[0])
  self._data['source_iterations']=ex_count/self._data['call_count']
  if(self._data['call_count']and not row['call_count'])or(not Row.is_function(row)and self._data['trip_count_total']and not row['trip_count_total']):
   self._diagnostics.append(msg.Diagnostics.AGGREGATED_EXECUTION_COUNT)
  asm_ins_mix_status_diagnostics={Row.AssemblyInstrMixStatus.ASSEMBLY_UNAVAILABLE:msg.Diagnostics.ASSEMBLY_UNAVAILABLE,Row.AssemblyInstrMixStatus.NO_BASIC_BLOCKS_EXECUTED:msg.Diagnostics.NO_EXECUTED_BASIC_BLOCK}
  if asm_ins_mix_status in asm_ins_mix_status_diagnostics:
   self._diagnostics.append(asm_ins_mix_status_diagnostics[asm_ins_mix_status])
  instr_mix_type_diagnostics={Row.InstructionMixType.TD_DYNAMIC:msg.Diagnostics.TOPDOWN_DYNAMIC_INSTR_MIX_USED,Row.InstructionMixType.BU_STATIC:msg.Diagnostics.BOTTOMUP_STATIC_INSTR_MIX_USED,Row.InstructionMixType.BU_DYNAMIC:msg.Diagnostics.BOTTOMUP_DYNAMIC_INSTR_MIX_USED,}
  if instr_mix_type in instr_mix_type_diagnostics:
   self._diagnostics.append(instr_mix_type_diagnostics[instr_mix_type])
  for k,v in _TD_ROW_SUPPORTED_REGION_DESC.items():
   if v['detect'](row):
    self._data['programming_model']=k
    if self._data['programming_model']and not self._is_user_function:
     self._module_type=k.upper()
    break
  self._data['module_type']=self._module_type
  self._data['total_time_in_mpi']=sum(Row.get_time_in_library(x,'mpi')for x in self._all_rows)
  self._data['total_time_in_system_modules']=Row.get_system_call_time(row)
  self._traffic['global']=global_traffic=Traffic()
  for level in('1','2','3','4','external'):
   lres=0.0,0.0
   for z in self._all_rows:
    lres=tuple(x+y for x,y in zip(lres,Row.get_bw_usage(z,level)[1:]))
   if level=='1':
    global_traffic.carm=lres
   global_traffic.by_level.append(lres)
  if not any(global_traffic.by_level[0]):
   self._diagnostics.append(msg.Diagnostics.NO_CACHE_MEMORY_DATA)
  for x in 'self','total':
   elapsed_key=x+'_elapsed_time'
   time_key=x+'_time'
   self._data[elapsed_key]=min(self._data[elapsed_key],self._data[time_key])
  self._bu_row=bu_row=Row.get_bottom_up(row)
  if bu_row:
   self._is_vector_loop=self._is_loop and self._data['vector_length']>1 and(Row.is_compiler_proven_parallel(bu_row)or Row.is_compiler_explicit_parallel(bu_row))
   self._data_transferred=Row.get_data_transferred(bu_row)
   self._total_strides=Row.get_total_strides(bu_row)
   self._mem_stat=Row.get_mem_stat(bu_row)
   self._memory_footprint=Row.get_memory_footprint(bu_row)
   self._code_size=Row.get_loop_size(bu_row)
   self._callchain_weight=get_callchain_weight(row,bu_row)
  self._lazy_items={'total_time_in_ignored':{'together':['total_time_in_ignored'],'getter':lambda:{'total_time_in_ignored':ignored_getter(self)},},**{item:{'together':x['items'],'getter':x['getter']}for x in self.lazy_data for item in x['items']},}
 def _fill_call_stack_based_metrics(self,row):
  par_row=self
  while par_row._parent:
   par_row=par_row._parent
   if par_row['vector_length']>1:
    vector_len=par_row._data['vector_length']
    break
  else:
   vector_len=self._data['vector_length']
  self._data['simd_width']=vector_len
  self._data['instance_count']=self._data['call_count']*vector_len/self._data['vector_length']
 @staticmethod
 def _get_extra_rows(row):
  if Row.get_bottom_up(row):
   return[Row.get_bottom_up(row)]
  else:
   return[]
 @staticmethod
 def filter_children(row):
  stack=[]
  loops=defaultdict(list)
  for child in row.get_children():
   if not Row.is_executed(child):
    continue
   if Row.is_loop(child)and 'source_location' in child and child['source_location']:
    loops[child['source_location']].append(child)
   else:
    stack.append((child,[]))
  for _,loop_rows in loops.items():
   loop_rows.sort(key=lambda loop:-float(loop['total_time']))
   stack.append((loop_rows[0],loop_rows[1:]))
  return stack
 @property
 def memory_objects(self):
  if self._memory_objects is None:
   self._memory_objects=[]
   if self._bu_row:
    self._memory_objects=prepare_memory_objects(self._bu_row.memory_objects)
  return self._memory_objects
 def get_flex_mem_traffic(self,cache_sizes):
  return self._bu_row.get_flex_cachesim_data(cache_sizes)
def create_joint_row_cls(row_types_getter):
 class JointRow(CpuRow):
  @staticmethod
  def get_key(row):
   return row['key']
  SUPPORTED_REGION_DESC={k:{'find_loops':lambda*args:[args[0]]}for k in _TD_ROW_SUPPORTED_REGION_DESC}
  def __init__(self,row,key,minor_rows):
   def get_total_val(rows,getter,combiner=lambda x,y:x+y,fallback=0):
    return reduce(combiner,(getter(row)for row in rows))if rows else fallback
   super().__init__(row,key,minor_rows)
   missed_metrics=[]
   try:
    metadata_types=row_types_getter(row)
    self._is_function=not metadata_types.is_loop
    self._is_loop=metadata_types.is_loop
   except ValueError:
    self._is_function=False
    self._is_loop=False
    missed_metrics.append('metadata_types')
   self._source=row.top_down.source
   self._is_bottomup=False
   if self._is_loop:
    try:
     self._data['has_dependency']=row.distance_between_dependent_iterations<=1
    except TypeError:
     self._data['has_dependency']=True
   self._is_executed=row.execution_count is not None and row.execution_count>0
   self._is_offload_candidate=JustifiedBool(*row.is_offload_candidate)
   for x,y in(('key_column','key'),('unique_index','cli_id'),('loop_function_id','key'),):
    res=getattr(row,y)
    self._data[x]=str(res)if res is not None else ''
   for x,y in(('source_location','source'),('function_call_sites_and_loops','loop_function'),('dependency_type','dependency_type'),):
    self._data[x]=getattr(row,y)
   for x,y,z in(('total_time','total_time',0.0),('total_elapsed_time','total_elapsed_time',0.0),('self_time','self_time',0.0),('self_elapsed_time','self_elapsed_time',0.0),('self_time_per_largest_thread','self_time_per_largest_thread',0.0),('total_time_per_largest_thread','total_time_per_largest_thread',0.0),('total_time_in_mpi','total_time_in_mpi_calls',0.0),('total_time_in_system_modules','total_time_in_system_calls',0.0),('total_time_in_openmp_calls','total_time_in_openmp_calls',0.0),('total_time_in_dpc_calls','total_time_in_dpc_calls',0.0),('total_time_in_tbb_calls','total_time_in_tbb_calls',0.0),('total_time_in_opencl_calls','total_time_in_opencl_calls',0.0),('total_time_in_daal_calls','total_time_in_daal_calls',0.0),):
    try:
     self._data[x]=get_total_val(self._all_rows,lambda r:getattr(r,y)if getattr(r,y)else 0.0)
    except TypeError:
     self._data[x]=z
     missed_metrics.append(x)
   self._data['total_time_in_system_modules']+=self._data['total_time_in_openmp_calls']+self._data['total_time_in_dpc_calls']+self._data['total_time_in_tbb_calls']+self._data['total_time_in_opencl_calls']+self._data['total_time_in_daal_calls']+self._data['total_time_in_mpi']
   for x,y,z,loop_only in(('call_count','call_count',1.0,False),('trip_count_total','total_trip_counts',1.0,True),('trip_count_average','average_trip_counts',1.0,True),('execution_count','execution_count',1.0,False),('instance_count','source_instance_count',1.0,False),('source_execution_count','source_execution_count',1.0,False),('source_iterations','average_iteration_count',1.0,True),):
    try:
     if loop_only and not self._is_loop:
      self._data[x]=None
     else:
      self._data[x]=float(getattr(row,y))
    except TypeError:
     self._data[x]=z
     missed_metrics.append(x)
   if self._is_loop:
    self._data['trip_count_average']=self._data['trip_count_total']/self._data['call_count']
   for x,y,z,loop_only in(('vector_length','vector_length',1,True),('simd_width','simd_width',1,False),('loop_height','loop_nesting_level',maxsize,True),('dependent_iterations_distance','distance_between_dependent_iterations',maxsize,True),):
    try:
     if loop_only and not self._is_loop:
      self._data[x]=None
     else:
      self._data[x]=int(getattr(row,y))
    except TypeError:
     self._data[x]=z
     missed_metrics.append(x)
   if self._is_loop:
    self._is_vector_loop=self._data['vector_length']>1
   self._is_scalar=self._data['simd_width']==1
   for x,y,is_tuple in(('global_size','global_size',True),('local_size','local_size',True),('instance_count','kernel_invocation_count',False),):
    for cpu_kernel_info in row.cpu_kernel_info:
     workload_data=getattr(cpu_kernel_info,y,0)
     if workload_data>0:
      self._data[x]=(workload_data,)if is_tuple else workload_data
   programming_model=row.programming_model
   if 'OMP' in programming_model:
    self._data['programming_model']='omp'
   else:
    self._data['programming_model']=programming_model.lower()
   self._data['type']=''
   self._data['module']=row.module
   self._data['module_type']=self._module_type=row.module_type
   self._is_user_function=row.module_type=='USR'
   if self._is_loop:
    self._data['location']=row.loop_function
   elif self._is_function and row.source:
    self._data['location']='{} at {}'.format(row.loop_function,row.source)
   else:
    self._data['location']=row.loop_function
   self._traffic['global']=global_traffic=Traffic()
   for x in row.memory_traffic:
    lvl_traffic=(x.loaded_bytes,x.stored_bytes)
    if x.memory_level==0:
     global_traffic.carm=lvl_traffic
    global_traffic.by_level.append(lvl_traffic)
   if global_traffic.by_level and not any(global_traffic.by_level[0]):
    self._diagnostics.append(msg.Diagnostics.NO_CACHE_MEMORY_DATA)
   if self._is_loop:
    for d,s in(('in','memory_mapped_to_device'),('out','memory_mapped_from_device'),('inout','memory_mapped_tofrom_device'),('shared','data_transferred_shared'),):
     try:
      self._data_transferred[d]=float(getattr(row,s))
     except TypeError:
      self._data_transferred[d]=0.0
      missed_metrics.append(s)
   self._data['total_gflop']=0.0
   self._data['total_gflops']=0.0
   self._data['total_ai']=0.0
   self._callchain_weight=row.call_chain_weight
   for x,y,z in(('self_gflop','self_gflop',0.0),('self_gintop','self_gintop',0.0),('self_memory_gb','self_memory_gb',0.0),('self_l2_gb','self_l2_gb',0.0),('self_l3_gb','self_l3_gb',0.0),('self_l4_gb','self_l4_gb',0.0),('self_dram_gb','self_dram_gb',0.0),):
    try:
     self._data[x]=get_total_val(self._all_rows,lambda r:float(getattr(r.top_down,y))if getattr(r.top_down,y)else 0.0)
    except TypeError:
     self._data[x]=z
     missed_metrics.append(x)
   for x,y,z in(('self_int_compute','self_int_compute',0),('self_sp_compute','self_sp_compute',0),('self_dp_compute','self_dp_compute',0),('self_int_compute_with_memory','self_int_compute_with_memory',0),('self_sp_compute_with_memory','self_sp_compute_with_memory',0),('self_dp_compute_with_memory','self_dp_compute_with_memory',0),('self_memory','self_memory',0),('thread_count','thread_count',0),):
    try:
     self._data[x]=get_total_val(self._all_rows,lambda r:int(getattr(r.top_down,y))if getattr(r.top_down,y)else 0)
    except TypeError:
     self._data[x]=z
     missed_metrics.append(x)
   if missed_metrics:
    self._diagnostics.append('Fallback implemented for {}'.format(','.join(missed_metrics)))
   self._lazy_items['total_time_in_ignored']={'together':['total_time_in_ignored'],'getter':lambda:{'total_time_in_ignored':ignored_getter(self)},}
   self._memory_objects=self._get_memory_objects(row)
  def _calc_instruction_mix(self,row):
   has_mix=False
   if row.instruction_mix:
    ins_mix=defaultdict(lambda:0.0)
    has_dyn_instr_mix=any(ins.dynamic_operation_count for ins in row.instruction_mix)
    exec_count=self._data['source_execution_count']
    simd_width=self._data['simd_width']
    for ins in row.instruction_mix:
     has_mix=True
     key=(ins.instruction_type.lower(),ins.data_type,ins.data_size,'global' if ins.is_memory else '',)
     if has_dyn_instr_mix:
      ins_mix[key]+=ins.dynamic_operation_count/exec_count
     else:
      ins_mix[key]+=ins.operation_count/simd_width
     self._code_size+=16*ins.operation_count
    self._instruction_mix=dict(ins_mix)
   if has_mix:
    if not has_dyn_instr_mix:
     self._diagnostics.append(msg.Diagnostics.DETAILED_STATIC_INSTR_MIX_USED)
   else:
    self._instruction_mix,instr_mix_type,_=Row.get_instruction_mix(row.top_down,ignore_assembly=True)
    for val in self._instruction_mix.values():
     self._code_size+=val
    instr_mix_type_diagnostics={Row.InstructionMixType.TD_DYNAMIC:msg.Diagnostics.TOPDOWN_DYNAMIC_INSTR_MIX_USED,Row.InstructionMixType.BU_STATIC:msg.Diagnostics.BOTTOMUP_STATIC_INSTR_MIX_USED,Row.InstructionMixType.BU_DYNAMIC:msg.Diagnostics.BOTTOMUP_DYNAMIC_INSTR_MIX_USED,}
    if instr_mix_type in instr_mix_type_diagnostics:
     self._diagnostics.append(instr_mix_type_diagnostics[instr_mix_type])
  @staticmethod
  def _get_extra_rows(self):
   return[]
  @staticmethod
  def filter_children(row):
   stack=[]
   loops=defaultdict(list)
   for child in row.get_children():
    metadata_types=row_types_getter(child)
    if metadata_types.is_not_executed:
     continue
    if metadata_types.is_loop and 'source_location' in child and child['source_location']:
     loops[child['source_location']].append(child)
    else:
     stack.append((child,[]))
   for _,loop_rows in loops.items():
    loop_rows.sort(key=lambda loop:-loop.total_time)
    stack.append((loop_rows[0],loop_rows[1:]))
   return stack
  def _get_memory_objects(self,row):
   res=[]
   if row:
    try:
     res=prepare_memory_objects(row.memory_objects)
    except KeyError:
     self._diagnostics.append('Can\'t load memory objects')
   return res
  @property
  def memory_objects(self):
   if self._memory_objects is None:
    self._memory_objects=self._get_memory_objects(self._row)
   return self._memory_objects
  def _fill_call_stack_based_metrics(self,row):
   if self._is_loop:
    par_row=self
    while par_row._parent:
     par_row=par_row._parent
     if par_row._is_loop:
      break
     elif par_row._data['global_size']:
      self._data['instance_count']=par_row._data['instance_count']
      self._data['source_iterations']=reduce(lambda x,y:x*y,par_row._data['global_size'])
      self._data['source_execution_count']=par_row._data['instance_count']*self._data['source_iterations']
      break
   self._calc_instruction_mix(row)
 return JointRow
class SplittedLoop(object):
 SCALAR=1
 VECTOR=2
 WHOLE=4
 MAJOR=8
 MINOR=16
 def __init__(self,section_type,rows=[],loop_types=0):
  self.splitted_section_type=section_type
  self.splitted_loop_types=loop_types
  self.splitted_loop_list=[rows]if self.is_whole else rows
 def get_type(self):
  return self.splitted_section_type
 def get_rows(self):
  return self.splitted_loop_list
 def get_total_val(self,getter,combiner=lambda x,y:x+y,fallback=0):
  return reduce(combiner,(getter(row)for row in self.splitted_loop_list))if self.splitted_loop_list else fallback
 @cached_cls_prop
 def get_total_times(self):
  return self.get_total_val(lambda x:float(x['total_time']))
 @cached_cls_prop
 def get_self_times(self):
  return self.get_total_val(lambda x:float(x['self_time']))
 @cached_cls_prop_extra('check_bottom_up')
 def get_ex_count(self,check_bottom_up=False):
  return self.get_total_val(lambda x:x['execution_count']*x['vector_length'])
 @property
 def is_whole(self):
  return self.splitted_section_type==self.WHOLE
 @property
 def is_major(self):
  return self.splitted_section_type==self.MAJOR
 @property
 def is_minor(self):
  return self.splitted_section_type==self.MINOR
 @property
 def is_scalar(self):
  return(self.splitted_loop_types&self.SCALAR)==self.SCALAR
def get_splitted_loops(head_rows):
 if not head_rows:
  return{}
 res={}
 for top_row in head_rows:
  res[top_row['key_column']]=SplittedLoop(SplittedLoop.WHOLE,rows=top_row)
  rows=[top_row]
  while rows:
   curr_row=rows.pop()
   loops_to_be_grouped=defaultdict(list)
   for child in curr_row.children:
    rows.append(child)
    if not child.is_executed:
     scalar_vector_type=SplittedLoop.SCALAR if child.is_scalar else SplittedLoop.VECTOR
     res[child['key_column']]=SplittedLoop(SplittedLoop.MINOR,loop_types=scalar_vector_type)
     continue
    if child.is_function:
     res[child['key_column']]=SplittedLoop(SplittedLoop.WHOLE,rows=child)
    else:
     loops_to_be_grouped[child['source_location']].append(child)
   for _,loop_rows in loops_to_be_grouped.items():
    if len(loop_rows)>1:
     largest_time=0.0
     major_row_idx=0
     foundScalar=False
     foundVector=False
     for idx,loop in enumerate(loop_rows):
      total_time=0.0
      try:
       total_time=float(loop['total_time'])
       if total_time>largest_time:
        major_row_idx=idx
        largest_time=total_time
      except ValueError:
       pass
      if loop.is_scalar:
       foundScalar=True
       scalar_vector_type=SplittedLoop.SCALAR
      else:
       foundVector=True
       scalar_vector_type=SplittedLoop.VECTOR
      res[loop['key_column']]=SplittedLoop(SplittedLoop.MINOR,loop_types=scalar_vector_type)
     major_row=loop_rows[major_row_idx]
     scalar_vector=SplittedLoop.SCALAR if foundScalar else 0
     scalar_vector+=SplittedLoop.VECTOR if foundVector else 0
     split_loop=SplittedLoop(SplittedLoop.MAJOR,rows=loop_rows,loop_types=scalar_vector)
     res[major_row['key_column']]=split_loop
    else:
     res[loop_rows[0]['key_column']]=SplittedLoop(SplittedLoop.WHOLE,rows=loop_rows[0])
 return res
def time_in_ignored_getter(row,ignored_module_types):
 if row['module_type']and row['module_type'].upper()in ignored_module_types:
  try:
   return float(row['self_time_per_largest_thread'])
  except ValueError:
   pass
 return None
get_time_in_ignored=Row.TotalMetricCalculator(time_in_ignored_getter)
def ignored_getter(row):
 return get_time_in_ignored(row,tuple(CpuRow.ignored_module_types))
def get_callchain_weight(row,bu_row=None):
 if bu_row is None:
  bu_row=Row.get_bottom_up(row)
 if bu_row:
  try:
   return min(1.0,float(row['total_time'])/float(bu_row['total_time']))
  except(ValueError,ZeroDivisionError):
   pass
 return 1.0
