#
# Copyright (C) 2017 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#


# ------------------------------------------------------------------------------
# This example shows how to obtain the instruction mix for entries in the
# bottomup table.
# ------------------------------------------------------------------------------

import itertools
import sys

try:

    import advisor

except ImportError:

    print(
        """Import error: Python could not resolve path to Advisor's pythonapi directory.
        To fix, either manually add path to the pythonapi directory into PYTHONPATH environment
        variable, or use advixe-vars.* scripts to set up product environment variables automatically."""
    )
    sys.exit(1)

# Check command-line arguments.
if len(sys.argv) < 2:
    print('Usage: "python {} path_to_project_dir"'.format(__file__))
    sys.exit(2)

# Open the Advisor Project and load the data.
project = advisor.open_project(sys.argv[1])
data = project.load(advisor.ALL)

# Formatting.
fmt = "{:40.40} {:17.17} {:17.17} {:17.17} {:17.17}"

print(fmt.format("loop", "static_self_all", "static_total_all", "dynamic_self_all", "dynamic_total_all",))

# Iteratve over the bottomup table and print the instruction mix for each entry.
for entry in data.bottomup:

    static_self_all = next(entry.static_self_mix)["all_instructions"]
    static_total_all = next(entry.static_total_mix)["all_instructions"]
    dynamic_self_all = next(entry.dynamic_self_mix)["all_instructions"]
    dynamic_total_all = next(entry.dynamic_total_mix)["all_instructions"]
    print(fmt.format(entry["mangled_name"], static_self_all, static_total_all, dynamic_self_all, dynamic_total_all,))

    # Optionally, iterate over instruction mixes.
    #
    # static_self_row = entry.static_self_mix.next()
    # static_self = ["{}: {}".format(key,static_self_row[key]) for key in static_self_row]
    # static_total_row = entry.static_total_mix.next()
    # static_total = ["{}: {}".format(key,static_total_row[key]) for key in static_total_row]
    # dynamic_self_row = entry.dynamic_self_mix.next()
    # dynamic_self = ["{}: {}".format(key,dynamic_self_row[key]) for key in dynamic_self_row]
    # dynamic_total_row = entry.dynamic_total_mix.next()
    # dynamic_total = ["{}: {}".format(key,dynamic_total_row[key]) for key in dynamic_total_row]
    #
    # print alongside mixes for comparison
    # for (m1, m2, m3, m4) in itertools.izip_longest(static_self, static_total, dynamic_self, dynamic_total, fillvalue=' '):
    #     print("{:32.32} {:32.32} {:32.32} {:32.32}".format(m1,m2,m3,m4))
