#
# Copyright (C) 2017 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#


# ------------------------------------------------------------------------------
# This example shows how to obtain match the topdown representation of the data
# with the bottomup representation of the data.
# ------------------------------------------------------------------------------

import sys

try:

    import advisor

except ImportError:

    print(
        """Import error: Python could not resolve path to Advisor's pythonapi directory.
        To fix, either manually add path to the pythonapi directory into PYTHONPATH environment
        variable, or use advixe-vars.* scripts to set up product environment variables automatically."""
    )
    sys.exit(1)

# Check command-line arguments.
if len(sys.argv) < 2:
    print('Usage: "python {} path_to_project_dir"'.format(__file__))
    sys.exit(2)

# Open the Advisor Project and load the data.
project = advisor.open_project(sys.argv[1])
data = project.load(advisor.SURVEY)

print("=" * 8 + "Bottomup to topdown matching" + "=" * 8)
for row in data.bottomup:
    print("bottomup row {}: {}".format(row["loop_function_id"], row["function_call_sites_and_loops"]))
    print(" " * 4 + "topdown sync:")
    for sync_row in row.sync:
        print(
            " " * 4
            + "matched topdown row {}: {}".format(
                sync_row["loop_function_id"], sync_row["function_call_sites_and_loops"]
            )
        )
        for back_row in sync_row.sync:
            if row["function_call_sites_and_loops"] == back_row["function_call_sites_and_loops"]:
                print(" " * 8 + "back sync matched")
            else:
                print(
                    " " * 8
                    + 'ERROR: mismatch in back sync, "{}" and "{}" must be the same'.format(
                        row["function_call_sites_and_loops"], back_row["function_call_sites_and_loops"],
                    )
                )

print("=" * 8 + "Topdown to bottomup matching" + "=" * 8)
for row in data.topdown:
    stack = [(row, 0)]
    while stack:
        v, level = stack.pop()
        for c in v.get_children():
            stack.append((c, level + 1))
            print("topdown row {}: {}".format(v["loop_function_id"], v["function_call_sites_and_loops"]))
            print(" " * 4 + "bottomup sync:")
            for sync_row in v.sync:
                print(
                    " " * 4
                    + "matched bottomup row {}: {}".format(
                        sync_row["loop_function_id"], sync_row["function_call_sites_and_loops"],
                    )
                )
                for back_row in sync_row.sync:
                    if v["function_call_sites_and_loops"] == back_row["function_call_sites_and_loops"]:
                        print(" " * 8 + "back sync matched")
                    else:
                        print(
                            " " * 8
                            + 'ERROR: mismatch in back sync, "{}" and "{}" must be the same'.format(
                                v["function_call_sites_and_loops"], back_row["function_call_sites_and_loops"],
                            )
                        )
