/*
 * Copyright (C) 2020 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.
*/

__kernel void SimpleAdd4(__global float4 *pA, __global float4 *pB, unsigned long iStep, unsigned long iterationsMask, unsigned long kernelIterations)
{
    const unsigned long id = get_global_id(0);
    float4 a = {1.f,1.f,1.f,1.f};
    float4 b = {1.f,1.f,1.f,1.f};

    unsigned long index = id & iterationsMask;
    for (unsigned long i = 0; i < kernelIterations; i++)
    {
        pA[index] = pB[index];
        index = (index + iStep)&iterationsMask;
    }

    if (!iterationsMask)
    {
        pB[id] = a + b;
    }
}
