/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.exceptions;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00060\u0001j\u0002`\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR#\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlinx/dataframe/exceptions/UnequalColumnSizesException;", "Ljava/lang/IllegalArgumentException;", "Lkotlin/IllegalArgumentException;", "expectedRowsCount", "", "columnSizes", "", "Lkotlin/Pair;", "", "<init>", "(ILjava/util/List;)V", "getExpectedRowsCount", "()I", "getColumnSizes", "()Ljava/util/List;", "message", "getMessage", "()Ljava/lang/String;", "core"})
public final class UnequalColumnSizesException
extends IllegalArgumentException {
    private final int expectedRowsCount;
    @NotNull
    private final List<Pair<String, Integer>> columnSizes;

    public UnequalColumnSizesException(int expectedRowsCount, @NotNull List<Pair<String, Integer>> columnSizes) {
        Intrinsics.checkNotNullParameter(columnSizes, (String)"columnSizes");
        this.expectedRowsCount = expectedRowsCount;
        this.columnSizes = columnSizes;
    }

    public final int getExpectedRowsCount() {
        return this.expectedRowsCount;
    }

    @NotNull
    public final List<Pair<String, Integer>> getColumnSizes() {
        return this.columnSizes;
    }

    @Override
    @NotNull
    public String getMessage() {
        return "Unequal column sizes. Expected rows count: " + this.expectedRowsCount + ". Actual column sizes:\n" + CollectionsKt.joinToString$default((Iterable)this.columnSizes, (CharSequence)"\n", null, null, (int)0, null, UnequalColumnSizesException::_get_message_$lambda$0, (int)30, null);
    }

    private static final CharSequence _get_message_$lambda$0(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (String)it.getFirst() + ": " + ((Number)it.getSecond()).intValue();
    }
}

