/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.jvm.FirJvmNamesChecker;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmInvalidAndDangerousCharactersChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmInvalidAndDangerousCharactersChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmInvalidAndDangerousCharactersChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmInvalidAndDangerousCharactersChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n1869#2,2:36\n*S KotlinDebug\n*F\n+ 1 FirJvmInvalidAndDangerousCharactersChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmInvalidAndDangerousCharactersChecker\n*L\n27#1:36,2\n*E\n"})
public final class FirJvmInvalidAndDangerousCharactersChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJvmInvalidAndDangerousCharactersChecker INSTANCE = new FirJvmInvalidAndDangerousCharactersChecker();

    private FirJvmInvalidAndDangerousCharactersChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KtSourceElement source = declaration.getSource();
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirRegularClass) {
            FirJvmNamesChecker.INSTANCE.checkNameAndReport(context, reporter, ((FirRegularClass)declaration).getName(), source);
        } else if (firDeclaration instanceof FirSimpleFunction) {
            FirJvmNamesChecker.INSTANCE.checkNameAndReport(context, reporter, ((FirSimpleFunction)declaration).getName(), source);
        } else if (firDeclaration instanceof FirTypeParameter) {
            FirJvmNamesChecker.INSTANCE.checkNameAndReport(context, reporter, ((FirTypeParameter)declaration).getName(), source);
        } else if (firDeclaration instanceof FirProperty) {
            FirJvmNamesChecker.INSTANCE.checkNameAndReport(context, reporter, ((FirProperty)declaration).getName(), source);
        } else if (firDeclaration instanceof FirTypeAlias) {
            FirJvmNamesChecker.INSTANCE.checkNameAndReport(context, reporter, ((FirTypeAlias)declaration).getName(), source);
        } else if (firDeclaration instanceof FirValueParameter) {
            FirJvmNamesChecker.INSTANCE.checkNameAndReport(context, reporter, ((FirValueParameter)declaration).getName(), source);
        } else if (firDeclaration instanceof FirFile) {
            Iterable $this$forEach$iv = ((FirFile)declaration).getPackageDirective().getPackageFqName().pathSegments();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Name it = (Name)element$iv;
                boolean bl = false;
                FirJvmNamesChecker.INSTANCE.checkNameAndReport(context, reporter, it, ((FirFile)declaration).getPackageDirective().getSource());
            }
        } else {
            return;
        }
    }
}

