/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.generators;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.lazy.Fir2IrLazyClass;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrReplSnippet;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0000\u001a\u001a\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0000\u001a\u001f\u0010\u0007\u001a\u00020\b*\u0004\u0018\u00010\u0004H\u0000\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\b\u0003\u0010\u0000\u001a\u0016\u0010\t\u001a\u00020\b*\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u001c\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0000\u00a8\u0006\u0010"}, d2={"setParent", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "irParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "addDeclarationToParent", "declaration", "isExternalParent", "", "shouldParametersBeAssignable", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "c", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "isEffectivelyExternal", "memberDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFir2IrCallableDeclarationsGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrCallableDeclarationsGenerator.kt\norg/jetbrains/kotlin/fir/backend/generators/Fir2IrCallableDeclarationsGeneratorKt\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,1052:1\n53#2:1053\n54#2:1054\n*S KotlinDebug\n*F\n+ 1 Fir2IrCallableDeclarationsGenerator.kt\norg/jetbrains/kotlin/fir/backend/generators/Fir2IrCallableDeclarationsGeneratorKt\n*L\n1047#1:1053\n1051#1:1054\n*E\n"})
public final class Fir2IrCallableDeclarationsGeneratorKt {
    public static final void setParent(@NotNull IrDeclaration $this$setParent, @Nullable IrDeclarationParent irParent) {
        Intrinsics.checkNotNullParameter((Object)$this$setParent, (String)"<this>");
        if (irParent != null) {
            $this$setParent.setParent(irParent);
        }
    }

    public static final void addDeclarationToParent(@NotNull IrDeclaration declaration, @Nullable IrDeclarationParent irParent) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (irParent == null) {
            return;
        }
        IrDeclarationParent irDeclarationParent = irParent;
        if (!(irDeclarationParent instanceof Fir2IrLazyClass)) {
            if (irDeclarationParent instanceof IrClass) {
                ((Collection)((IrClass)irParent).getDeclarations()).add(declaration);
            } else if (irDeclarationParent instanceof IrFile) {
                ((Collection)((IrFile)irParent).getDeclarations()).add(declaration);
            } else if (irDeclarationParent instanceof IrExternalPackageFragment) {
                ((Collection)((IrExternalPackageFragment)irParent).getDeclarations()).add(declaration);
            } else if (!(irDeclarationParent instanceof IrScript) && !(irDeclarationParent instanceof IrReplSnippet)) {
                throw new IllegalStateException(("Can't add declaration " + RenderIrElementKt.render$default((IrElement)((IrElement)declaration), null, (int)1, null) + " to parent " + RenderIrElementKt.render$default((IrElement)((IrElement)irParent), null, (int)1, null)).toString());
            }
        }
    }

    public static final boolean isExternalParent(@Nullable IrDeclarationParent $this$isExternalParent) {
        return $this$isExternalParent instanceof Fir2IrLazyClass || $this$isExternalParent instanceof IrExternalPackageFragment || $this$isExternalParent instanceof IrDeclaration && IrUtilsKt.isFileClass((IrDeclaration)((IrDeclaration)$this$isExternalParent));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean shouldParametersBeAssignable(@Nullable FirCallableDeclaration $this$shouldParametersBeAssignable, @NotNull Fir2IrComponents c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (!c.getExtensions().getParametersAreAssignable()) return false;
        FirCallableDeclaration firCallableDeclaration = $this$shouldParametersBeAssignable;
        if (firCallableDeclaration == null) return false;
        FirMemberDeclaration $this$isTailRec$iv = firCallableDeclaration;
        boolean $i$f$isTailRec = false;
        if (!$this$isTailRec$iv.getStatus().isTailRec()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEffectivelyExternal(@Nullable FirMemberDeclaration memberDeclaration, @Nullable IrDeclarationParent irParent) {
        boolean bl;
        FirMemberDeclaration firMemberDeclaration = memberDeclaration;
        if (firMemberDeclaration != null) {
            FirMemberDeclaration $this$isExternal$iv = firMemberDeclaration;
            boolean $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal()) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (!(irParent instanceof IrPossiblyExternalDeclaration)) return false;
        IrPossiblyExternalDeclaration irPossiblyExternalDeclaration = (IrPossiblyExternalDeclaration)irParent;
        if (irPossiblyExternalDeclaration == null) return false;
        if (!irPossiblyExternalDeclaration.isExternal()) return false;
        return true;
    }
}

