/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ScriptDependency;
import kotlin.script.experimental.jvm.JvmDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptClassPathUtil;", "", "<init>", "()V", "Companion", "kotlin.base.scripting"})
public final class ScriptClassPathUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u0006*\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptClassPathUtil$Companion;", "", "<init>", "()V", "findVirtualFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/script/experimental/api/ScriptDependency;", "findVirtualFile", "pathString", "", "refreshIfNeededAndFindFileByPath", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "path", "kotlin.base.scripting"})
    @SourceDebugExtension(value={"SMAP\nScriptClassPathUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptClassPathUtil.kt\norg/jetbrains/kotlin/idea/core/script/ScriptClassPathUtil$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1374#2:84\n1460#2,5:85\n1617#2,9:90\n1869#2:99\n1870#2:101\n1626#2:102\n1056#2:103\n1#3:100\n1#3:104\n*S KotlinDebug\n*F\n+ 1 ScriptClassPathUtil.kt\norg/jetbrains/kotlin/idea/core/script/ScriptClassPathUtil$Companion\n*L\n22#1:84\n22#1:85,5\n24#1:90,9\n24#1:99\n24#1:101\n24#1:102\n25#1:103\n24#1:100\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<VirtualFile> findVirtualFiles(@Nullable List<? extends ScriptDependency> $this$findVirtualFiles) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            if ($this$findVirtualFiles == null) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$flatMap$iv = $this$findVirtualFiles;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ScriptDependency it = (ScriptDependency)element$iv$iv;
                boolean bl = false;
                Object object = it instanceof JvmDependency ? (JvmDependency)it : null;
                if (object == null || (object = ((JvmDependency)object).getClasspath()) == null) {
                    object = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = (Iterable)object;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$mapNotNull$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            boolean $i$f$mapNotNull = false;
            $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                VirtualFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                File it = (File)element$iv$iv;
                boolean bl2 = false;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                if (Companion.findVirtualFile(string) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$sortedBy$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    VirtualFile it = (VirtualFile)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (VirtualFile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
        }

        @Nullable
        public final VirtualFile findVirtualFile(@NotNull String pathString) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)pathString, (String)"pathString");
            Path path2 = NioPathUtil.toNioPathOrNull((String)pathString);
            if (path2 == null) {
                ScriptUtilsKt.scriptingWarnLog("Invalid classpath entry '" + pathString + "'");
                object = null;
            } else {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    ScriptUtilsKt.scriptingWarnLog("Invalid classpath entry '" + pathString + "', notExists=true");
                    object = null;
                } else {
                    LinkOption[] linkOptionArray2 = new LinkOption[]{};
                    if (Files.isDirectory(path2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                        VirtualFileSystem virtualFileSystem = StandardFileSystems.local();
                        object = virtualFileSystem != null ? this.refreshIfNeededAndFindFileByPath(virtualFileSystem, ((Object)path2).toString()) : null;
                    } else {
                        LinkOption[] linkOptionArray3 = new LinkOption[]{};
                        if (Files.isRegularFile(path2, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                            VirtualFileSystem virtualFileSystem = StandardFileSystems.jar();
                            object = virtualFileSystem != null ? this.refreshIfNeededAndFindFileByPath(virtualFileSystem, ((Object)path2).toString() + "!/") : null;
                        } else {
                            ScriptUtilsKt.scriptingWarnLog("Invalid classpath entry '" + pathString + "'");
                            object = null;
                        }
                    }
                }
            }
            return object;
        }

        private final VirtualFile refreshIfNeededAndFindFileByPath(VirtualFileSystem $this$refreshIfNeededAndFindFileByPath, String path2) {
            Application application = ApplicationManager.getApplication();
            VirtualFile virtualFile = $this$refreshIfNeededAndFindFileByPath.findFileByPath(path2);
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                return it;
            }
            if (application.isDispatchThread() || !application.isReadAccessAllowed()) {
                return $this$refreshIfNeededAndFindFileByPath.refreshAndFindFileByPath(path2);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

