/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.DumbModeBlockedFunctionalityCollector;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.util.IncorrectOperationException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinAwareMoveFilesOrDirectoriesProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.Model;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.ModelResultWithFUSData;
import org.jetbrains.kotlin.idea.statistics.KotlinMoveRefactoringFUSCollector;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/KotlinAwareMoveFilesOrDirectoriesModel;", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/Model;", "project", "Lcom/intellij/openapi/project/Project;", "elementsToMove", "", "Lcom/intellij/psi/PsiFileSystemItem;", "targetDirectoryName", "", "updatePackageDirective", "", "searchReferences", "moveCallback", "Lcom/intellij/refactoring/move/MoveCallback;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;ZZLcom/intellij/refactoring/move/MoveCallback;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getElementsToMove", "()Ljava/util/List;", "getTargetDirectoryName", "()Ljava/lang/String;", "getUpdatePackageDirective", "()Z", "getSearchReferences", "getMoveCallback", "()Lcom/intellij/refactoring/move/MoveCallback;", "checkedGetElementsToMove", "Lcom/intellij/psi/PsiElement;", "selectedDirectory", "Lcom/intellij/psi/PsiDirectory;", "checkedGetTargetDirectory", "computeModelResult", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/ModelResultWithFUSData;", "checkModel", "", "throwOnConflicts", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinAwareMoveFilesOrDirectoriesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinAwareMoveFilesOrDirectoriesModel.kt\norg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/KotlinAwareMoveFilesOrDirectoriesModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n827#2:124\n855#2,2:125\n1869#2,2:127\n295#2,2:129\n*S KotlinDebug\n*F\n+ 1 KotlinAwareMoveFilesOrDirectoriesModel.kt\norg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/KotlinAwareMoveFilesOrDirectoriesModel\n*L\n40#1:124\n40#1:125,2\n51#1:127,2\n77#1:129,2\n*E\n"})
public final class KotlinAwareMoveFilesOrDirectoriesModel
implements Model {
    @NotNull
    private final Project project;
    @NotNull
    private final List<PsiFileSystemItem> elementsToMove;
    @NotNull
    private final String targetDirectoryName;
    private final boolean updatePackageDirective;
    private final boolean searchReferences;
    @Nullable
    private final MoveCallback moveCallback;

    public KotlinAwareMoveFilesOrDirectoriesModel(@NotNull Project project, @NotNull List<? extends PsiFileSystemItem> elementsToMove, @NotNull String targetDirectoryName, boolean updatePackageDirective, boolean searchReferences, @Nullable MoveCallback moveCallback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(elementsToMove, (String)"elementsToMove");
        Intrinsics.checkNotNullParameter((Object)targetDirectoryName, (String)"targetDirectoryName");
        this.project = project;
        this.elementsToMove = elementsToMove;
        this.targetDirectoryName = targetDirectoryName;
        this.updatePackageDirective = updatePackageDirective;
        this.searchReferences = searchReferences;
        this.moveCallback = moveCallback;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<PsiFileSystemItem> getElementsToMove() {
        return this.elementsToMove;
    }

    @NotNull
    public final String getTargetDirectoryName() {
        return this.targetDirectoryName;
    }

    public final boolean getUpdatePackageDirective() {
        return this.updatePackageDirective;
    }

    public final boolean getSearchReferences() {
        return this.searchReferences;
    }

    @Nullable
    public final MoveCallback getMoveCallback() {
        return this.moveCallback;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiElement> checkedGetElementsToMove(PsiDirectory selectedDirectory) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = this.elementsToMove;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            PsiFileSystemItem it = (PsiFileSystemItem)element$iv$iv;
            boolean bl = false;
            if (it instanceof PsiFile && Intrinsics.areEqual((Object)((PsiFile)it).getContainingDirectory(), (Object)selectedDirectory)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List preparedElementsToMove = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), KotlinAwareMoveFilesOrDirectoriesModel::checkedGetElementsToMove$lambda$1);
        try {
            Iterable $this$forEach$iv = preparedElementsToMove;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiFileSystemItem it = (PsiFileSystemItem)element$iv;
                boolean bl = false;
                MoveFilesOrDirectoriesUtil.checkMove((PsiElement)((PsiElement)it), (PsiElement)((PsiElement)selectedDirectory));
                if (!(it instanceof KtFile) || !KotlinRefactoringUtilKt.isInKotlinAwareSourceRoot((PsiElement)it)) continue;
                MoveUtilKt.setUpdatePackageDirective((KtFile)it, this.updatePackageDirective);
            }
        }
        catch (IncorrectOperationException e) {
            throw new ConfigurationException(e.getMessage());
        }
        return preparedElementsToMove;
    }

    private final PsiDirectory checkedGetTargetDirectory() {
        try {
            return MoveUtilKt.getOrCreateDirectory(this.project, this.targetDirectoryName);
        }
        catch (IncorrectOperationException e) {
            Object[] objectArray = new Object[]{this.targetDirectoryName};
            throw new ConfigurationException(KotlinBundle.message((String)"text.cannot.create.target.directory.0", (Object[])objectArray));
        }
    }

    @Override
    @NotNull
    public ModelResultWithFUSData computeModelResult() throws ConfigurationException {
        return this.computeModelResult(false);
    }

    private final void checkModel() {
        Object v0;
        block6: {
            Iterable $this$firstOrNull$iv = this.elementsToMove;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiFileSystemItem it = (PsiFileSystemItem)element$iv;
                boolean bl = false;
                if (!(!(it instanceof PsiFile) && !(it instanceof PsiDirectory))) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        PsiFileSystemItem psiFileSystemItem = v0;
        if (psiFileSystemItem != null) {
            PsiFileSystemItem it = psiFileSystemItem;
            boolean bl = false;
            Object[] objectArray = new Object[]{it};
            throw new ConfigurationException(KotlinBundle.message((String)"text.unexpected.element.type.0", (Object[])objectArray));
        }
        if (this.elementsToMove.isEmpty()) {
            throw new ConfigurationException(KotlinBundle.message((String)"text.no.files.to.move", (Object[])new Object[0]));
        }
        try {
            Paths.get(this.targetDirectoryName, new String[0]);
        }
        catch (InvalidPathException e) {
            Object[] objectArray = new Object[]{this.targetDirectoryName};
            throw new ConfigurationException(KotlinBundle.message((String)"text.invalid.target.path.0", (Object[])objectArray));
        }
        if (DumbService.Companion.isDumb(this.project)) {
            DumbModeBlockedFunctionalityCollector.INSTANCE.logFunctionalityBlocked(this.project, DumbModeBlockedFunctionality.Kotlin);
            throw new ConfigurationException(KotlinBundle.message((String)"text.move.refactoring.not.available.during.indexing", (Object[])new Object[0]));
        }
    }

    @Override
    @NotNull
    public ModelResultWithFUSData computeModelResult(boolean throwOnConflicts) throws ConfigurationException {
        this.checkModel();
        PsiDirectory selectedDir = this.checkedGetTargetDirectory();
        List<PsiElement> elementsToMove = this.checkedGetElementsToMove(selectedDir);
        KotlinAwareMoveFilesOrDirectoriesProcessor processor2 = new KotlinAwareMoveFilesOrDirectoriesProcessor(this.project, elementsToMove, selectedDir, this.searchReferences, false, false, this.moveCallback, null, false, 384, null);
        return new ModelResultWithFUSData((BaseRefactoringProcessor)processor2, elementsToMove.size(), KotlinMoveRefactoringFUSCollector.MovedEntity.FILES, KotlinMoveRefactoringFUSCollector.MoveRefactoringDestination.PACKAGE);
    }

    private static final int checkedGetElementsToMove$lambda$1(PsiFileSystemItem o1, PsiFileSystemItem o2) {
        return o1 instanceof KtElement && !(o2 instanceof KtElement) ? -1 : (!(o1 instanceof KtElement) && o2 instanceof KtElement ? 1 : 0);
    }
}

