/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.ui;

import com.intellij.ide.util.AbstractTreeClassChooserDialog;
import com.intellij.ide.util.TreeChooser;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.projectView.KtClassOrObjectTreeNode;
import org.jetbrains.kotlin.idea.projectView.KtFileTreeNode;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B-\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0014J.\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/ui/KotlinFileChooserDialog;", "Lcom/intellij/ide/util/AbstractTreeClassChooserDialog;", "Lorg/jetbrains/kotlin/psi/KtFile;", "title", "", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "packageName", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;Ljava/lang/String;)V", "getSelectedFromTreeUserObject", "node", "Ljavax/swing/tree/DefaultMutableTreeNode;", "getClassesByName", "", "name", "checkBoxState", "", "pattern", "createChooseByNameModel", "Lcom/intellij/ide/util/gotoByName/GotoFileModel;", "ScopeAwareClassFilter", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nKotlinFileChooserDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinFileChooserDialog.kt\norg/jetbrains/kotlin/idea/refactoring/ui/KotlinFileChooserDialog\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,66:1\n4135#2,11:67\n*S KotlinDebug\n*F\n+ 1 KotlinFileChooserDialog.kt\norg/jetbrains/kotlin/idea/refactoring/ui/KotlinFileChooserDialog\n*L\n46#1:67,11\n*E\n"})
public final class KotlinFileChooserDialog
extends AbstractTreeClassChooserDialog<KtFile> {
    public KotlinFileChooserDialog(@NlsContexts.DialogTitle @NotNull String title, @NotNull Project project, @Nullable GlobalSearchScope searchScope, @Nullable String packageName) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GlobalSearchScope globalSearchScope = searchScope;
        if (globalSearchScope == null) {
            globalSearchScope = KotlinScopeUtils.restrictToKotlinSources(KotlinScopeUtils.projectScope(project));
        }
        super(title, project, globalSearchScope, KtFile.class, (TreeChooser.Filter)new ScopeAwareClassFilter(searchScope, packageName), null, null, false, false);
    }

    @Nullable
    protected KtFile getSelectedFromTreeUserObject(@NotNull DefaultMutableTreeNode node) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Object userObject = node.getUserObject();
        if (userObject instanceof KtFileTreeNode) {
            object = ((KtFileTreeNode)((Object)userObject)).getKtFile();
        } else if (userObject instanceof KtClassOrObjectTreeNode) {
            KtFile ktFile2 = ((KtClassOrObject)((KtClassOrObjectTreeNode)((Object)userObject)).getValue()).getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
            KtFile containingFile = ktFile2;
            object = containingFile.getDeclarations().size() == 1 ? containingFile : null;
        } else {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<KtFile> getClassesByName(@NotNull String name2, boolean checkBoxState, @NotNull String pattern2, @NotNull GlobalSearchScope searchScope) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)pattern2, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        PsiFile[] psiFileArray = FilenameIndex.getFilesByName((Project)this.getProject(), (String)name2, (GlobalSearchScope)searchScope);
        Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"getFilesByName(...)");
        Object[] $this$filterIsInstance$iv = psiFileArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected GotoFileModel createChooseByNameModel() {
        return new GotoFileModel(this.getProject());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/ui/KotlinFileChooserDialog$ScopeAwareClassFilter;", "Lcom/intellij/ide/util/TreeChooser$Filter;", "Lcom/intellij/psi/PsiFile;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "packageName", "", "<init>", "(Lcom/intellij/psi/search/GlobalSearchScope;Ljava/lang/String;)V", "getSearchScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "getPackageName", "()Ljava/lang/String;", "isAccepted", "", "element", "kotlin.refactorings.common"})
    @SourceDebugExtension(value={"SMAP\nKotlinFileChooserDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinFileChooserDialog.kt\norg/jetbrains/kotlin/idea/refactoring/ui/KotlinFileChooserDialog$ScopeAwareClassFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
    private static final class ScopeAwareClassFilter
    implements TreeChooser.Filter<PsiFile> {
        @Nullable
        private final GlobalSearchScope searchScope;
        @Nullable
        private final String packageName;

        public ScopeAwareClassFilter(@Nullable GlobalSearchScope searchScope, @Nullable String packageName) {
            this.searchScope = searchScope;
            this.packageName = packageName;
        }

        @Nullable
        public final GlobalSearchScope getSearchScope() {
            return this.searchScope;
        }

        @Nullable
        public final String getPackageName() {
            return this.packageName;
        }

        public boolean isAccepted(@Nullable PsiFile element) {
            boolean bl;
            if (!(element instanceof KtFile)) {
                return false;
            }
            if (this.searchScope == null && this.packageName == null) {
                return true;
            }
            GlobalSearchScope globalSearchScope = this.searchScope;
            boolean matchesSearchScope = globalSearchScope != null ? globalSearchScope.accept(((KtFile)element).getVirtualFile()) : true;
            String string = this.packageName;
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                bl = Intrinsics.areEqual((Object)((KtFile)element).getPackageFqName().asString(), (Object)it);
            } else {
                bl = true;
            }
            boolean matchesPackage = bl;
            return matchesSearchScope && matchesPackage;
        }
    }
}

