/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.slicer;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.search.SearchScope;
import com.intellij.slicer.SliceUsage;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.slicer.KotlinSliceAnalysisMode;
import org.jetbrains.kotlin.idea.slicer.KotlinSliceUsage;
import org.jetbrains.kotlin.idea.slicer.LambdaCallsBehaviour;
import org.jetbrains.kotlin.idea.slicer.SliceProducer;
import org.jetbrains.kotlin.idea.slicer.Slicer;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/slicer/ReceiverSliceProducer;", "Lorg/jetbrains/kotlin/idea/slicer/SliceProducer;", "<init>", "()V", "produce", "", "Lcom/intellij/slicer/SliceUsage;", "usage", "Lcom/intellij/usageView/UsageInfo;", "mode", "Lorg/jetbrains/kotlin/idea/codeInsight/slicer/KotlinSliceAnalysisMode;", "parent", "testPresentation", "", "getTestPresentation", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "kotlin.idea"})
public final class ReceiverSliceProducer
implements SliceProducer {
    @NotNull
    public static final ReceiverSliceProducer INSTANCE = new ReceiverSliceProducer();

    private ReceiverSliceProducer() {
    }

    @Override
    @NotNull
    public Collection<SliceUsage> produce(@NotNull UsageInfo usage, @NotNull KotlinSliceAnalysisMode mode, @NotNull SliceUsage parent2) {
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        PsiElement psiElement = usage.getElement();
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement refElement = psiElement;
        if (refElement instanceof KtExpression) {
            ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)refElement, null, 1, null);
            if (resolvedCall == null) {
                return CollectionsKt.emptyList();
            }
            ResolvedCall resolvedCall2 = resolvedCall;
            ReceiverValue receiver2 = resolvedCall2.getExtensionReceiver();
            if (receiver2 instanceof ExpressionReceiver) {
                return CollectionsKt.listOf((Object)((Object)new KotlinSliceUsage((PsiElement)((ExpressionReceiver)receiver2).getExpression(), parent2, mode, true)));
            }
            if (receiver2 instanceof ImplicitReceiver) {
                DeclarationDescriptor declarationDescriptor = ((ImplicitReceiver)receiver2).getDeclarationDescriptor();
                CallableDescriptor callableDescriptor = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
                if (callableDescriptor == null) {
                    return CollectionsKt.emptyList();
                }
                CallableDescriptor callableDescriptor2 = callableDescriptor;
                DeclarationDescriptor declarationDescriptor2 = (DeclarationDescriptor)callableDescriptor2;
                Project project = usage.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                SearchScope searchScope = parent2.getScope().toSearchScope();
                Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"toSearchScope(...)");
                PsiElement declaration = Slicer.Companion.descriptorToPsi(declarationDescriptor2, project, searchScope);
                if (declaration instanceof KtFunctionLiteral) {
                    KotlinSliceAnalysisMode newMode = mode.withBehaviour(new LambdaCallsBehaviour(INSTANCE));
                    return CollectionsKt.listOf((Object)((Object)new KotlinSliceUsage(declaration, parent2, newMode, true)));
                }
                if (declaration instanceof KtCallableDeclaration) {
                    KtTypeReference ktTypeReference = ((KtCallableDeclaration)declaration).getReceiverTypeReference();
                    if (ktTypeReference == null) {
                        return CollectionsKt.emptyList();
                    }
                    KtTypeReference receiverTypeReference = ktTypeReference;
                    return CollectionsKt.listOf((Object)((Object)new KotlinSliceUsage((PsiElement)receiverTypeReference, parent2, mode, false)));
                }
                return CollectionsKt.emptyList();
            }
            return CollectionsKt.emptyList();
        }
        PsiElement psiElement2 = refElement.getParent();
        PsiExpression psiExpression = psiElement2 instanceof PsiCall ? (PsiExpression)psiElement2 : null;
        if (psiExpression == null || (psiExpression = psiExpression.getArgumentList()) == null || (psiExpression = psiExpression.getExpressions()) == null || (psiExpression = (PsiExpression)ArraysKt.getOrNull((Object[])psiExpression, (int)0)) == null) {
            return CollectionsKt.emptyList();
        }
        PsiExpression argument2 = psiExpression;
        return CollectionsKt.listOf((Object)((Object)new KotlinSliceUsage((PsiElement)argument2, parent2, mode, false)));
    }

    @Override
    @NotNull
    public String getTestPresentation() {
        return "RECEIVER";
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other == this;
    }

    @Override
    public int hashCode() {
        return 0;
    }
}

