/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.externalCodeProcessing;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.j2k.AccessorKind;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.nj2k.externalCodeProcessing.AccessorToPropertyJavaExternalConversion;
import org.jetbrains.kotlin.nj2k.externalCodeProcessing.AccessorToPropertyKotlinExternalConversion;
import org.jetbrains.kotlin.nj2k.externalCodeProcessing.JKExternalConversion;
import org.jetbrains.kotlin.nj2k.externalCodeProcessing.JKFieldData;
import org.jetbrains.kotlin.nj2k.externalCodeProcessing.JKFieldDataFromJava;
import org.jetbrains.kotlin.nj2k.externalCodeProcessing.JKMemberData;
import org.jetbrains.kotlin.nj2k.externalCodeProcessing.JKMethodData;
import org.jetbrains.kotlin.nj2k.externalCodeProcessing.PropertyRenamedJavaExternalUsageConversion;
import org.jetbrains.kotlin.nj2k.externalCodeProcessing.PropertyRenamedKotlinExternalUsageConversion;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u000fJ\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0004H\u0002J(\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003H\u0002J(\u0010\u000e\u001a\u00020\u000f*\u00020\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\fH\u0002J\f\u0010\u0018\u001a\u00020\u0017*\u00020\fH\u0002J\f\u0010\u0019\u001a\u00020\u0017*\u00020\fH\u0002J\f\u0010\u001a\u001a\u00020\u0017*\u00020\fH\u0002J\f\u0010\u001b\u001a\u00020\u0017*\u00020\fH\u0002J\f\u0010\u001c\u001a\u00020\u000f*\u00020\fH\u0002J\f\u0010\u001d\u001a\u00020\u000f*\u00020\fH\u0002J\u0014\u0010\u001e\u001a\u00020\u000f*\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/nj2k/externalCodeProcessing/ExternalUsagesFixer;", "", "usages", "", "Lorg/jetbrains/kotlin/nj2k/externalCodeProcessing/ExternalUsagesFixer$JKMemberInfoWithUsages;", "<init>", "(Ljava/util/List;)V", "conversions", "", "Lorg/jetbrains/kotlin/nj2k/externalCodeProcessing/JKExternalConversion;", "jvmFieldAnnotatedDeclarations", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "jvmStaticAnnotatedDeclarations", "fix", "", "Lorg/jetbrains/kotlin/nj2k/externalCodeProcessing/JKFieldDataFromJava;", "javaUsages", "Lcom/intellij/psi/PsiElement;", "kotlinUsages", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/nj2k/externalCodeProcessing/JKMethodData;", "hasJvmFieldAnnotation", "", "hasJvmAnnotations", "isConstProperty", "canBeAnnotatedWithJvmField", "isSimpleProperty", "addJvmFieldAnnotationIfThereAreNoJvmAnnotations", "addJvmStaticAnnotationIfThereAreNoJvmAnnotations", "addAnnotation", "fqName", "", "JKMemberInfoWithUsages", "kotlin.j2k.shared"})
@SourceDebugExtension(value={"SMAP\nExternalUsagesFixer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalUsagesFixer.kt\norg/jetbrains/kotlin/nj2k/externalCodeProcessing/ExternalUsagesFixer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1869#2,2:133\n*S KotlinDebug\n*F\n+ 1 ExternalUsagesFixer.kt\norg/jetbrains/kotlin/nj2k/externalCodeProcessing/ExternalUsagesFixer\n*L\n26#1:133,2\n*E\n"})
public final class ExternalUsagesFixer {
    @NotNull
    private final List<JKMemberInfoWithUsages> usages;
    @NotNull
    private final List<JKExternalConversion> conversions;
    @NotNull
    private final Set<KtNamedDeclaration> jvmFieldAnnotatedDeclarations;
    @NotNull
    private final Set<KtNamedDeclaration> jvmStaticAnnotatedDeclarations;

    public ExternalUsagesFixer(@NotNull List<JKMemberInfoWithUsages> usages2) {
        Intrinsics.checkNotNullParameter(usages2, (String)"usages");
        this.usages = usages2;
        this.conversions = new ArrayList();
        this.jvmFieldAnnotatedDeclarations = new LinkedHashSet();
        this.jvmStaticAnnotatedDeclarations = new LinkedHashSet();
    }

    public final void fix() {
        for (JKMemberInfoWithUsages usage : this.usages) {
            this.fix(usage);
        }
        CollectionsKt.sort(this.conversions);
        Iterable $this$forEach$iv = this.conversions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JKExternalConversion p0 = (JKExternalConversion)element$iv;
            boolean bl = false;
            p0.apply();
        }
    }

    private final void fix(JKMemberInfoWithUsages $this$fix) {
        JKMemberData jKMemberData = $this$fix.getMember();
        if (jKMemberData instanceof JKFieldDataFromJava) {
            this.fix((JKFieldDataFromJava)$this$fix.getMember(), $this$fix.getJavaUsages(), $this$fix.getKotlinUsages());
        } else if (jKMemberData instanceof JKMethodData) {
            this.fix((JKMethodData)$this$fix.getMember(), $this$fix.getJavaUsages(), $this$fix.getKotlinUsages());
        }
    }

    private final void fix(JKFieldDataFromJava $this$fix, List<? extends PsiElement> javaUsages, List<? extends KtElement> kotlinUsages) {
        if ($this$fix.getWasRenamed()) {
            for (PsiElement psiElement : javaUsages) {
                ((Collection)this.conversions).add(new PropertyRenamedJavaExternalUsageConversion($this$fix.getName(), psiElement));
            }
            for (KtElement ktElement : kotlinUsages) {
                ((Collection)this.conversions).add(new PropertyRenamedKotlinExternalUsageConversion($this$fix.getName(), ktElement));
            }
        }
        if (javaUsages.isEmpty()) {
            return;
        }
        KtNamedDeclaration ktNamedDeclaration = $this$fix.getKotlinElement();
        if (ktNamedDeclaration == null) {
            return;
        }
        KtNamedDeclaration ktProperty = ktNamedDeclaration;
        if (this.canBeAnnotatedWithJvmField(ktProperty)) {
            this.addJvmFieldAnnotationIfThereAreNoJvmAnnotations(ktProperty);
        } else if ($this$fix.isStatic() && !ktProperty.hasModifier(KtTokens.CONST_KEYWORD)) {
            this.addJvmStaticAnnotationIfThereAreNoJvmAnnotations(ktProperty);
        }
    }

    private final void fix(JKMethodData $this$fix, List<? extends PsiElement> javaUsages, List<? extends KtElement> kotlinUsages) {
        JKFieldData jKFieldData = $this$fix.getUsedAsAccessorOfProperty();
        JKMemberData member = jKFieldData != null ? (JKMemberData)jKFieldData : (JKMemberData)$this$fix;
        KtNamedDeclaration ktNamedDeclaration = member.getKotlinElement();
        if (ktNamedDeclaration == null) {
            return;
        }
        KtNamedDeclaration element = ktNamedDeclaration;
        if (!((Collection)javaUsages).isEmpty()) {
            if (this.canBeAnnotatedWithJvmField(element)) {
                this.addJvmFieldAnnotationIfThereAreNoJvmAnnotations(element);
            } else if ($this$fix.isStatic() && !this.isConstProperty(element)) {
                this.addJvmStaticAnnotationIfThereAreNoJvmAnnotations(element);
            }
        }
        if (!this.isSimpleProperty(element)) {
            return;
        }
        String string = ((PsiMethod)$this$fix.getJavaElement()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        AccessorKind accessorKind = StringsKt.startsWith$default((String)string, (String)"set", (boolean)false, (int)2, null) ? AccessorKind.SETTER : AccessorKind.GETTER;
        for (KtElement ktElement : kotlinUsages) {
            ((Collection)this.conversions).add(new AccessorToPropertyKotlinExternalConversion(member.getName(), accessorKind, (PsiElement)ktElement));
        }
        if (!((Collection)javaUsages).isEmpty() && this.hasJvmFieldAnnotation(element)) {
            for (PsiElement psiElement : javaUsages) {
                ((Collection)this.conversions).add(new AccessorToPropertyJavaExternalConversion(member.getName(), accessorKind, psiElement));
            }
        }
    }

    private final boolean hasJvmFieldAnnotation(KtNamedDeclaration $this$hasJvmFieldAnnotation) {
        return this.jvmFieldAnnotatedDeclarations.contains($this$hasJvmFieldAnnotation);
    }

    private final boolean hasJvmAnnotations(KtNamedDeclaration $this$hasJvmAnnotations) {
        return this.jvmFieldAnnotatedDeclarations.contains($this$hasJvmAnnotations) || this.jvmStaticAnnotatedDeclarations.contains($this$hasJvmAnnotations);
    }

    private final boolean isConstProperty(KtNamedDeclaration $this$isConstProperty) {
        return $this$isConstProperty instanceof KtProperty && ((KtProperty)$this$isConstProperty).hasModifier(KtTokens.CONST_KEYWORD);
    }

    private final boolean canBeAnnotatedWithJvmField(KtNamedDeclaration $this$canBeAnnotatedWithJvmField) {
        if ($this$canBeAnnotatedWithJvmField.hasModifier(KtTokens.OVERRIDE_KEYWORD) || $this$canBeAnnotatedWithJvmField.hasModifier(KtTokens.OPEN_KEYWORD) || $this$canBeAnnotatedWithJvmField.hasModifier(KtTokens.CONST_KEYWORD)) {
            return false;
        }
        return this.isSimpleProperty($this$canBeAnnotatedWithJvmField);
    }

    private final boolean isSimpleProperty(KtNamedDeclaration $this$isSimpleProperty) {
        return KotlinPsiUtils.isConstructorDeclaredProperty($this$isSimpleProperty) || $this$isSimpleProperty instanceof KtProperty && ((KtProperty)$this$isSimpleProperty).getGetter() == null && ((KtProperty)$this$isSimpleProperty).getSetter() == null;
    }

    private final void addJvmFieldAnnotationIfThereAreNoJvmAnnotations(KtNamedDeclaration $this$addJvmFieldAnnotationIfThereAreNoJvmAnnotations) {
        if (this.hasJvmAnnotations($this$addJvmFieldAnnotationIfThereAreNoJvmAnnotations)) {
            return;
        }
        this.jvmFieldAnnotatedDeclarations.add($this$addJvmFieldAnnotationIfThereAreNoJvmAnnotations);
        this.addAnnotation($this$addJvmFieldAnnotationIfThereAreNoJvmAnnotations, "kotlin.jvm.JvmField");
    }

    private final void addJvmStaticAnnotationIfThereAreNoJvmAnnotations(KtNamedDeclaration $this$addJvmStaticAnnotationIfThereAreNoJvmAnnotations) {
        if (this.hasJvmAnnotations($this$addJvmStaticAnnotationIfThereAreNoJvmAnnotations)) {
            return;
        }
        this.jvmStaticAnnotatedDeclarations.add($this$addJvmStaticAnnotationIfThereAreNoJvmAnnotations);
        this.addAnnotation($this$addJvmStaticAnnotationIfThereAreNoJvmAnnotations, "kotlin.jvm.JvmStatic");
    }

    private final void addAnnotation(KtNamedDeclaration $this$addAnnotation, String fqName2) {
        Project project = $this$addAnnotation.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtAnnotationEntry ktAnnotationEntry = $this$addAnnotation.addAnnotationEntry(new KtPsiFactory(project, false, 2, null).createAnnotationEntry("@" + fqName2));
        Intrinsics.checkNotNullExpressionValue((Object)ktAnnotationEntry, (String)"addAnnotationEntry(...)");
        KtAnnotationEntry annotation = ktAnnotationEntry;
        ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)annotation);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J3\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/nj2k/externalCodeProcessing/ExternalUsagesFixer$JKMemberInfoWithUsages;", "", "member", "Lorg/jetbrains/kotlin/nj2k/externalCodeProcessing/JKMemberData;", "javaUsages", "", "Lcom/intellij/psi/PsiElement;", "kotlinUsages", "Lorg/jetbrains/kotlin/psi/KtElement;", "<init>", "(Lorg/jetbrains/kotlin/nj2k/externalCodeProcessing/JKMemberData;Ljava/util/List;Ljava/util/List;)V", "getMember", "()Lorg/jetbrains/kotlin/nj2k/externalCodeProcessing/JKMemberData;", "getJavaUsages", "()Ljava/util/List;", "getKotlinUsages", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.j2k.shared"})
    public static final class JKMemberInfoWithUsages {
        @NotNull
        private final JKMemberData member;
        @NotNull
        private final List<PsiElement> javaUsages;
        @NotNull
        private final List<KtElement> kotlinUsages;

        public JKMemberInfoWithUsages(@NotNull JKMemberData member, @NotNull List<? extends PsiElement> javaUsages, @NotNull List<? extends KtElement> kotlinUsages) {
            Intrinsics.checkNotNullParameter((Object)member, (String)"member");
            Intrinsics.checkNotNullParameter(javaUsages, (String)"javaUsages");
            Intrinsics.checkNotNullParameter(kotlinUsages, (String)"kotlinUsages");
            this.member = member;
            this.javaUsages = javaUsages;
            this.kotlinUsages = kotlinUsages;
        }

        @NotNull
        public final JKMemberData getMember() {
            return this.member;
        }

        @NotNull
        public final List<PsiElement> getJavaUsages() {
            return this.javaUsages;
        }

        @NotNull
        public final List<KtElement> getKotlinUsages() {
            return this.kotlinUsages;
        }

        @NotNull
        public final JKMemberData component1() {
            return this.member;
        }

        @NotNull
        public final List<PsiElement> component2() {
            return this.javaUsages;
        }

        @NotNull
        public final List<KtElement> component3() {
            return this.kotlinUsages;
        }

        @NotNull
        public final JKMemberInfoWithUsages copy(@NotNull JKMemberData member, @NotNull List<? extends PsiElement> javaUsages, @NotNull List<? extends KtElement> kotlinUsages) {
            Intrinsics.checkNotNullParameter((Object)member, (String)"member");
            Intrinsics.checkNotNullParameter(javaUsages, (String)"javaUsages");
            Intrinsics.checkNotNullParameter(kotlinUsages, (String)"kotlinUsages");
            return new JKMemberInfoWithUsages(member, javaUsages, kotlinUsages);
        }

        public static /* synthetic */ JKMemberInfoWithUsages copy$default(JKMemberInfoWithUsages jKMemberInfoWithUsages, JKMemberData jKMemberData, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                jKMemberData = jKMemberInfoWithUsages.member;
            }
            if ((n & 2) != 0) {
                list2 = jKMemberInfoWithUsages.javaUsages;
            }
            if ((n & 4) != 0) {
                list3 = jKMemberInfoWithUsages.kotlinUsages;
            }
            return jKMemberInfoWithUsages.copy(jKMemberData, list2, list3);
        }

        @NotNull
        public String toString() {
            return "JKMemberInfoWithUsages(member=" + this.member + ", javaUsages=" + this.javaUsages + ", kotlinUsages=" + this.kotlinUsages + ")";
        }

        public int hashCode() {
            int result2 = this.member.hashCode();
            result2 = result2 * 31 + ((Object)this.javaUsages).hashCode();
            result2 = result2 * 31 + ((Object)this.kotlinUsages).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JKMemberInfoWithUsages)) {
                return false;
            }
            JKMemberInfoWithUsages jKMemberInfoWithUsages = (JKMemberInfoWithUsages)other;
            if (!Intrinsics.areEqual((Object)this.member, (Object)jKMemberInfoWithUsages.member)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.javaUsages, jKMemberInfoWithUsages.javaUsages)) {
                return false;
            }
            return Intrinsics.areEqual(this.kotlinUsages, jKMemberInfoWithUsages.kotlinUsages);
        }
    }
}

