/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInsight.CodeInsightWorkspaceSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.codeInspection.local.GroovyPostHighlightingPass;
import org.jetbrains.plugins.groovy.editor.GroovyImportOptimizer;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;

public final class GroovyOptimizeImportsFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(GroovyPostHighlightingPass.class);
    private final boolean onTheFly;

    GroovyOptimizeImportsFix(boolean onTheFly) {
        this.onTheFly = onTheFly;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            GroovyOptimizeImportsFix.$$$reportNull$$$0(0);
        }
        Runnable optimize = new GroovyImportOptimizer().processFile(psiFile);
        GroovyOptimizeImportsFix.invokeOnTheFlyImportOptimizer(optimize, psiFile, editor);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            GroovyOptimizeImportsFix.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            GroovyOptimizeImportsFix.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            GroovyOptimizeImportsFix.$$$reportNull$$$0(3);
        }
        String originalText = psiFile.getText();
        Runnable optimize = new GroovyImportOptimizer().processFile(psiFile);
        optimize.run();
        String newText = psiFile.getText();
        return new IntentionPreviewInfo.CustomDiff((FileType)GroovyFileType.GROOVY_FILE_TYPE, originalText, newText);
    }

    @NotNull
    public String getText() {
        String string = GroovyBundle.message("optimize.all.imports", new Object[0]);
        if (string == null) {
            GroovyOptimizeImportsFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("optimize.imports", new Object[0]);
        if (string == null) {
            GroovyOptimizeImportsFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            GroovyOptimizeImportsFix.$$$reportNull$$$0(6);
        }
        return psiFile instanceof GroovyFile && (!this.onTheFly || this.timeToOptimizeImports((GroovyFile)psiFile, editor));
    }

    private boolean timeToOptimizeImports(GroovyFile myFile, Editor editor) {
        DaemonCodeAnalyzerImpl codeAnalyzer;
        GrImportStatement[] imports2;
        VirtualFile vfile;
        if (!CodeInsightWorkspaceSettings.getInstance((Project)myFile.getProject()).isOptimizeImportsOnTheFly()) {
            return false;
        }
        if (this.onTheFly && editor != null && (vfile = myFile.getVirtualFile()) != null && ProjectRootManager.getInstance((Project)myFile.getProject()).getFileIndex().isInSource(vfile) && (imports2 = myFile.getImportStatements()).length > 0) {
            int offset = editor.getCaretModel().getOffset();
            if (imports2[0].getTextRange().getStartOffset() <= offset && offset <= imports2[imports2.length - 1].getTextRange().getEndOffset()) {
                return false;
            }
        }
        if (!(codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)myFile.getProject())).isHighlightingAvailable((PsiFile)myFile)) {
            return false;
        }
        if (!codeAnalyzer.isErrorAnalyzingFinished((PsiFile)myFile)) {
            return false;
        }
        Document myDocument = PsiDocumentManager.getInstance((Project)myFile.getProject()).getDocument((PsiFile)myFile);
        boolean errors = GroovyOptimizeImportsFix.containsErrorsPreventingOptimize(myFile, myDocument);
        boolean isInContent = true;
        return !errors && DaemonListeners.canChangeFileSilently((PsiFileSystemItem)myFile, (boolean)isInContent, (ThreeState)ThreeState.UNSURE);
    }

    private static boolean containsErrorsPreventingOptimize(GroovyFile myFile, Document myDocument) {
        TextRange ignoreRange;
        GrImportStatement[] imports2 = myFile.getImportStatements();
        if (imports2.length != 0) {
            int start = imports2[0].getTextRange().getStartOffset();
            int end = imports2[imports2.length - 1].getTextRange().getEndOffset();
            ignoreRange = new TextRange(start, end);
        } else {
            ignoreRange = TextRange.EMPTY_RANGE;
        }
        return !DaemonCodeAnalyzerEx.processHighlights((Document)myDocument, (Project)myFile.getProject(), (HighlightSeverity)HighlightSeverity.ERROR, (int)0, (int)myDocument.getTextLength(), error -> {
            int infoEnd;
            int infoStart = error.getActualStartOffset();
            return ignoreRange.containsRange(infoStart, infoEnd = error.getActualEndOffset()) && error.type.equals(HighlightInfoType.WRONG_REF);
        });
    }

    public static void invokeOnTheFlyImportOptimizer(@NotNull Runnable runnable, @NotNull PsiFile file, @NotNull Editor editor) {
        if (runnable == null) {
            GroovyOptimizeImportsFix.$$$reportNull$$$0(7);
        }
        if (file == null) {
            GroovyOptimizeImportsFix.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            GroovyOptimizeImportsFix.$$$reportNull$$$0(9);
        }
        long stamp = editor.getDocument().getModificationStamp();
        Project project = file.getProject();
        ApplicationManager.getApplication().invokeLater(() -> {
            String afterText;
            if (project.isDisposed() || editor.isDisposed() || editor.getDocument().getModificationStamp() != stamp) {
                return;
            }
            if (UndoManager.getInstance((Project)project).isUndoOrRedoInProgress()) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            String beforeText = file.getText();
            long oldStamp = editor.getDocument().getModificationStamp();
            DocumentUtil.writeInRunUndoTransparentAction((Runnable)runnable);
            if (oldStamp != editor.getDocument().getModificationStamp() && Comparing.strEqual((String)beforeText, (String)(afterText = file.getText()))) {
                String path = file.getViewProvider().getVirtualFile().getPath();
                LOG.error("Import optimizer  hasn't optimized any imports", new Attachment[]{new Attachment(path, afterText)});
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/GroovyOptimizeImportsFix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/GroovyOptimizeImportsFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnTheFlyImportOptimizer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

