/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.cs;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.refactoring.DefaultGroovyVariableNameValidator;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/cs/GrReplaceMultiAssignmentFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "size", "", "<init>", "(I)V", "getSize", "()I", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "generateVariableName", "", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "generateListLiteral", "varName", "getName", "getFamilyName", "intellij.groovy"})
public final class GrReplaceMultiAssignmentFix
extends PsiUpdateModCommandQuickFix {
    private final int size;

    public GrReplaceMultiAssignmentFix(int size) {
        this.size = size;
    }

    public final int getSize() {
        return this.size;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        if (!(element instanceof GrExpression)) {
            return;
        }
        PsiElement psiElement = ((GrExpression)element).getParent();
        GrStatement grStatement = psiElement instanceof GrStatement ? (GrStatement)psiElement : null;
        if (grStatement == null) {
            return;
        }
        GrStatement grStatement2 = grStatement;
        Object object = grStatement2.getParent();
        GrStatementOwner grStatementOwner = object instanceof GrStatementOwner ? (GrStatementOwner)object : null;
        if (grStatementOwner == null) {
            return;
        }
        GrStatementOwner grStatementOwner2 = grStatementOwner;
        String initializer = ((GrExpression)element).getText();
        if (!(element instanceof GrReferenceExpression) || !(((GrReferenceExpression)element).resolve() instanceof GrVariable)) {
            GroovyPsiElementFactory groovyPsiElementFactory = GroovyPsiElementFactory.getInstance(((GrExpression)element).getProject());
            Intrinsics.checkNotNullExpressionValue((Object)groovyPsiElementFactory, (String)"getInstance(...)");
            GroovyPsiElementFactory factory = groovyPsiElementFactory;
            String fixVariableName = this.generateVariableName((GrExpression)element);
            GrStatement grStatement3 = factory.createStatementFromText("def " + fixVariableName + " = " + initializer);
            Intrinsics.checkNotNullExpressionValue((Object)grStatement3, (String)"createStatementFromText(...)");
            GrStatement varDefinition = grStatement3;
            grStatementOwner2.addStatementBefore(varDefinition, grStatement2);
            initializer = fixVariableName;
        }
        GrExpression grExpression = (GrExpression)element;
        object = initializer;
        Intrinsics.checkNotNull((Object)object);
        GrInspectionUtil.replaceExpression(grExpression, this.generateListLiteral((String)object));
    }

    private final String generateVariableName(GrExpression expression) {
        String string;
        DefaultGroovyVariableNameValidator validator = new DefaultGroovyVariableNameValidator(expression);
        String[] suggestedNames = GroovyNameSuggestionUtil.suggestVariableNameByType(expression.getType(), validator);
        Intrinsics.checkNotNull((Object)suggestedNames);
        if (!(suggestedNames.length == 0)) {
            String string2 = suggestedNames[0];
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
        } else {
            string = "storedList";
        }
        return string;
    }

    private final String generateListLiteral(String varName) {
        return CollectionsKt.joinToString$default((Iterable)((Iterable)RangesKt.until((int)0, (int)this.size)), (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, arg_0 -> GrReplaceMultiAssignmentFix.generateListLiteral$lambda$0(varName, arg_0), (int)24, null);
    }

    @NotNull
    public String getName() {
        String string = GroovyBundle.message("replace.with.list.literal", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("replace.with.list.literal", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final CharSequence generateListLiteral$lambda$0(String $varName, int it) {
        return $varName + "[" + it + "]";
    }
}

