/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.scientific.utils;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0018\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0080@\u00a2\u0006\u0004\b\u0011\u0010\u0012J \u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0080@\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0080@\u00a2\u0006\u0004\b\u0019\u0010\u001aJ \u0010\u001b\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0015H\u0080@\u00a2\u0006\u0004\b\u001d\u0010\u0017J\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0080@\u00a2\u0006\u0004\b\u001f\u0010\u001aJ\u0018\u0010 \u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0080@\u00a2\u0006\u0004\b!\u0010\u001aJ \u0010\"\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0015H\u0080@\u00a2\u0006\u0004\b$\u0010\u0017J\u0018\u0010%\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0080@\u00a2\u0006\u0004\b&\u0010\u001aJ \u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u0015H\u0002J\u0010\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u0015H\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/intellij/images/scientific/utils/ScientificUtils;", "", "<init>", "()V", "SCIENTIFIC_MODE_KEY", "Lcom/intellij/openapi/util/Key;", "", "DATA_TYPE_KEY", "", "getDATA_TYPE_KEY", "()Lcom/intellij/openapi/util/Key;", "DEFAULT_IMAGE_FORMAT", "saveImageToFile", "imageFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "image", "Ljava/awt/image/BufferedImage;", "saveImageToFile$intellij_platform_images", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/awt/image/BufferedImage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "rotateImage", "angle", "", "rotateImage$intellij_platform_images", "(Ljava/awt/image/BufferedImage;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyGrayscale", "applyGrayscale$intellij_platform_images", "(Ljava/awt/image/BufferedImage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "displaySingleChannel", "channelIndex", "displaySingleChannel$intellij_platform_images", "applyInvertChannels", "applyInvertChannels$intellij_platform_images", "applyReverseChannelsOrder", "applyReverseChannelsOrder$intellij_platform_images", "applyBinarization", "threshold", "applyBinarization$intellij_platform_images", "normalizeImage", "normalizeImage$intellij_platform_images", "normalizeChannel", "value", "min", "max", "calculateBrightness", "rgba", "intellij.platform.images"})
public final class ScientificUtils {
    @NotNull
    public static final ScientificUtils INSTANCE = new ScientificUtils();
    @JvmField
    @NotNull
    public static final Key<Unit> SCIENTIFIC_MODE_KEY = new Key("SCIENTIFIC_MODE");
    @NotNull
    private static final Key<String> DATA_TYPE_KEY = new Key("DATA_TYPE");
    @NotNull
    public static final String DEFAULT_IMAGE_FORMAT = "png";

    private ScientificUtils() {
    }

    @NotNull
    public final Key<String> getDATA_TYPE_KEY() {
        return DATA_TYPE_KEY;
    }

    @Nullable
    public final Object saveImageToFile$intellij_platform_images(@NotNull VirtualFile imageFile, @NotNull BufferedImage image, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(image, imageFile, null){
            int label;
            final /* synthetic */ BufferedImage $image;
            final /* synthetic */ VirtualFile $imageFile;
            {
                this.$image = $image;
                this.$imageFile = $imageFile;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Closeable closeable = new ByteArrayOutputStream();
                        BufferedImage bufferedImage = this.$image;
                        VirtualFile virtualFile = this.$imageFile;
                        Throwable throwable = null;
                        try {
                            ByteArrayOutputStream outputStream = (ByteArrayOutputStream)closeable;
                            boolean bl = false;
                            ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
                            byte[] byArray = outputStream.toByteArray();
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                            VirtualFileUtil.writeBytes((VirtualFile)virtualFile, (byte[])byArray);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object rotateImage$intellij_platform_images(@NotNull BufferedImage image, int angle, @NotNull Continuation<? super BufferedImage> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BufferedImage>, Object>(angle, image, null){
            int label;
            final /* synthetic */ int $angle;
            final /* synthetic */ BufferedImage $image;
            {
                this.$angle = $angle;
                this.$image = $image;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        int angle = this.$angle % 360;
                        if (angle < 0) {
                            angle += 360;
                        }
                        int width = this.$image.getWidth();
                        int height = this.$image.getHeight();
                        boolean isRightAngle = angle % 180 == 90;
                        int targetWidth = isRightAngle ? height : width;
                        int targetHeight = isRightAngle ? width : height;
                        AffineTransform transform = new AffineTransform();
                        transform.translate((double)targetWidth / 2.0, (double)targetHeight / 2.0);
                        transform.rotate(Math.toRadians(angle));
                        transform.translate((double)(-width) / 2.0, (double)(-height) / 2.0);
                        BufferedImage rotatedImage = new BufferedImage(targetWidth, targetHeight, this.$image.getType());
                        Graphics2D graphics = rotatedImage.createGraphics();
                        graphics.setTransform(transform);
                        graphics.drawImage((Image)this.$image, 0, 0, null);
                        graphics.dispose();
                        return rotatedImage;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BufferedImage> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object applyGrayscale$intellij_platform_images(@NotNull BufferedImage image, @NotNull Continuation<? super BufferedImage> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BufferedImage>, Object>(image, null){
            int label;
            final /* synthetic */ BufferedImage $image;
            {
                this.$image = $image;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        BufferedImage bufferedImage = new BufferedImage(this.$image.getWidth(), this.$image.getHeight(), 10);
                        BufferedImage bufferedImage2 = this.$image;
                        BufferedImage grayscaleImage = bufferedImage;
                        boolean bl = false;
                        Graphics2D graphics = grayscaleImage.createGraphics();
                        try {
                            graphics.drawImage((Image)bufferedImage2, 0, 0, null);
                        }
                        finally {
                            graphics.dispose();
                        }
                        return bufferedImage;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BufferedImage> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object displaySingleChannel$intellij_platform_images(@NotNull BufferedImage image, int channelIndex, @NotNull Continuation<? super BufferedImage> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BufferedImage>, Object>(image, channelIndex, null){
            int label;
            final /* synthetic */ BufferedImage $image;
            final /* synthetic */ int $channelIndex;
            {
                this.$image = $image;
                this.$channelIndex = $channelIndex;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        WritableRaster raster = this.$image.getRaster();
                        BufferedImage bufferedImage = new BufferedImage(this.$image.getWidth(), this.$image.getHeight(), 10);
                        BufferedImage bufferedImage2 = this.$image;
                        int n = this.$channelIndex;
                        BufferedImage channelImage = bufferedImage;
                        boolean bl = false;
                        int n2 = bufferedImage2.getWidth();
                        for (int x = 0; x < n2; ++x) {
                            int n3 = bufferedImage2.getHeight();
                            for (int y = 0; y < n3; ++y) {
                                int value = raster.getSample(x, y, n);
                                boolean bl2 = false;
                                channelImage.getRaster().setSample(x, y, 0, value);
                            }
                        }
                        return bufferedImage;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BufferedImage> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object applyInvertChannels$intellij_platform_images(@NotNull BufferedImage image, @NotNull Continuation<? super BufferedImage> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BufferedImage>, Object>(image, null){
            int label;
            final /* synthetic */ BufferedImage $image;
            {
                this.$image = $image;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        BufferedImage bufferedImage = new BufferedImage(this.$image.getWidth(), this.$image.getHeight(), this.$image.getType());
                        BufferedImage bufferedImage2 = this.$image;
                        BufferedImage invertedImage = bufferedImage;
                        boolean bl = false;
                        int n = bufferedImage2.getWidth();
                        for (int x = 0; x < n; ++x) {
                            int n2 = bufferedImage2.getHeight();
                            for (int y = 0; y < n2; ++y) {
                                int rgba = bufferedImage2.getRGB(x, y);
                                int alpha = rgba >>> 24;
                                int invertedRgba = alpha << 24 | ~rgba & 0xFFFFFF;
                                invertedImage.setRGB(x, y, invertedRgba);
                            }
                        }
                        return bufferedImage;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BufferedImage> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object applyReverseChannelsOrder$intellij_platform_images(@NotNull BufferedImage image, @NotNull Continuation<? super BufferedImage> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BufferedImage>, Object>(image, null){
            int label;
            final /* synthetic */ BufferedImage $image;
            {
                this.$image = $image;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        BufferedImage bufferedImage = new BufferedImage(this.$image.getWidth(), this.$image.getHeight(), this.$image.getType());
                        BufferedImage bufferedImage2 = this.$image;
                        BufferedImage reversedImage = bufferedImage;
                        boolean bl = false;
                        int n = bufferedImage2.getWidth();
                        for (int x = 0; x < n; ++x) {
                            int n2 = bufferedImage2.getHeight();
                            for (int y = 0; y < n2; ++y) {
                                int rgba = bufferedImage2.getRGB(x, y);
                                int alpha = rgba >>> 24;
                                int blue = rgba & 0xFF;
                                int green = rgba >> 8 & 0xFF;
                                int red = rgba >> 16 & 0xFF;
                                int reversedRgba = alpha << 24 | blue << 16 | green << 8 | red;
                                reversedImage.setRGB(x, y, reversedRgba);
                            }
                        }
                        return bufferedImage;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BufferedImage> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object applyBinarization$intellij_platform_images(@NotNull BufferedImage image, int threshold, @NotNull Continuation<? super BufferedImage> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BufferedImage>, Object>(image, threshold, null){
            int label;
            final /* synthetic */ BufferedImage $image;
            final /* synthetic */ int $threshold;
            {
                this.$image = $image;
                this.$threshold = $threshold;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        BufferedImage bufferedImage = new BufferedImage(this.$image.getWidth(), this.$image.getHeight(), 12);
                        BufferedImage bufferedImage2 = this.$image;
                        int n = this.$threshold;
                        BufferedImage binarizedImage = bufferedImage;
                        boolean bl = false;
                        int n2 = bufferedImage2.getHeight();
                        for (int y = 0; y < n2; ++y) {
                            int n3 = bufferedImage2.getWidth();
                            for (int x = 0; x < n3; ++x) {
                                int rgba = bufferedImage2.getRGB(x, y);
                                int alpha = rgba >>> 24;
                                int brightness = ScientificUtils.access$calculateBrightness(ScientificUtils.INSTANCE, rgba);
                                int binaryColor = brightness < n ? 0 : 0xFFFFFF;
                                binarizedImage.setRGB(x, y, alpha << 24 | binaryColor);
                            }
                        }
                        return bufferedImage;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BufferedImage> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object normalizeImage$intellij_platform_images(@NotNull BufferedImage image, @NotNull Continuation<? super BufferedImage> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BufferedImage>, Object>(image, null){
            int label;
            final /* synthetic */ BufferedImage $image;
            {
                this.$image = $image;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Pair pair = TuplesKt.to((Object)Boxing.boxInt((int)this.$image.getWidth()), (Object)Boxing.boxInt((int)this.$image.getHeight()));
                        int width = ((Number)pair.component1()).intValue();
                        int height = ((Number)pair.component2()).intValue();
                        Pair pair2 = TuplesKt.to((Object)Boxing.boxInt((int)255), (Object)Boxing.boxInt((int)0));
                        int rMin = ((Number)pair2.component1()).intValue();
                        int rMax = ((Number)pair2.component2()).intValue();
                        Pair pair3 = TuplesKt.to((Object)Boxing.boxInt((int)255), (Object)Boxing.boxInt((int)0));
                        int gMin = ((Number)pair3.component1()).intValue();
                        int gMax = ((Number)pair3.component2()).intValue();
                        Pair pair4 = TuplesKt.to((Object)Boxing.boxInt((int)255), (Object)Boxing.boxInt((int)0));
                        int bMin = ((Number)pair4.component1()).intValue();
                        int bMax = ((Number)pair4.component2()).intValue();
                        for (int y = 0; y < height; ++y) {
                            for (int x = 0; x < width; ++x) {
                                int rgb = this.$image.getRGB(x, y);
                                Triple triple = new Triple((Object)Boxing.boxInt((int)(rgb >> 16 & 0xFF)), (Object)Boxing.boxInt((int)(rgb >> 8 & 0xFF)), (Object)Boxing.boxInt((int)(rgb & 0xFF)));
                                int red = ((Number)triple.component1()).intValue();
                                int green = ((Number)triple.component2()).intValue();
                                int blue = ((Number)triple.component3()).intValue();
                                if (red < rMin) {
                                    rMin = red;
                                } else if (red > rMax) {
                                    rMax = red;
                                }
                                if (green < gMin) {
                                    gMin = green;
                                } else if (green > gMax) {
                                    gMax = green;
                                }
                                if (blue < bMin) {
                                    bMin = blue;
                                    continue;
                                }
                                if (blue <= bMax) continue;
                                bMax = blue;
                            }
                        }
                        Triple triple = new Triple((Object)TuplesKt.to((Object)Boxing.boxInt((int)rMin), (Object)Boxing.boxInt((int)rMax)), (Object)TuplesKt.to((Object)Boxing.boxInt((int)gMin), (Object)Boxing.boxInt((int)gMax)), (Object)TuplesKt.to((Object)Boxing.boxInt((int)bMin), (Object)Boxing.boxInt((int)bMax)));
                        Pair finalRed = (Pair)triple.component1();
                        Pair finalGreen = (Pair)triple.component2();
                        Pair finalBlue = (Pair)triple.component3();
                        BufferedImage bufferedImage = new BufferedImage(width, height, this.$image.getType());
                        BufferedImage bufferedImage2 = this.$image;
                        BufferedImage normalizedImage = bufferedImage;
                        boolean bl = false;
                        for (int y = 0; y < height; ++y) {
                            for (int x = 0; x < width; ++x) {
                                int rgb = bufferedImage2.getRGB(x, y);
                                int alpha = rgb & 0xFF000000;
                                Triple triple2 = new Triple((Object)Boxing.boxInt((int)(rgb >> 16 & 0xFF)), (Object)Boxing.boxInt((int)(rgb >> 8 & 0xFF)), (Object)Boxing.boxInt((int)(rgb & 0xFF)));
                                int red = ((Number)triple2.component1()).intValue();
                                int green = ((Number)triple2.component2()).intValue();
                                int blue = ((Number)triple2.component3()).intValue();
                                Triple triple3 = new Triple((Object)Boxing.boxInt((int)ScientificUtils.access$normalizeChannel(ScientificUtils.INSTANCE, red, ((Number)finalRed.getFirst()).intValue(), ((Number)finalRed.getSecond()).intValue())), (Object)Boxing.boxInt((int)ScientificUtils.access$normalizeChannel(ScientificUtils.INSTANCE, green, ((Number)finalGreen.getFirst()).intValue(), ((Number)finalGreen.getSecond()).intValue())), (Object)Boxing.boxInt((int)ScientificUtils.access$normalizeChannel(ScientificUtils.INSTANCE, blue, ((Number)finalBlue.getFirst()).intValue(), ((Number)finalBlue.getSecond()).intValue())));
                                int normalizedRed = ((Number)triple3.component1()).intValue();
                                int normalizedGreen = ((Number)triple3.component2()).intValue();
                                int normalizedBlue = ((Number)triple3.component3()).intValue();
                                int normalizedARGB = alpha | normalizedRed << 16 | normalizedGreen << 8 | normalizedBlue;
                                normalizedImage.setRGB(x, y, normalizedARGB);
                            }
                        }
                        return bufferedImage;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BufferedImage> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final int normalizeChannel(int value, int min, int max) {
        return max > min ? RangesKt.coerceIn((int)((value - min) * 255 / (max - min)), (int)0, (int)255) : value;
    }

    private final int calculateBrightness(int rgba) {
        int red = rgba >> 16 & 0xFF;
        int green = rgba >> 8 & 0xFF;
        int blue = rgba & 0xFF;
        return (int)(0.2126 * (double)red + 0.7152 * (double)green + 0.0722 * (double)blue);
    }

    public static final /* synthetic */ int access$calculateBrightness(ScientificUtils $this, int rgba) {
        return $this.calculateBrightness(rgba);
    }

    public static final /* synthetic */ int access$normalizeChannel(ScientificUtils $this, int value, int min, int max) {
        return $this.normalizeChannel(value, min, max);
    }
}

