/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.internal.daemon;

import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.daemon.client.DaemonClientFactory;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.configuration.DaemonPriority;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.internal.daemon.GradleDaemonParametersFactory;
import org.jetbrains.plugins.gradle.internal.daemon.GradleServiceLookup;
import org.jetbrains.plugins.gradle.internal.daemon.GradleServiceLookupProxy;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\b\u0010\r\u001a\u00020\u000eH\u0002\u001a\b\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"getDaemonServiceFactory", "Lorg/gradle/internal/service/ServiceRegistry;", "daemonClientFactory", "Lorg/gradle/launcher/daemon/client/DaemonClientFactory;", "myServiceDirectoryPath", "", "getDaemonServicesBefore8Dot8", "parameters", "Lorg/gradle/launcher/daemon/configuration/DaemonParameters;", "getDaemonServicesAfter8Dot13", "getDaemonServicesAfter8Dot8", "getBuildLayoutParameters", "Lorg/gradle/initialization/BuildLayoutParameters;", "getGradleServiceLookup", "Lorg/jetbrains/plugins/gradle/internal/daemon/GradleServiceLookup;", "getDaemonRequestContextAfter8Dot8", "", "intellij.gradle"})
@JvmName(name="DaemonServicesFactory")
@SourceDebugExtension(value={"SMAP\nDaemonServicesFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DaemonServicesFactory.kt\norg/jetbrains/plugins/gradle/internal/daemon/DaemonServicesFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n1#2:208\n*E\n"})
public final class DaemonServicesFactory {
    @NotNull
    public static final ServiceRegistry getDaemonServiceFactory(@NotNull DaemonClientFactory daemonClientFactory, @Nullable String myServiceDirectoryPath) {
        Intrinsics.checkNotNullParameter((Object)daemonClientFactory, (String)"daemonClientFactory");
        BuildLayoutParameters layoutParameters = DaemonServicesFactory.getBuildLayoutParameters(myServiceDirectoryPath);
        DaemonParameters daemonParameters = GradleDaemonParametersFactory.getDaemonParameters(layoutParameters);
        return GradleVersionUtil.isCurrentGradleAtLeast((String)"8.13") ? DaemonServicesFactory.getDaemonServicesAfter8Dot13(daemonClientFactory, daemonParameters) : (GradleVersionUtil.isCurrentGradleAtLeast((String)"8.8") ? DaemonServicesFactory.getDaemonServicesAfter8Dot8(daemonClientFactory, daemonParameters) : DaemonServicesFactory.getDaemonServicesBefore8Dot8(daemonClientFactory, daemonParameters));
    }

    private static final ServiceRegistry getDaemonServicesBefore8Dot8(DaemonClientFactory daemonClientFactory, DaemonParameters parameters) {
        try {
            Class[] classArray = new Class[]{OutputEventListener.class, DaemonParameters.class, InputStream.class};
            Method method = DaemonClientFactory.class.getDeclaredMethod("createBuildClientServices", classArray);
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"getDeclaredMethod(...)");
            Method method2 = method;
            Object[] objectArray = new Object[]{DaemonServicesFactory::getDaemonServicesBefore8Dot8$lambda$0, parameters, new ByteArrayInputStream(new byte[0])};
            Object object = method2.invoke((Object)daemonClientFactory, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
            Object invocationResult = object;
            return (ServiceRegistry)invocationResult;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Cannot resolve ServiceRegistry by reflection. Gradle version: " + GradleVersion.current(), e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Unable to cast the result of the invocation to ServiceRegistry. Gradle version: " + GradleVersion.current(), e);
        }
    }

    private static final ServiceRegistry getDaemonServicesAfter8Dot13(DaemonClientFactory daemonClientFactory, DaemonParameters parameters) {
        try {
            Class<?> daemonRequestContextClass = Class.forName("org.gradle.launcher.daemon.context.DaemonRequestContext");
            Class<?> serviceLookupClass = Class.forName("org.gradle.internal.service.ServiceLookup");
            Class[] classArray = new Class[]{serviceLookupClass, DaemonParameters.class, daemonRequestContextClass, InputStream.class, Optional.class};
            Method method = DaemonClientFactory.class.getDeclaredMethod("createBuildClientServices", classArray);
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"getDeclaredMethod(...)");
            Method createBuildClientServicesMethod = method;
            GradleServiceLookup serviceLookupDelegate = DaemonServicesFactory.getGradleServiceLookup();
            Object serviceLookup = GradleServiceLookupProxy.INSTANCE.newProxyInstance(serviceLookupDelegate);
            Object requestContext = DaemonServicesFactory.getDaemonRequestContextAfter8Dot8();
            Object[] objectArray = new Object[]{serviceLookup, parameters, requestContext, new ByteArrayInputStream(new byte[0]), Optional.empty()};
            Object object = createBuildClientServicesMethod.invoke((Object)daemonClientFactory, objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gradle.internal.service.ServiceRegistry");
            return (ServiceRegistry)object;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Cannot resolve ServiceRegistry by reflection. Gradle version: " + GradleVersion.current(), e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Unable to cast the result of the invocation to ServiceRegistry. Gradle version: " + GradleVersion.current(), e);
        }
    }

    private static final ServiceRegistry getDaemonServicesAfter8Dot8(DaemonClientFactory daemonClientFactory, DaemonParameters parameters) {
        try {
            Class<?> daemonRequestContextClass = Class.forName("org.gradle.launcher.daemon.context.DaemonRequestContext");
            Class<?> serviceLookupClass = Class.forName("org.gradle.internal.service.ServiceLookup");
            Class[] classArray = new Class[]{serviceLookupClass, DaemonParameters.class, daemonRequestContextClass, InputStream.class};
            Method method = DaemonClientFactory.class.getDeclaredMethod("createBuildClientServices", classArray);
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"getDeclaredMethod(...)");
            Method createBuildClientServicesMethod = method;
            GradleServiceLookup serviceLookupDelegate = DaemonServicesFactory.getGradleServiceLookup();
            Object serviceLookup = GradleServiceLookupProxy.INSTANCE.newProxyInstance(serviceLookupDelegate);
            Object requestContext = DaemonServicesFactory.getDaemonRequestContextAfter8Dot8();
            Object[] objectArray = new Object[]{serviceLookup, parameters, requestContext, new ByteArrayInputStream(new byte[0])};
            Object object = createBuildClientServicesMethod.invoke((Object)daemonClientFactory, objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gradle.internal.service.ServiceRegistry");
            return (ServiceRegistry)object;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Cannot resolve ServiceRegistry by reflection. Gradle version: " + GradleVersion.current(), e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Unable to cast the result of the invocation to ServiceRegistry. Gradle version: " + GradleVersion.current(), e);
        }
    }

    private static final BuildLayoutParameters getBuildLayoutParameters(String myServiceDirectoryPath) {
        BuildLayoutParameters layout = new BuildLayoutParameters();
        CharSequence charSequence = myServiceDirectoryPath;
        if (!(charSequence == null || charSequence.length() == 0)) {
            layout.setGradleUserHomeDir(new File(myServiceDirectoryPath));
        }
        return layout;
    }

    private static final GradleServiceLookup getGradleServiceLookup() {
        Class<?> userInputReceiverClass = Class.forName("org.gradle.internal.logging.console.GlobalUserInputReceiver");
        Object object = new Class[]{userInputReceiverClass};
        Object userInputReceiver = Proxy.newProxyInstance(userInputReceiverClass.getClassLoader(), object, DaemonServicesFactory::getGradleServiceLookup$lambda$1);
        Object $this$getGradleServiceLookup_u24lambda_u242 = object = new GradleServiceLookup();
        boolean bl = false;
        Type type = (Type)((Object)OutputEventListener.class);
        OutputEventListener outputEventListener = OutputEventListener.NO_OP;
        Intrinsics.checkNotNullExpressionValue((Object)outputEventListener, (String)"NO_OP");
        ((GradleServiceLookup)$this$getGradleServiceLookup_u24lambda_u242).register(type, outputEventListener);
        Intrinsics.checkNotNull(userInputReceiverClass);
        Type type2 = userInputReceiverClass;
        Intrinsics.checkNotNull((Object)userInputReceiver);
        ((GradleServiceLookup)$this$getGradleServiceLookup_u24lambda_u242).register(type2, userInputReceiver);
        return object;
    }

    private static final Object getDaemonRequestContextAfter8Dot8() {
        Object[] objectArray;
        Object object;
        Class<?> requestContextClass;
        block6: {
            requestContextClass = Class.forName("org.gradle.launcher.daemon.context.DaemonRequestContext");
            Class<?> nativeServicesClass = Class.forName("org.gradle.internal.nativeintegration.services.NativeServices");
            Class<?>[] classArray = nativeServicesClass.getDeclaredClasses();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getDeclaredClasses(...)");
            for (Object classArray22 : (Object[])classArray) {
                Class it = (Class)classArray22;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"NativeServicesMode", (boolean)false, (int)2, null)) continue;
                object = classArray22;
                break block6;
            }
            object = null;
        }
        Class clazz = (Class)object;
        if (clazz == null) {
            throw new IllegalStateException("The NativeServicesMode class is not found inside the NativeServices class. Gradle version: " + GradleVersion.current());
        }
        Class nativeServicesModeClass = clazz;
        if (!nativeServicesModeClass.isEnum()) {
            throw new IllegalStateException("NativeServicesMode is expected to be a Enum. Gradle version: " + GradleVersion.current());
        }
        Class<?> daemonJvmCriteriaClass = Class.forName("org.gradle.launcher.daemon.toolchain.DaemonJvmCriteria");
        Object nativeServiceModeValue = nativeServicesModeClass.getEnumConstants()[2];
        if (GradleVersionUtil.isCurrentGradleAtLeast((String)"8.10")) {
            Class[] classArray4 = new Class[]{daemonJvmCriteriaClass, Collection.class, Boolean.TYPE, nativeServicesModeClass, DaemonPriority.class};
            Constructor<?> requestContextConstructor = requestContextClass.getDeclaredConstructor(classArray4);
            Object[] objectArray2 = new Object[]{null, CollectionsKt.emptyList(), false, nativeServiceModeValue, DaemonPriority.NORMAL};
            Object obj = requestContextConstructor.newInstance(objectArray2);
            Intrinsics.checkNotNullExpressionValue(obj, (String)"newInstance(...)");
            return obj;
        }
        Class<?> legacyDaemonPriorityClass = Class.forName("org.gradle.launcher.daemon.configuration.DaemonParameters$Priority");
        if (!legacyDaemonPriorityClass.isEnum()) {
            throw new IllegalStateException("DaemonParameters.Priority is expected to be a Enum. Gradle version: " + GradleVersion.current());
        }
        Object normalDaemonPriority = legacyDaemonPriorityClass.getEnumConstants()[1];
        if (GradleVersionUtil.isCurrentGradleAtLeast((String)"8.9")) {
            Class[] classArray = new Class[]{daemonJvmCriteriaClass, Collection.class, Boolean.TYPE, nativeServicesModeClass, legacyDaemonPriorityClass};
            Constructor<?> requestContextConstructor = requestContextClass.getDeclaredConstructor(classArray);
            objectArray = new Object[]{null, CollectionsKt.emptyList(), false, nativeServiceModeValue, normalDaemonPriority};
            Object obj = requestContextConstructor.newInstance(objectArray);
            Intrinsics.checkNotNullExpressionValue(obj, (String)"newInstance(...)");
            return obj;
        }
        Class[] classArray = new Class[]{JavaInfo.class, daemonJvmCriteriaClass, Collection.class, Boolean.TYPE, nativeServicesModeClass, legacyDaemonPriorityClass};
        Constructor<?> requestContextConstructor = requestContextClass.getDeclaredConstructor(classArray);
        objectArray = new Object[]{null, null, CollectionsKt.emptyList(), false, nativeServiceModeValue, normalDaemonPriority};
        Object obj = requestContextConstructor.newInstance(objectArray);
        Intrinsics.checkNotNullExpressionValue(obj, (String)"newInstance(...)");
        return obj;
    }

    private static final void getDaemonServicesBefore8Dot8$lambda$0(OutputEvent it) {
    }

    private static final Unit getGradleServiceLookup$lambda$1(Object object, Method method, Object[] objectArray) {
        return Unit.INSTANCE;
    }
}

