/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticRenderers;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0016J(\u0010\t\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\f0\u000bH\u0016J(\u0010\r\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/MultiplatformDiagnosticRenderingMode;", "", "<init>", "()V", "newLine", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "renderList", "elements", "", "Lkotlin/Function0;", "renderSymbol", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "indent", "", "checkers"})
public class MultiplatformDiagnosticRenderingMode {
    public void newLine(@NotNull StringBuilder sb) {
        Intrinsics.checkNotNullParameter(sb, "sb");
        sb.append('\n');
    }

    public void renderList(@NotNull StringBuilder sb, @NotNull List<? extends Function0<Unit>> elements) {
        Intrinsics.checkNotNullParameter(sb, "sb");
        Intrinsics.checkNotNullParameter(elements, "elements");
        sb.append('\n');
        for (Function0<Unit> function0 : elements) {
            function0.invoke();
        }
    }

    public void renderSymbol(@NotNull StringBuilder sb, @NotNull FirBasedSymbol<?> symbol, @NotNull String indent) {
        Intrinsics.checkNotNullParameter(sb, "sb");
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(indent, "indent");
        sb.append(indent);
        sb.append("    ");
        sb.append(FirDiagnosticRenderers.INSTANCE.getSYMBOL().render(symbol)).append('\n');
    }
}

