/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProviderKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\u0010\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\u0018\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0010\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\u0018\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\rH\u0016R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u0010\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR\u0014\u0010\u0014\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "", "<init>", "()V", "getPackageNames", "", "", "hasSpecificClassifierPackageNamesComputation", "", "getHasSpecificClassifierPackageNamesComputation", "()Z", "getPackageNamesWithTopLevelClassifiers", "getTopLevelClassifierNamesInPackage", "Lorg/jetbrains/kotlin/name/Name;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "hasSpecificCallablePackageNamesComputation", "getHasSpecificCallablePackageNamesComputation", "getPackageNamesWithTopLevelCallables", "getTopLevelCallableNamesInPackage", "mayHaveSyntheticFunctionTypes", "getMayHaveSyntheticFunctionTypes", "mayHaveSyntheticFunctionType", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "mayHaveTopLevelClassifier", "mayHaveTopLevelCallable", "name", "providers"})
public abstract class FirSymbolNamesProvider {
    @Nullable
    public Set<String> getPackageNames() {
        return null;
    }

    public abstract boolean getHasSpecificClassifierPackageNamesComputation();

    @Nullable
    public Set<String> getPackageNamesWithTopLevelClassifiers() {
        return this.getPackageNames();
    }

    @Nullable
    public abstract Set<Name> getTopLevelClassifierNamesInPackage(@NotNull FqName var1);

    public abstract boolean getHasSpecificCallablePackageNamesComputation();

    @Nullable
    public Set<String> getPackageNamesWithTopLevelCallables() {
        return this.getPackageNames();
    }

    @Nullable
    public abstract Set<Name> getTopLevelCallableNamesInPackage(@NotNull FqName var1);

    public boolean getMayHaveSyntheticFunctionTypes() {
        return false;
    }

    public boolean mayHaveSyntheticFunctionType(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return this.getMayHaveSyntheticFunctionTypes();
    }

    public boolean mayHaveTopLevelClassifier(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        if (this.getMayHaveSyntheticFunctionTypes() && this.mayHaveSyntheticFunctionType(classId)) {
            return true;
        }
        Set<Name> set = this.getTopLevelClassifierNamesInPackage(classId.getPackageFqName());
        if (set == null) {
            return true;
        }
        Set<Name> names = set;
        return !(classId.getOuterClassId() == null ? !FirSymbolNamesProviderKt.access$mayContainTopLevelClassifier(names, classId.getShortClassName()) : !FirSymbolNamesProviderKt.access$mayContainTopLevelClassifier(names, classId.getOutermostClassId().getShortClassName()));
    }

    public boolean mayHaveTopLevelCallable(@NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name2, "name");
        if (name2.isSpecial()) {
            return true;
        }
        Set<Name> set = this.getTopLevelCallableNamesInPackage(packageFqName);
        if (set == null) {
            return true;
        }
        Set<Name> names = set;
        return names.contains(name2);
    }
}

