/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CompilerSystemProperties;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003#$%B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u000e\u0010\nR\u001b\u0010\u0010\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\f\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0015\u001a\u00020\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\f\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u001a\u001a\u00020\u001b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\f\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001f\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\f\u001a\u0004\b \u0010!\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/daemon/common/LoopbackNetworkInterface;", "", "<init>", "()V", "IPV4_LOOPBACK_INET_ADDRESS", "", "IPV6_LOOPBACK_INET_ADDRESS", "SERVER_SOCKET_BACKLOG_SIZE", "", "getSERVER_SOCKET_BACKLOG_SIZE", "()I", "SERVER_SOCKET_BACKLOG_SIZE$delegate", "Lkotlin/Lazy;", "SOCKET_CONNECT_ATTEMPTS", "getSOCKET_CONNECT_ATTEMPTS", "SOCKET_CONNECT_ATTEMPTS$delegate", "SOCKET_CONNECT_INTERVAL_MS", "", "getSOCKET_CONNECT_INTERVAL_MS", "()J", "SOCKET_CONNECT_INTERVAL_MS$delegate", "serverLoopbackSocketFactory", "Lorg/jetbrains/kotlin/daemon/common/LoopbackNetworkInterface$ServerLoopbackSocketFactory;", "getServerLoopbackSocketFactory", "()Lorg/jetbrains/kotlin/daemon/common/LoopbackNetworkInterface$ServerLoopbackSocketFactory;", "serverLoopbackSocketFactory$delegate", "clientLoopbackSocketFactory", "Lorg/jetbrains/kotlin/daemon/common/LoopbackNetworkInterface$ClientLoopbackSocketFactory;", "getClientLoopbackSocketFactory", "()Lorg/jetbrains/kotlin/daemon/common/LoopbackNetworkInterface$ClientLoopbackSocketFactory;", "clientLoopbackSocketFactory$delegate", "loopbackInetAddressName", "getLoopbackInetAddressName", "()Ljava/lang/String;", "loopbackInetAddressName$delegate", "ServerLoopbackSocketFactory", "AbstractClientLoopbackSocketFactory", "ClientLoopbackSocketFactory", "daemon-common"})
public final class LoopbackNetworkInterface {
    @NotNull
    public static final LoopbackNetworkInterface INSTANCE = new LoopbackNetworkInterface();
    @NotNull
    public static final String IPV4_LOOPBACK_INET_ADDRESS = "127.0.0.1";
    @NotNull
    public static final String IPV6_LOOPBACK_INET_ADDRESS = "::1";
    @NotNull
    private static final Lazy SERVER_SOCKET_BACKLOG_SIZE$delegate = LazyKt.lazy(LoopbackNetworkInterface::SERVER_SOCKET_BACKLOG_SIZE_delegate$lambda$0);
    @NotNull
    private static final Lazy SOCKET_CONNECT_ATTEMPTS$delegate = LazyKt.lazy(LoopbackNetworkInterface::SOCKET_CONNECT_ATTEMPTS_delegate$lambda$1);
    @NotNull
    private static final Lazy SOCKET_CONNECT_INTERVAL_MS$delegate = LazyKt.lazy(LoopbackNetworkInterface::SOCKET_CONNECT_INTERVAL_MS_delegate$lambda$2);
    @NotNull
    private static final Lazy serverLoopbackSocketFactory$delegate = LazyKt.lazy(LoopbackNetworkInterface::serverLoopbackSocketFactory_delegate$lambda$3);
    @NotNull
    private static final Lazy clientLoopbackSocketFactory$delegate = LazyKt.lazy(LoopbackNetworkInterface::clientLoopbackSocketFactory_delegate$lambda$4);
    @NotNull
    private static final Lazy loopbackInetAddressName$delegate = LazyKt.lazy(LoopbackNetworkInterface::loopbackInetAddressName_delegate$lambda$5);

    private LoopbackNetworkInterface() {
    }

    public final int getSERVER_SOCKET_BACKLOG_SIZE() {
        Lazy lazy = SERVER_SOCKET_BACKLOG_SIZE$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getSOCKET_CONNECT_ATTEMPTS() {
        Lazy lazy = SOCKET_CONNECT_ATTEMPTS$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final long getSOCKET_CONNECT_INTERVAL_MS() {
        Lazy lazy = SOCKET_CONNECT_INTERVAL_MS$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    @NotNull
    public final ServerLoopbackSocketFactory getServerLoopbackSocketFactory() {
        Lazy lazy = serverLoopbackSocketFactory$delegate;
        return (ServerLoopbackSocketFactory)lazy.getValue();
    }

    @NotNull
    public final ClientLoopbackSocketFactory getClientLoopbackSocketFactory() {
        Lazy lazy = clientLoopbackSocketFactory$delegate;
        return (ClientLoopbackSocketFactory)lazy.getValue();
    }

    @NotNull
    public final String getLoopbackInetAddressName() {
        Lazy lazy = loopbackInetAddressName$delegate;
        return (String)lazy.getValue();
    }

    private static final int SERVER_SOCKET_BACKLOG_SIZE_delegate$lambda$0() {
        Object object = CompilerSystemProperties.DAEMON_RMI_SOCKET_BACKLOG_SIZE_PROPERTY.getValue();
        return object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 50;
    }

    private static final int SOCKET_CONNECT_ATTEMPTS_delegate$lambda$1() {
        Object object = CompilerSystemProperties.DAEMON_RMI_SOCKET_CONNECT_ATTEMPTS_PROPERTY.getValue();
        return object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 3;
    }

    private static final long SOCKET_CONNECT_INTERVAL_MS_delegate$lambda$2() {
        Object object = CompilerSystemProperties.DAEMON_RMI_SOCKET_CONNECT_INTERVAL_PROPERTY.getValue();
        return object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : 10L;
    }

    private static final ServerLoopbackSocketFactory serverLoopbackSocketFactory_delegate$lambda$3() {
        return new ServerLoopbackSocketFactory();
    }

    private static final ClientLoopbackSocketFactory clientLoopbackSocketFactory_delegate$lambda$4() {
        return new ClientLoopbackSocketFactory();
    }

    private static final String loopbackInetAddressName_delegate$lambda$5() {
        String string2;
        try {
            string2 = InetAddress.getByName(null) instanceof Inet6Address ? IPV6_LOOPBACK_INET_ADDRESS : IPV4_LOOPBACK_INET_ADDRESS;
        }
        catch (IOException e) {
            string2 = IPV4_LOOPBACK_INET_ADDRESS;
        }
        return string2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0013\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0096\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u001d\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH$\u00a2\u0006\u0002\u0010\u000fJ\u001b\u0010\u0010\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/daemon/common/LoopbackNetworkInterface$AbstractClientLoopbackSocketFactory;", "SocketType", "Ljava/io/Serializable;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "socketCreate", "host", "", "port", "(Ljava/lang/String;I)Ljava/lang/Object;", "createSocket", "daemon-common"})
    public static abstract class AbstractClientLoopbackSocketFactory<SocketType>
    implements Serializable {
        public boolean equals(@Nullable Object other) {
            return other == this || super.equals(other);
        }

        public int hashCode() {
            return super.hashCode();
        }

        protected abstract SocketType socketCreate(@NotNull String var1, int var2);

        public final SocketType createSocket(@NotNull String host, int port) throws IOException {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            int attemptsLeft = INSTANCE.getSOCKET_CONNECT_ATTEMPTS();
            while (true) {
                try {
                    return this.socketCreate(host, port);
                }
                catch (ConnectException e) {
                    if (--attemptsLeft <= 0) {
                        throw e;
                    }
                    Thread.sleep(INSTANCE.getSOCKET_CONNECT_INTERVAL_MS());
                    continue;
                }
                break;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/daemon/common/LoopbackNetworkInterface$ClientLoopbackSocketFactory;", "Lorg/jetbrains/kotlin/daemon/common/LoopbackNetworkInterface$AbstractClientLoopbackSocketFactory;", "Ljava/net/Socket;", "Ljava/rmi/server/RMIClientSocketFactory;", "<init>", "()V", "socketCreate", "host", "", "port", "", "daemon-common"})
    public static final class ClientLoopbackSocketFactory
    extends AbstractClientLoopbackSocketFactory<Socket>
    implements RMIClientSocketFactory {
        @Override
        @NotNull
        protected Socket socketCreate(@NotNull String host, int port) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return new Socket(InetAddress.getByName(null), port);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0013\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0096\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/daemon/common/LoopbackNetworkInterface$ServerLoopbackSocketFactory;", "Ljava/rmi/server/RMIServerSocketFactory;", "Ljava/io/Serializable;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "createServerSocket", "Ljava/net/ServerSocket;", "port", "daemon-common"})
    public static final class ServerLoopbackSocketFactory
    implements RMIServerSocketFactory,
    Serializable {
        public boolean equals(@Nullable Object other) {
            return other == this || super.equals(other);
        }

        public int hashCode() {
            return super.hashCode();
        }

        @Override
        @NotNull
        public ServerSocket createServerSocket(int port) throws IOException {
            return new ServerSocket(port, INSTANCE.getSERVER_SOCKET_BACKLOG_SIZE(), InetAddress.getByName(null));
        }
    }
}

