/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.janocchio;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.openscience.jmol.app.janocchio.NMR_JmolPanel;

public class LoadMeasureThread
extends Thread {
    protected NMR_JmolPanel nmrPanel;
    protected BufferedReader inp;
    String command;

    public LoadMeasureThread() {
    }

    public LoadMeasureThread(NMR_JmolPanel nmrPanel, String data) {
        this.nmrPanel = nmrPanel;
        this.inp = new BufferedReader(new StringReader(data));
    }

    protected void addCommand(int i, String l) {
        this.command = this.command + ";" + this.nmrPanel.labelSetter.setLabel(i, l);
    }

    @Override
    public void run() {
        try {
            if (this.setLabels()) {
                String[] labelArray = this.nmrPanel.labelSetter.getLabelArray();
                this.nmrPanel.noeTable.setLabelArray(labelArray);
                this.nmrPanel.coupleTable.setLabelArray(labelArray);
            }
            this.setCouples();
            this.setNOEs();
            this.setMore();
            this.nmrPanel.noeTable.addMol();
            this.nmrPanel.noeTable.updateTables();
            this.nmrPanel.coupleTable.addMol();
            this.nmrPanel.coupleTable.updateTables();
            this.nmrPanel.vwr.scriptWait(this.command);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                this.inp.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void setMore() {
    }

    protected void setCouples() throws Exception {
        String line;
        while ((line = this.inp.readLine()) != null && line.trim().length() != 0) {
            String[] l = line.split("\\s+");
            int ia = new Integer(l[0]);
            int ib = new Integer(l[1]);
            int ic = new Integer(l[2]);
            int id = new Integer(l[3]);
            this.addCouple(ia, ib, ic, id, l[4]);
        }
    }

    protected void addCouple(int ia, int ib, int ic, int id, String exp) {
        this.command = this.command + ";measure @@" + ia + " @@" + ib + " @@" + ic + " @@" + id;
        if (exp != null && !exp.equals("null")) {
            this.nmrPanel.coupleTable.setExpCouple(exp, ia - 1, id - 1);
        }
    }

    protected void setNOEs() throws Exception {
        String line;
        while ((line = this.inp.readLine()).trim().length() != 0) {
            String[] l = line.split("\\s+");
            int ia = new Integer(l[0]);
            int ib = new Integer(l[1]);
            this.addNOE(ia, ib, l[2], null);
        }
    }

    protected void addNOE(int ia, int ib, String exp, String expd) {
        this.command = this.command + ";measure @@" + ia + " @@" + ib;
        if (exp != null && !exp.equals("null")) {
            this.nmrPanel.noeTable.setExpNoe(exp, ia - 1, ib - 1);
        }
        this.command = this.command + ";measure @@" + ia + " @@" + ib;
        if (exp != null) {
            this.nmrPanel.noeTable.setExpNoe(exp, ia - 1, ib - 1);
        }
        if (expd != null) {
            this.nmrPanel.noeTable.setExpDist(expd, ia - 1, ib - 1);
        }
    }

    protected boolean setLabels() throws Exception {
        String line;
        while ((line = this.inp.readLine()).trim().length() != 0) {
            String[] l = line.split("\\s+");
            int i = new Integer(l[0]);
            this.command = this.command + ";" + this.nmrPanel.labelSetter.setLabel(i - 1, l[1]);
        }
        return true;
    }

    public void loadAndRun(String structureFile) {
        this.nmrPanel.runScriptWithCallback(this, "load \"" + structureFile + "\"");
    }
}

