/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.atomdata;

import javajs.util.SB;
import org.jmol.c.VDW;

public class RadiusData {
    public String info;
    public EnumType factorType = EnumType.ABSOLUTE;
    public VDW vdwType = VDW.AUTO;
    public float value = Float.NaN;
    public float valueExtended = 0.0f;
    public float[] values;

    public RadiusData(float[] values, float value, EnumType factorType, VDW vdwType) {
        if (values != null) {
            this.values = values;
            this.value = 2.1474836E9f;
            return;
        }
        if (factorType == null) {
            return;
        }
        this.factorType = factorType;
        this.value = value;
        if (vdwType != null) {
            this.vdwType = vdwType;
        }
    }

    public String toString() {
        if (Float.isNaN(this.value)) {
            return "";
        }
        SB sb = new SB();
        switch (this.factorType) {
            case ABSOLUTE: {
                sb.appendF(this.value);
                break;
            }
            case OFFSET: {
                sb.append(this.value > 0.0f ? "+" : "").appendF(this.value);
                break;
            }
            case FACTOR: {
                sb.appendI((int)(this.value * 100.0f)).append("%");
                if (this.vdwType == VDW.AUTO) break;
                sb.append(this.vdwType.getVdwLabel());
                break;
            }
            case SCREEN: {
                sb.appendI((int)this.value);
            }
        }
        return sb.toString();
    }

    public static enum EnumType {
        ABSOLUTE,
        OFFSET,
        FACTOR,
        SCREEN;

    }
}

