/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class OsmImporter
extends FileImporter {
    public static final ExtensionFileFilter FILE_FILTER = ExtensionFileFilter.newFilterWithArchiveExtensions("osm,xml", "osm", I18n.tr("OSM Server Files", new Object[0]) + " (*.osm, *.osm.gz, *.osm.bz2, *.osm.xz, *.osm.zip, *.xml)", ExtensionFileFilter.AddArchiveExtension.NONE, Arrays.asList("gz", "bz", "bz2", "xz", "zip"));

    public OsmImporter() {
        super(FILE_FILTER);
    }

    public OsmImporter(ExtensionFileFilter filter) {
        super(filter);
    }

    @Override
    public void importData(File file, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        try (InputStream in = Compression.getUncompressedFileInputStream(file);){
            this.importData(in, file, progressMonitor);
        }
        catch (FileNotFoundException e) {
            Logging.error(e);
            throw new IOException(I18n.tr("File ''{0}'' does not exist.", file.getName()), e);
        }
    }

    protected void importData(InputStream in, File associatedFile, ProgressMonitor pm) throws IllegalDataException {
        OsmImporterData data = this.loadLayer(in, associatedFile, associatedFile == null ? OsmDataLayer.createNewName() : associatedFile.getName(), pm);
        OsmDataLayer layer = data.getLayer();
        MainApplication.getLayerManager().addLayer(layer);
        GuiHelper.runInEDT(() -> {
            data.getPostLayerTask().run();
            data.getLayer().onPostLoadFromFile();
        });
    }

    public OsmImporterData loadLayer(InputStream in, File associatedFile, String layerName, ProgressMonitor progressMonitor) throws IllegalDataException {
        DataSet dataSet = this.parseDataSet(in, progressMonitor);
        if (dataSet == null) {
            throw new IllegalDataException(I18n.tr("Invalid dataset", new Object[0]));
        }
        OsmDataLayer layer = this.createLayer(dataSet, associatedFile, layerName);
        Runnable postLayerTask = this.createPostLayerTask(dataSet, associatedFile, layerName, layer);
        return new OsmImporterData(layer, postLayerTask);
    }

    protected DataSet parseDataSet(InputStream in, ProgressMonitor progressMonitor) throws IllegalDataException {
        return OsmReader.parseDataSet(in, progressMonitor);
    }

    protected OsmDataLayer createLayer(DataSet dataSet, File associatedFile, String layerName) {
        return new OsmDataLayer(dataSet, layerName, associatedFile);
    }

    protected Runnable createPostLayerTask(DataSet dataSet, File associatedFile, String layerName, OsmDataLayer layer) {
        return () -> {
            if (dataSet.allPrimitives().isEmpty()) {
                String msg = associatedFile == null ? I18n.tr("No data found for layer ''{0}''.", layerName) : I18n.tr("No data found in file ''{0}''.", associatedFile.getPath());
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), msg, I18n.tr("Open OSM file", new Object[0]), 1);
            }
            layer.onPostLoadFromFile();
        };
    }

    public static class OsmImporterData {
        private final OsmDataLayer layer;
        private final Runnable postLayerTask;

        public OsmImporterData(OsmDataLayer layer, Runnable postLayerTask) {
            this.layer = layer;
            this.postLayerTask = postLayerTask;
        }

        public OsmDataLayer getLayer() {
            return this.layer;
        }

        public Runnable getPostLayerTask() {
            return this.postLayerTask;
        }
    }
}

