/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AudioFloatConverter;
import com.sun.media.sound.AudioFloatInputStream;
import com.sun.media.sound.SoftAbstractResampler;
import com.sun.media.sound.SoftCubicResampler;
import com.sun.media.sound.SoftLanczosResampler;
import com.sun.media.sound.SoftLinearResampler;
import com.sun.media.sound.SoftLinearResampler2;
import com.sun.media.sound.SoftPointResampler;
import com.sun.media.sound.SoftSincResampler;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.FormatConversionProvider;

public final class AudioFloatFormatConverter
extends FormatConversionProvider {
    private final AudioFormat.Encoding[] formats = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED, AudioFormat.Encoding.PCM_FLOAT};

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        if (audioInputStream.getFormat().getEncoding().equals(encoding)) {
            return audioInputStream;
        }
        AudioFormat audioFormat = audioInputStream.getFormat();
        int n = audioFormat.getChannels();
        AudioFormat.Encoding encoding2 = encoding;
        float f = audioFormat.getSampleRate();
        int n2 = audioFormat.getSampleSizeInBits();
        boolean bl = audioFormat.isBigEndian();
        if (encoding.equals(AudioFormat.Encoding.PCM_FLOAT)) {
            n2 = 32;
        }
        AudioFormat audioFormat2 = new AudioFormat(encoding2, f, n2, n, n * n2 / 8, f, bl);
        return this.getAudioInputStream(audioFormat2, audioInputStream);
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        if (!this.isConversionSupported(audioFormat, audioInputStream.getFormat())) {
            throw new IllegalArgumentException("Unsupported conversion: " + audioInputStream.getFormat().toString() + " to " + audioFormat.toString());
        }
        return this.getAudioInputStream(audioFormat, AudioFloatInputStream.getInputStream(audioInputStream));
    }

    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioFloatInputStream audioFloatInputStream) {
        if (!this.isConversionSupported(audioFormat, audioFloatInputStream.getFormat())) {
            throw new IllegalArgumentException("Unsupported conversion: " + audioFloatInputStream.getFormat().toString() + " to " + audioFormat.toString());
        }
        if (audioFormat.getChannels() != audioFloatInputStream.getFormat().getChannels()) {
            audioFloatInputStream = new AudioFloatInputStreamChannelMixer(audioFloatInputStream, audioFormat.getChannels());
        }
        if ((double)Math.abs(audioFormat.getSampleRate() - audioFloatInputStream.getFormat().getSampleRate()) > 1.0E-6) {
            audioFloatInputStream = new AudioFloatInputStreamResampler(audioFloatInputStream, audioFormat);
        }
        return new AudioInputStream(new AudioFloatFormatConverterInputStream(audioFormat, audioFloatInputStream), audioFormat, audioFloatInputStream.getFrameLength());
    }

    @Override
    public AudioFormat.Encoding[] getSourceEncodings() {
        return new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED, AudioFormat.Encoding.PCM_FLOAT};
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings() {
        return new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED, AudioFormat.Encoding.PCM_FLOAT};
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        if (AudioFloatConverter.getConverter(audioFormat) == null) {
            return new AudioFormat.Encoding[0];
        }
        return new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED, AudioFormat.Encoding.PCM_FLOAT};
    }

    @Override
    public AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        if (AudioFloatConverter.getConverter(audioFormat) == null) {
            return new AudioFormat[0];
        }
        int n = audioFormat.getChannels();
        ArrayList<AudioFormat> arrayList = new ArrayList<AudioFormat>();
        if (encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            arrayList.add(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, n, n, -1.0f, false));
        }
        if (encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            arrayList.add(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, n, n, -1.0f, false));
        }
        for (int i = 16; i < 32; i += 8) {
            if (encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
                arrayList.add(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, i, n, n * i / 8, -1.0f, false));
                arrayList.add(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, i, n, n * i / 8, -1.0f, true));
            }
            if (!encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED)) continue;
            arrayList.add(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, i, n, n * i / 8, -1.0f, true));
            arrayList.add(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, i, n, n * i / 8, -1.0f, false));
        }
        if (encoding.equals(AudioFormat.Encoding.PCM_FLOAT)) {
            arrayList.add(new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, -1.0f, 32, n, n * 4, -1.0f, false));
            arrayList.add(new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, -1.0f, 32, n, n * 4, -1.0f, true));
            arrayList.add(new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, -1.0f, 64, n, n * 8, -1.0f, false));
            arrayList.add(new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, -1.0f, 64, n, n * 8, -1.0f, true));
        }
        return arrayList.toArray(new AudioFormat[arrayList.size()]);
    }

    @Override
    public boolean isConversionSupported(AudioFormat audioFormat, AudioFormat audioFormat2) {
        if (AudioFloatConverter.getConverter(audioFormat2) == null) {
            return false;
        }
        if (AudioFloatConverter.getConverter(audioFormat) == null) {
            return false;
        }
        if (audioFormat2.getChannels() <= 0) {
            return false;
        }
        return audioFormat.getChannels() > 0;
    }

    @Override
    public boolean isConversionSupported(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        if (AudioFloatConverter.getConverter(audioFormat) == null) {
            return false;
        }
        for (int i = 0; i < this.formats.length; ++i) {
            if (!encoding.equals(this.formats[i])) continue;
            return true;
        }
        return false;
    }

    private static class AudioFloatInputStreamResampler
    extends AudioFloatInputStream {
        private final AudioFloatInputStream ais;
        private final AudioFormat targetFormat;
        private float[] skipbuffer;
        private SoftAbstractResampler resampler;
        private final float[] pitch = new float[1];
        private final float[] ibuffer2;
        private final float[][] ibuffer;
        private float ibuffer_index = 0.0f;
        private int ibuffer_len = 0;
        private final int nrofchannels;
        private float[][] cbuffer;
        private final int buffer_len = 512;
        private final int pad;
        private final int pad2;
        private final float[] ix = new float[1];
        private final int[] ox = new int[1];
        private float[][] mark_ibuffer = null;
        private float mark_ibuffer_index = 0.0f;
        private int mark_ibuffer_len = 0;

        AudioFloatInputStreamResampler(AudioFloatInputStream audioFloatInputStream, AudioFormat audioFormat) {
            this.ais = audioFloatInputStream;
            AudioFormat audioFormat2 = audioFloatInputStream.getFormat();
            this.targetFormat = new AudioFormat(audioFormat2.getEncoding(), audioFormat.getSampleRate(), audioFormat2.getSampleSizeInBits(), audioFormat2.getChannels(), audioFormat2.getFrameSize(), audioFormat.getSampleRate(), audioFormat2.isBigEndian());
            this.nrofchannels = this.targetFormat.getChannels();
            Object object = audioFormat.getProperty("interpolation");
            if (object != null && object instanceof String) {
                String string = (String)object;
                if (string.equalsIgnoreCase("point")) {
                    this.resampler = new SoftPointResampler();
                }
                if (string.equalsIgnoreCase("linear")) {
                    this.resampler = new SoftLinearResampler2();
                }
                if (string.equalsIgnoreCase("linear1")) {
                    this.resampler = new SoftLinearResampler();
                }
                if (string.equalsIgnoreCase("linear2")) {
                    this.resampler = new SoftLinearResampler2();
                }
                if (string.equalsIgnoreCase("cubic")) {
                    this.resampler = new SoftCubicResampler();
                }
                if (string.equalsIgnoreCase("lanczos")) {
                    this.resampler = new SoftLanczosResampler();
                }
                if (string.equalsIgnoreCase("sinc")) {
                    this.resampler = new SoftSincResampler();
                }
            }
            if (this.resampler == null) {
                this.resampler = new SoftLinearResampler2();
            }
            this.pitch[0] = audioFormat2.getSampleRate() / audioFormat.getSampleRate();
            this.pad = this.resampler.getPadding();
            this.pad2 = this.pad * 2;
            this.ibuffer = new float[this.nrofchannels][512 + this.pad2];
            this.ibuffer2 = new float[this.nrofchannels * 512];
            this.ibuffer_index = 512 + this.pad;
            this.ibuffer_len = 512;
        }

        @Override
        public int available() throws IOException {
            return 0;
        }

        @Override
        public void close() throws IOException {
            this.ais.close();
        }

        @Override
        public AudioFormat getFormat() {
            return this.targetFormat;
        }

        @Override
        public long getFrameLength() {
            return -1L;
        }

        @Override
        public void mark(int n) {
            this.ais.mark((int)((float)n * this.pitch[0]));
            this.mark_ibuffer_index = this.ibuffer_index;
            this.mark_ibuffer_len = this.ibuffer_len;
            if (this.mark_ibuffer == null) {
                this.mark_ibuffer = new float[this.ibuffer.length][this.ibuffer[0].length];
            }
            for (int i = 0; i < this.ibuffer.length; ++i) {
                float[] fArray = this.ibuffer[i];
                float[] fArray2 = this.mark_ibuffer[i];
                for (int j = 0; j < fArray2.length; ++j) {
                    fArray2[j] = fArray[j];
                }
            }
        }

        @Override
        public boolean markSupported() {
            return this.ais.markSupported();
        }

        private void readNextBuffer() throws IOException {
            int n;
            int n2;
            int n3;
            if (this.ibuffer_len == -1) {
                return;
            }
            for (n3 = 0; n3 < this.nrofchannels; ++n3) {
                float[] fArray = this.ibuffer[n3];
                int n4 = this.ibuffer_len + this.pad2;
                n2 = this.ibuffer_len;
                n = 0;
                while (n2 < n4) {
                    fArray[n] = fArray[n2];
                    ++n2;
                    ++n;
                }
            }
            this.ibuffer_index -= (float)this.ibuffer_len;
            this.ibuffer_len = this.ais.read(this.ibuffer2);
            if (this.ibuffer_len >= 0) {
                while (this.ibuffer_len < this.ibuffer2.length && (n3 = this.ais.read(this.ibuffer2, this.ibuffer_len, this.ibuffer2.length - this.ibuffer_len)) != -1) {
                    this.ibuffer_len += n3;
                }
                Arrays.fill(this.ibuffer2, this.ibuffer_len, this.ibuffer2.length, 0.0f);
                this.ibuffer_len /= this.nrofchannels;
            } else {
                Arrays.fill(this.ibuffer2, 0, this.ibuffer2.length, 0.0f);
            }
            n3 = this.ibuffer2.length;
            for (int i = 0; i < this.nrofchannels; ++i) {
                float[] fArray = this.ibuffer[i];
                n2 = i;
                n = this.pad2;
                while (n2 < n3) {
                    fArray[n] = this.ibuffer2[n2];
                    n2 += this.nrofchannels;
                    ++n;
                }
            }
        }

        @Override
        public int read(float[] fArray, int n, int n2) throws IOException {
            float[] fArray2;
            int n3;
            int n4;
            int n5;
            if (this.cbuffer == null || this.cbuffer[0].length < n2 / this.nrofchannels) {
                this.cbuffer = new float[this.nrofchannels][n2 / this.nrofchannels];
            }
            if (this.ibuffer_len == -1) {
                return -1;
            }
            if (n2 < 0) {
                return 0;
            }
            int n6 = n + n2;
            int n7 = 0;
            int n8 = this.ibuffer_len;
            for (n4 = n2 / this.nrofchannels; n4 > 0; n4 -= n7 - n5) {
                if (this.ibuffer_len >= 0) {
                    if (this.ibuffer_index >= (float)(this.ibuffer_len + this.pad)) {
                        this.readNextBuffer();
                    }
                    n8 = this.ibuffer_len + this.pad;
                }
                if (this.ibuffer_len < 0 && this.ibuffer_index >= (float)(n8 = this.pad2) || this.ibuffer_index < 0.0f) break;
                n5 = n7;
                for (n3 = 0; n3 < this.nrofchannels; ++n3) {
                    this.ix[0] = this.ibuffer_index;
                    this.ox[0] = n7;
                    fArray2 = this.ibuffer[n3];
                    this.resampler.interpolate(fArray2, this.ix, n8, this.pitch, 0.0f, this.cbuffer[n3], this.ox, n2 / this.nrofchannels);
                }
                this.ibuffer_index = this.ix[0];
                n7 = this.ox[0];
            }
            for (n5 = 0; n5 < this.nrofchannels; ++n5) {
                n3 = 0;
                fArray2 = this.cbuffer[n5];
                for (int i = n5 + n; i < n6; i += this.nrofchannels) {
                    fArray[i] = fArray2[n3++];
                }
            }
            return n2 - n4 * this.nrofchannels;
        }

        @Override
        public void reset() throws IOException {
            this.ais.reset();
            if (this.mark_ibuffer == null) {
                return;
            }
            this.ibuffer_index = this.mark_ibuffer_index;
            this.ibuffer_len = this.mark_ibuffer_len;
            for (int i = 0; i < this.ibuffer.length; ++i) {
                float[] fArray = this.mark_ibuffer[i];
                float[] fArray2 = this.ibuffer[i];
                for (int j = 0; j < fArray2.length; ++j) {
                    fArray2[j] = fArray[j];
                }
            }
        }

        @Override
        public long skip(long l) throws IOException {
            long l2;
            int n;
            if (l < 0L) {
                return 0L;
            }
            if (this.skipbuffer == null) {
                this.skipbuffer = new float[1024 * this.targetFormat.getFrameSize()];
            }
            float[] fArray = this.skipbuffer;
            for (l2 = l; l2 > 0L; l2 -= (long)n) {
                n = this.read(fArray, 0, (int)Math.min(l2, (long)this.skipbuffer.length));
                if (n >= 0) continue;
                if (l2 != l) break;
                return n;
            }
            return l - l2;
        }
    }

    private static class AudioFloatInputStreamChannelMixer
    extends AudioFloatInputStream {
        private final int targetChannels;
        private final int sourceChannels;
        private final AudioFloatInputStream ais;
        private final AudioFormat targetFormat;
        private float[] conversion_buffer;

        AudioFloatInputStreamChannelMixer(AudioFloatInputStream audioFloatInputStream, int n) {
            this.sourceChannels = audioFloatInputStream.getFormat().getChannels();
            this.targetChannels = n;
            this.ais = audioFloatInputStream;
            AudioFormat audioFormat = audioFloatInputStream.getFormat();
            this.targetFormat = new AudioFormat(audioFormat.getEncoding(), audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), n, audioFormat.getFrameSize() / this.sourceChannels * n, audioFormat.getFrameRate(), audioFormat.isBigEndian());
        }

        @Override
        public int available() throws IOException {
            return this.ais.available() / this.sourceChannels * this.targetChannels;
        }

        @Override
        public void close() throws IOException {
            this.ais.close();
        }

        @Override
        public AudioFormat getFormat() {
            return this.targetFormat;
        }

        @Override
        public long getFrameLength() {
            return this.ais.getFrameLength();
        }

        @Override
        public void mark(int n) {
            this.ais.mark(n / this.targetChannels * this.sourceChannels);
        }

        @Override
        public boolean markSupported() {
            return this.ais.markSupported();
        }

        @Override
        public int read(float[] fArray, int n, int n2) throws IOException {
            int n3;
            int n4 = n2 / this.targetChannels * this.sourceChannels;
            if (this.conversion_buffer == null || this.conversion_buffer.length < n4) {
                this.conversion_buffer = new float[n4];
            }
            if ((n3 = this.ais.read(this.conversion_buffer, 0, n4)) < 0) {
                return n3;
            }
            if (this.sourceChannels == 1) {
                int n5 = this.targetChannels;
                for (int i = 0; i < this.targetChannels; ++i) {
                    int n6 = 0;
                    int n7 = n + i;
                    while (n6 < n4) {
                        fArray[n7] = this.conversion_buffer[n6];
                        ++n6;
                        n7 += n5;
                    }
                }
            } else if (this.targetChannels == 1) {
                int n8;
                int n9 = this.sourceChannels;
                int n10 = 0;
                int n11 = n;
                while (n10 < n4) {
                    fArray[n11] = this.conversion_buffer[n10];
                    n10 += n9;
                    ++n11;
                }
                for (n10 = 1; n10 < this.sourceChannels; ++n10) {
                    n8 = n;
                    for (n11 = n10; n11 < n4; n11 += n9) {
                        int n12 = n8++;
                        fArray[n12] = fArray[n12] + this.conversion_buffer[n11];
                    }
                }
                float f = 1.0f / (float)this.sourceChannels;
                n8 = n;
                for (n11 = 0; n11 < n4; n11 += n9) {
                    int n13 = n8++;
                    fArray[n13] = fArray[n13] * f;
                }
            } else {
                int n14;
                int n15;
                int n16 = Math.min(this.sourceChannels, this.targetChannels);
                int n17 = n + n2;
                int n18 = this.targetChannels;
                int n19 = this.sourceChannels;
                for (n15 = 0; n15 < n16; ++n15) {
                    n14 = n + n15;
                    int n20 = n15;
                    while (n14 < n17) {
                        fArray[n14] = this.conversion_buffer[n20];
                        n14 += n18;
                        n20 += n19;
                    }
                }
                for (n15 = n16; n15 < this.targetChannels; ++n15) {
                    for (n14 = n + n15; n14 < n17; n14 += n18) {
                        fArray[n14] = 0.0f;
                    }
                }
            }
            return n3 / this.sourceChannels * this.targetChannels;
        }

        @Override
        public void reset() throws IOException {
            this.ais.reset();
        }

        @Override
        public long skip(long l) throws IOException {
            long l2 = this.ais.skip(l / (long)this.targetChannels * (long)this.sourceChannels);
            if (l2 < 0L) {
                return l2;
            }
            return l2 / (long)this.sourceChannels * (long)this.targetChannels;
        }
    }

    private static class AudioFloatFormatConverterInputStream
    extends InputStream {
        private final AudioFloatConverter converter;
        private final AudioFloatInputStream stream;
        private float[] readfloatbuffer;
        private final int fsize;

        AudioFloatFormatConverterInputStream(AudioFormat audioFormat, AudioFloatInputStream audioFloatInputStream) {
            this.stream = audioFloatInputStream;
            this.converter = AudioFloatConverter.getConverter(audioFormat);
            this.fsize = (audioFormat.getSampleSizeInBits() + 7) / 8;
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray);
            if (n < 0) {
                return n;
            }
            return byArray[0] & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            int n4 = n2 / this.fsize;
            if (this.readfloatbuffer == null || this.readfloatbuffer.length < n4) {
                this.readfloatbuffer = new float[n4];
            }
            if ((n3 = this.stream.read(this.readfloatbuffer, 0, n4)) < 0) {
                return n3;
            }
            this.converter.toByteArray(this.readfloatbuffer, 0, n3, byArray, n);
            return n3 * this.fsize;
        }

        @Override
        public int available() throws IOException {
            int n = this.stream.available();
            if (n < 0) {
                return n;
            }
            return n * this.fsize;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        @Override
        public synchronized void mark(int n) {
            this.stream.mark(n * this.fsize);
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }

        @Override
        public synchronized void reset() throws IOException {
            this.stream.reset();
        }

        @Override
        public long skip(long l) throws IOException {
            long l2 = this.stream.skip(l / (long)this.fsize);
            if (l2 < 0L) {
                return l2;
            }
            return l2 * (long)this.fsize;
        }
    }
}

