/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.juife.EnhancedDialog;
import net.sf.juife.JuifeUtils;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.CC;
import org.jsampler.JSPrefs;
import org.jsampler.event.ParameterEvent;
import org.jsampler.event.ParameterListener;
import org.jsampler.task.Audio;
import org.jsampler.view.ParameterTable;
import org.jsampler.view.std.StdI18n;
import org.linuxsampler.lscp.AudioOutputDriver;
import org.linuxsampler.lscp.Parameter;

public class JSNewAudioDeviceDlg
extends EnhancedDialog {
    private final Pane mainPane = new Pane();

    public JSNewAudioDeviceDlg(Frame frame) {
        super(frame, StdI18n.i18n.getLabel("JSNewAudioDeviceDlg.title"));
        this.initNewAudioDeviceDlg();
    }

    public JSNewAudioDeviceDlg(Dialog dialog) {
        super(dialog, StdI18n.i18n.getLabel("JSNewAudioDeviceDlg.title"));
        this.initNewAudioDeviceDlg();
    }

    private void initNewAudioDeviceDlg() {
        this.mainPane.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.mainPane.setPreferredSize(JuifeUtils.getUnionSize(this.mainPane.getMinimumSize(), new Dimension(250, 230)));
        this.add(this.mainPane);
        this.pack();
        this.setLocation(JuifeUtils.centerLocation(this, this.getOwner()));
        this.mainPane.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSNewAudioDeviceDlg.this.onCancel();
            }
        });
        this.mainPane.btnCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSNewAudioDeviceDlg.this.onOk();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                ((JSNewAudioDeviceDlg)JSNewAudioDeviceDlg.this).mainPane.btnCreate.requestFocusInWindow();
            }
        });
    }

    @Override
    protected void onOk() {
        AudioOutputDriver audioOutputDriver = this.mainPane.getSelectedDriver();
        if (audioOutputDriver == null) {
            JOptionPane.showMessageDialog(this, StdI18n.i18n.getMessage("JSNewAudioDeviceDlg.selectDriver!"), "", 1);
            return;
        }
        this.mainPane.btnCreate.setEnabled(false);
        Audio.CreateDevice createDevice = new Audio.CreateDevice(audioOutputDriver.getName(), this.mainPane.getParameters());
        createDevice.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                ((JSNewAudioDeviceDlg)JSNewAudioDeviceDlg.this).mainPane.btnCreate.setEnabled(true);
                JSNewAudioDeviceDlg.this.setVisible(false);
            }
        });
        CC.getTaskQueue().add(createDevice);
    }

    @Override
    protected void onCancel() {
        this.setVisible(false);
    }

    private static JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    public static class Pane
    extends JPanel {
        private final JLabel lDriver = new JLabel(StdI18n.i18n.getLabel("JSNewAudioDeviceDlg.lDriver"));
        private final JComboBox cbDrivers = new JComboBox();
        private final ParameterTable parameterTable = new ParameterTable();
        public final JButton btnCreate = new JButton(StdI18n.i18n.getButtonLabel("JSNewAudioDeviceDlg.btnCreate"));
        public final JButton btnCancel = new JButton(StdI18n.i18n.getButtonLabel("cancel"));

        public Pane() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(this.lDriver);
            this.parameterTable.getModel().setEditFixedParameters(true);
            this.parameterTable.setFillsViewportHeight(true);
            this.parameterTable.getModel().addParameterListener(new ParameterListener(){

                @Override
                public void parameterChanged(ParameterEvent parameterEvent) {
                    this.updateParameters();
                }
            });
            this.cbDrivers.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AudioOutputDriver audioOutputDriver = (AudioOutputDriver)cbDrivers.getSelectedItem();
                    if (audioOutputDriver == null) {
                        return;
                    }
                    cbDrivers.setToolTipText(audioOutputDriver.getDescription());
                    parameterTable.getModel().setParameters(audioOutputDriver.getParameters());
                    this.updateParameters();
                }
            });
            for (AudioOutputDriver audioOutputDriver : CC.getSamplerModel().getAudioOutputDrivers()) {
                this.cbDrivers.addItem(audioOutputDriver);
            }
            String string = JSNewAudioDeviceDlg.preferences().getStringProperty("defaultAudioDriver");
            for (AudioOutputDriver audioOutputDriver : CC.getSamplerModel().getAudioOutputDrivers()) {
                if (!audioOutputDriver.getName().equals(string)) continue;
                this.cbDrivers.setSelectedItem(audioOutputDriver);
                break;
            }
            this.cbDrivers.setMaximumSize(this.cbDrivers.getPreferredSize());
            jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
            jPanel2.add(this.cbDrivers);
            jPanel2.setAlignmentX(0.0f);
            jPanel.add(jPanel2);
            jPanel.add(Box.createRigidArea(new Dimension(0, 12)));
            JScrollPane jScrollPane = new JScrollPane(this.parameterTable);
            jScrollPane.setAlignmentX(0.0f);
            jPanel.add(jScrollPane);
            this.add(jPanel);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.add(Box.createGlue());
            jPanel3.add(this.btnCreate);
            jPanel3.add(Box.createRigidArea(new Dimension(5, 0)));
            jPanel3.add(this.btnCancel);
            jPanel3.setBorder(BorderFactory.createEmptyBorder(17, 0, 0, 0));
            this.add((Component)jPanel3, "South");
        }

        public Parameter[] getParameters() {
            if (this.parameterTable.getCellEditor() != null) {
                this.parameterTable.getCellEditor().stopCellEditing();
            }
            return this.parameterTable.getModel().getParameters();
        }

        public AudioOutputDriver getSelectedDriver() {
            return (AudioOutputDriver)this.cbDrivers.getSelectedItem();
        }

        private void updateParameters() {
            AudioOutputDriver audioOutputDriver = (AudioOutputDriver)this.cbDrivers.getSelectedItem();
            if (audioOutputDriver == null) {
                return;
            }
            final Parameter[] parameterArray = this.parameterTable.getModel().getParameters();
            final Audio.GetDriverParametersInfo getDriverParametersInfo = new Audio.GetDriverParametersInfo(audioOutputDriver.getName(), parameterArray);
            getDriverParametersInfo.addTaskListener(new TaskListener(){

                @Override
                public void taskPerformed(TaskEvent taskEvent) {
                    if (getDriverParametersInfo.doneWithErrors()) {
                        return;
                    }
                    block0: for (Parameter parameter : parameterArray) {
                        for (Parameter parameter2 : (Parameter[])getDriverParametersInfo.getResult()) {
                            if (!parameter2.getName().equals(parameter.getName())) continue;
                            parameter2.setValue(parameter.getValue());
                            if (parameter2.getValue() != null) continue block0;
                            parameter2.setValue(parameter2.getDefault());
                            continue block0;
                        }
                    }
                    parameterTable.getModel().setParameters((Parameter[])getDriverParametersInfo.getResult());
                }
            });
            CC.getTaskQueue().add(getDriverParametersInfo);
        }
    }
}

