/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import org.linuxsampler.lscp.AbstractParameter;
import org.linuxsampler.lscp.LscpException;
import org.linuxsampler.lscp.ParameterType;
import org.linuxsampler.lscp.Parser;

public class BoolParameter
extends AbstractParameter<Boolean> {
    public BoolParameter() {
        this.setType(ParameterType.BOOL);
        this.setMultiplicity(false);
    }

    public BoolParameter(String string) {
        this(string, null);
    }

    public BoolParameter(String string, Boolean bl) {
        this();
        this.setName(string);
        this.setValue(bl);
    }

    public BoolParameter(String[] stringArray) throws LscpException {
        this();
        this.parseLines(stringArray);
    }

    @Override
    public boolean parse(String string) throws LscpException {
        if (super.parse(string)) {
            return true;
        }
        if (string.startsWith("DEFAULT: ")) {
            string = string.substring("DEFAULT: ".length(), string.length());
            this.setDefault(Boolean.parseBoolean(string));
            return true;
        }
        if (string.startsWith("POSSIBILITIES: ")) {
            string = string.substring("POSSIBILITIES: ".length(), string.length());
            this.setPossibilities(Parser.parseBoolList(string));
            return true;
        }
        return false;
    }

    @Override
    public void parseValue(String string) {
        this.setValue(Boolean.parseBoolean(string));
    }

    @Override
    public String getStringValue() {
        return String.valueOf(this.getValue());
    }
}

