/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Objects;
import org.apache.kafka.streams.processor.RecordContext;
import org.apache.kafka.streams.processor.TopicNameExtractor;

public class StaticTopicNameExtractor<K, V>
implements TopicNameExtractor<K, V> {
    public final String topicName;

    public StaticTopicNameExtractor(String topic) {
        Objects.requireNonNull(topic, "topic cannot be null");
        this.topicName = topic;
    }

    @Override
    public String extract(K key, V value, RecordContext recordContext) {
        return this.topicName;
    }

    public String toString() {
        return "StaticTopicNameExtractor(" + this.topicName + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaticTopicNameExtractor that = (StaticTopicNameExtractor)o;
        return Objects.equals(this.topicName, that.topicName);
    }

    public int hashCode() {
        return Objects.hash(this.topicName);
    }
}

