/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.persister;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.DeleteShareGroupStateResponseData;
import org.apache.kafka.server.share.persister.PartitionErrorData;
import org.apache.kafka.server.share.persister.PartitionFactory;
import org.apache.kafka.server.share.persister.PersisterResult;
import org.apache.kafka.server.share.persister.TopicData;

public class DeleteShareGroupStateResult
implements PersisterResult {
    private final List<TopicData<PartitionErrorData>> topicsData;
    public static final DeleteShareGroupStateResult EMPTY_RESULT = new Builder().setTopicsData(List.of()).build();

    private DeleteShareGroupStateResult(List<TopicData<PartitionErrorData>> topicsData) {
        this.topicsData = topicsData;
    }

    public List<TopicData<PartitionErrorData>> topicsData() {
        return this.topicsData;
    }

    public static DeleteShareGroupStateResult from(DeleteShareGroupStateResponseData data) {
        return new Builder().setTopicsData(data.results().stream().map(deleteStateResult -> new TopicData(deleteStateResult.topicId(), deleteStateResult.partitions().stream().map(partitionResult -> PartitionFactory.newPartitionErrorData(partitionResult.partition(), partitionResult.errorCode(), partitionResult.errorMessage())).collect(Collectors.toList()))).collect(Collectors.toList())).build();
    }

    public static class Builder {
        private List<TopicData<PartitionErrorData>> topicsData;

        public Builder setTopicsData(List<TopicData<PartitionErrorData>> topicsData) {
            this.topicsData = topicsData;
            return this;
        }

        public DeleteShareGroupStateResult build() {
            return new DeleteShareGroupStateResult(this.topicsData);
        }
    }
}

