/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.infinispan.health.impl;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.util.concurrent.BlockingManager;
import org.jboss.logging.Logger;
import org.keycloak.infinispan.health.ClusterHealth;
import org.keycloak.jgroups.protocol.KEYCLOAK_JDBC_PING2;

@Scope(value=Scopes.GLOBAL)
public class JdbcPingClusterHealthImpl
implements ClusterHealth {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private final ReentrantLock lock = new ReentrantLock();
    private volatile boolean healthy = true;
    private volatile HealthRunner runner;

    @Inject
    public void inject(Transport transport, BlockingManager blockingManager) {
        if (transport == null) {
            logger.debug((Object)"Cluster health check disabled. Local mode");
            return;
        }
        if (!(transport instanceof JGroupsTransport)) {
            logger.debug((Object)"JGroups Transport not found. Unable to check cluster health.");
            return;
        }
        JGroupsTransport jgrp = (JGroupsTransport)transport;
        KEYCLOAK_JDBC_PING2 ping = (KEYCLOAK_JDBC_PING2)jgrp.getChannel().getProtocolStack().findProtocol(KEYCLOAK_JDBC_PING2.class);
        if (ping == null) {
            logger.warn((Object)"Stack 'jdbc-ping' not used. Unable to check cluster health.");
            return;
        }
        logger.debug((Object)"Cluster Health check available");
        this.init(ping, blockingManager.asExecutor("cluster-health"));
    }

    public void init(KEYCLOAK_JDBC_PING2 discovery, Executor executor) {
        this.runner = new HealthRunner(discovery, executor, this::checkHealth);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkHealth(KEYCLOAK_JDBC_PING2 ping) {
        assert (ping != null);
        if (!this.lock.tryLock()) {
            return;
        }
        try {
            KEYCLOAK_JDBC_PING2.HealthStatus status = ping.healthStatus();
            switch (status) {
                case HEALTHY: {
                    logger.debug((Object)"Set cluster health status to healthy");
                    this.healthy = true;
                    return;
                }
                case NO_COORDINATOR: {
                    logger.warn((Object)"Unable to check the cluster health because no coordinator has been found.");
                }
                case UNHEALTHY: {
                    logger.debug((Object)"Set cluster health status to unhealthy");
                    this.healthy = false;
                    return;
                }
                case ERROR: {
                    logger.debug((Object)"Error querying the database. Skip updating the cluster health status.");
                    return;
                }
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isHealthy() {
        return this.healthy;
    }

    @Override
    public void triggerClusterHealthCheck() {
        if (this.runner != null) {
            this.runner.trigger();
        }
    }

    @Override
    public boolean isSupported() {
        return this.runner != null;
    }

    private record HealthRunner(KEYCLOAK_JDBC_PING2 discovery, Executor executor, Consumer<KEYCLOAK_JDBC_PING2> check) {
        HealthRunner {
            Objects.requireNonNull(discovery);
            Objects.requireNonNull(executor);
            Objects.requireNonNull(check);
        }

        void trigger() {
            this.executor.execute(() -> this.check.accept(this.discovery));
        }
    }
}

