/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.InvalidNameException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.ldap.LdapContext;
import javax.net.ssl.SSLHandshakeException;
import org.jboss.logging.Logger;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.LDAPCapabilityRepresentation;
import org.keycloak.representations.idm.TestLdapConnectionRepresentation;
import org.keycloak.services.ServicesLogger;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPContextManager;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPIdentityStore;
import org.keycloak.storage.ldap.mappers.membership.group.GroupTreeResolver;
import org.keycloak.utils.StringUtil;

public class LDAPServerCapabilitiesManager {
    private static final Logger logger = Logger.getLogger(LDAPServerCapabilitiesManager.class);
    public static final String TEST_CONNECTION = "testConnection";
    public static final String TEST_AUTHENTICATION = "testAuthentication";
    public static final String QUERY_SERVER_CAPABILITIES = "queryServerCapabilities";
    public static final int DEFAULT_TEST_TIMEOUT = 30000;

    private static int parseConnectionTimeout(String connectionTimeout) {
        if (StringUtil.isNotBlank((String)connectionTimeout)) {
            try {
                int timeout = Integer.parseInt(connectionTimeout);
                if (timeout > 0) {
                    return timeout;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 30000;
    }

    public static LDAPConfig buildLDAPConfig(TestLdapConnectionRepresentation config, RealmModel realm) {
        LDAPConfig ldapConfig;
        ComponentModel component;
        String bindCredential = config.getBindCredential();
        if (config.getComponentId() != null && !"none".equals(config.getAuthType()) && "**********".equals(bindCredential) && (component = realm.getComponent(config.getComponentId())) != null && LDAPServerCapabilitiesManager.checkLdapConnectionUrl(config, ldapConfig = new LDAPConfig((MultivaluedHashMap<String, String>)component.getConfig())) && config.getBindDn() != null && config.getBindDn().equalsIgnoreCase(ldapConfig.getBindDN())) {
            bindCredential = ldapConfig.getBindCredential();
        }
        MultivaluedHashMap configMap = new MultivaluedHashMap();
        configMap.putSingle((Object)"authType", (Object)config.getAuthType());
        configMap.putSingle((Object)"bindDn", (Object)config.getBindDn());
        configMap.putSingle((Object)"bindCredential", (Object)bindCredential);
        configMap.add((Object)"connectionUrl", (Object)config.getConnectionUrl());
        configMap.add((Object)"useTruststoreSpi", (Object)config.getUseTruststoreSpi());
        String timeoutStr = Integer.toString(LDAPServerCapabilitiesManager.parseConnectionTimeout(config.getConnectionTimeout()));
        configMap.putSingle((Object)"connectionTimeout", (Object)timeoutStr);
        configMap.putSingle((Object)"readTimeout", (Object)timeoutStr);
        configMap.add((Object)"startTls", (Object)config.getStartTls());
        return new LDAPConfig((MultivaluedHashMap<String, String>)configMap);
    }

    private static boolean checkLdapConnectionUrl(TestLdapConnectionRepresentation config, LDAPConfig ldapConfig) {
        String[] ldapConfigConnectionUrls;
        String[] configConnectionUrls = config.getConnectionUrl().trim().split(" ");
        if (configConnectionUrls.length != (ldapConfigConnectionUrls = ldapConfig.getConnectionUrl().trim().split(" ")).length) {
            return false;
        }
        boolean urlsMatch = true;
        for (int i = 0; i < configConnectionUrls.length && urlsMatch; ++i) {
            urlsMatch = Objects.equals(URI.create(configConnectionUrls[i]), URI.create(ldapConfigConnectionUrls[i]));
        }
        return urlsMatch;
    }

    public static Set<LDAPCapabilityRepresentation> queryServerCapabilities(TestLdapConnectionRepresentation config, KeycloakSession session, RealmModel realm) {
        if (!QUERY_SERVER_CAPABILITIES.equals(config.getAction())) {
            ServicesLogger.LOGGER.unknownAction(config.getAction());
            return Collections.emptySet();
        }
        LDAPConfig ldapConfig = LDAPServerCapabilitiesManager.buildLDAPConfig(config, realm);
        return new LDAPIdentityStore(session, ldapConfig).queryServerCapabilities();
    }

    public static String getErrorCode(Throwable throwable) {
        String errorMsg = "UnknownError";
        if (throwable instanceof NamingException) {
            errorMsg = "NamingError";
        }
        if (throwable instanceof AuthenticationException) {
            errorMsg = "AuthenticationFailure";
        }
        if (throwable instanceof CommunicationException) {
            errorMsg = "CommunicationError";
        }
        if (throwable instanceof ServiceUnavailableException) {
            errorMsg = "ServiceUnavailable";
        }
        if (throwable instanceof InvalidNameException) {
            errorMsg = "InvalidName";
        }
        if (throwable instanceof ServiceUnavailableException) {
            errorMsg = "ServiceUnavailable";
        }
        if (throwable instanceof InvalidBindDNException) {
            errorMsg = "InvalidBindDN";
        }
        if (throwable instanceof NameNotFoundException) {
            errorMsg = "NameNotFound";
        }
        if (throwable instanceof GroupTreeResolver.GroupTreeResolveException) {
            errorMsg = "GroupsMultipleParents";
        }
        if (throwable instanceof NamingException) {
            Throwable rootCause = ((NamingException)throwable).getRootCause();
            if (rootCause instanceof MalformedURLException) {
                errorMsg = "MalformedURL";
            }
            if (rootCause instanceof NoRouteToHostException) {
                errorMsg = "NoRouteToHost";
            }
            if (rootCause instanceof ConnectException) {
                errorMsg = "ConnectionFailed";
            }
            if (rootCause instanceof UnknownHostException) {
                errorMsg = "UnknownHost";
            }
            if (rootCause instanceof SSLHandshakeException) {
                errorMsg = "SSLHandshakeFailed";
            }
            if (rootCause instanceof SocketException) {
                errorMsg = "SocketReset";
            }
        }
        return errorMsg;
    }

    public static void testLDAP(TestLdapConnectionRepresentation config, KeycloakSession session, RealmModel realm) throws NamingException {
        if (!TEST_CONNECTION.equals(config.getAction()) && !TEST_AUTHENTICATION.equals(config.getAction())) {
            ServicesLogger.LOGGER.unknownAction(config.getAction());
            throw new NamingException("testLDAP unknown action");
        }
        if (TEST_AUTHENTICATION.equals(config.getAction())) {
            if ((config.getBindDn() == null || config.getBindDn().isEmpty()) && "simple".equals(config.getAuthType())) {
                throw new InvalidBindDNException("Unknown bind DN");
            }
        } else {
            config.setAuthType("none");
        }
        LDAPConfig ldapConfig = LDAPServerCapabilitiesManager.buildLDAPConfig(config, realm);
        try (LDAPContextManager ldapContextManager = LDAPContextManager.create(session, ldapConfig);){
            LdapContext ldapContext = ldapContextManager.getLdapContext();
            if (TEST_AUTHENTICATION.equals(config.getAction()) && "none".equals(config.getAuthType())) {
                ldapContext.reconnect(null);
            }
        }
        catch (Exception ne) {
            String errorMessage = TEST_AUTHENTICATION.equals(config.getAction()) ? "Error when authenticating to LDAP: " : "Error when connecting to LDAP: ";
            ServicesLogger.LOGGER.errorAuthenticating(ne, errorMessage + ne.getMessage());
            throw ne;
        }
    }

    public static class InvalidBindDNException
    extends NamingException {
        public InvalidBindDNException(String s) {
            super(s);
        }
    }
}

