/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.DispatchDescriptor;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStatusListener;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lib.uno.helper.Factory;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.URL;
import com.sun.star.wiki.Helper;
import com.sun.star.wiki.Settings;
import com.sun.star.wiki.WikiArticle;
import com.sun.star.wiki.WikiCancelException;
import com.sun.star.wiki.WikiDialog;
import com.sun.star.wiki.WikiOptionsEventHandlerImpl;
import com.sun.star.wiki.WikiPropDialog;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLException;

public final class WikiEditorImpl
extends WeakBase
implements XServiceInfo,
XDispatchProvider,
XDispatch,
XInitialization {
    private static final String m_implementationName = WikiEditorImpl.class.getName();
    private static final String[] m_serviceNames = new String[]{"com.sun.star.wiki.WikiEditor"};
    private static final String protocolName = "vnd.com.sun.star.wiki:";
    private final XComponentContext m_xContext;
    private XFrame m_xFrame;
    private XModel m_xModel;
    private final Settings m_aSettings;
    private String m_aFilterName;

    public WikiEditorImpl(XComponentContext xComponentContext) {
        this.m_xContext = xComponentContext;
        this.m_aSettings = Settings.getSettings(this.m_xContext);
    }

    public static XSingleComponentFactory __getComponentFactory(String string) {
        XSingleComponentFactory xSingleComponentFactory = null;
        if (string.equals(m_implementationName)) {
            xSingleComponentFactory = Factory.createComponentFactory(WikiEditorImpl.class, (String[])m_serviceNames);
        } else if (string.equals(WikiOptionsEventHandlerImpl.m_sImplementationName)) {
            xSingleComponentFactory = Factory.createComponentFactory(WikiOptionsEventHandlerImpl.class, (String[])WikiOptionsEventHandlerImpl.m_pServiceNames);
        }
        return xSingleComponentFactory;
    }

    public String getImplementationName() {
        return m_implementationName;
    }

    public boolean supportsService(String string) {
        int n = m_serviceNames.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(m_serviceNames[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedServiceNames() {
        return m_serviceNames;
    }

    public synchronized void initialize(Object[] objectArray) throws com.sun.star.uno.Exception {
        if (objectArray.length > 0) {
            this.m_xFrame = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)objectArray[0]);
        }
    }

    public void dispatch(URL uRL, PropertyValue[] propertyValueArray) {
        URL uRL2 = uRL;
        if (uRL.Protocol.equals(protocolName)) {
            try {
                if (uRL2.Path.equals("send")) {
                    this.sendArticle();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public XDispatch queryDispatch(URL uRL, String string, int n) {
        if (uRL.Protocol.equals(protocolName)) {
            return this;
        }
        return null;
    }

    public XDispatch[] queryDispatches(DispatchDescriptor[] dispatchDescriptorArray) {
        int n = dispatchDescriptorArray.length;
        XDispatch[] xDispatchArray = new XDispatch[n];
        for (int i = 0; i < n; ++i) {
            xDispatchArray[i] = this.queryDispatch(dispatchDescriptorArray[i].FeatureURL, dispatchDescriptorArray[i].FrameName, dispatchDescriptorArray[i].SearchFlags);
        }
        return xDispatchArray;
    }

    public void removeStatusListener(XStatusListener xStatusListener, URL uRL) {
    }

    public void addStatusListener(XStatusListener xStatusListener, URL uRL) {
    }

    private void sendArticle() {
        if (this.m_xFrame != null) {
            WikiDialog wikiDialog = null;
            try {
                Object object;
                if (this.m_xModel == null && (object = this.m_xFrame.getController()) != null) {
                    this.m_xModel = object.getModel();
                }
                if (this.m_xModel != null) {
                    object = Helper.GetDocServiceName(this.m_xContext, this.m_xModel);
                    this.m_aFilterName = Helper.GetFilterName(this.m_xContext, "MediaWiki", (String)object);
                    if (this.m_aFilterName == null || this.m_aFilterName.length() == 0) {
                        Helper.ShowError(this.m_xContext, (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.m_xFrame.getContainerWindow()), 6, 1, null, false);
                        throw new RuntimeException();
                    }
                    this.m_aSettings.loadConfiguration();
                    wikiDialog = new WikiPropDialog(this.m_xContext, "vnd.sun.star.script:WikiEditor.SendToMediaWiki?location=application", this);
                    ((WikiPropDialog)wikiDialog).fillWikiList();
                    ((WikiPropDialog)wikiDialog).SetWikiTitle(Helper.GetDocTitle(this.m_xModel));
                    ((WikiPropDialog)wikiDialog).show();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (wikiDialog != null) {
                    wikiDialog.DisposeDialog();
                }
            }
        }
    }

    public boolean SendArticleImpl(WikiPropDialog wikiPropDialog, Map<String, String> map) {
        boolean bl = false;
        if (wikiPropDialog != null) {
            Object object;
            String string = null;
            try {
                object = new WikiArticle(this.m_xContext, wikiPropDialog.GetWikiTitle(), map, true, wikiPropDialog);
                boolean bl2 = true;
                if (!((WikiArticle)object).NotExist()) {
                    wikiPropDialog.SetThrobberActive(false);
                    bl2 = Helper.ShowError(this.m_xContext, (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.m_xFrame.getContainerWindow()), 6, 32, wikiPropDialog.GetWikiTitle(), true);
                    wikiPropDialog.SetThrobberActive(true);
                }
                if (bl2) {
                    PropertyValue[] propertyValueArray = new PropertyValue[2];
                    propertyValueArray[0] = new PropertyValue();
                    propertyValueArray[0].Name = "FilterName";
                    propertyValueArray[0].Value = this.m_aFilterName;
                    propertyValueArray[1] = new PropertyValue();
                    propertyValueArray[1].Name = "Overwrite";
                    propertyValueArray[1].Value = Boolean.TRUE;
                    string = Helper.CreateTempFile(this.m_xContext);
                    XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.m_xModel);
                    if (xStorable == null) {
                        throw new RuntimeException();
                    }
                    xStorable.storeToURL(string, propertyValueArray);
                    String string2 = Helper.EachLine(string);
                    if (((WikiArticle)object).setArticle(string2, wikiPropDialog.m_sWikiComment, wikiPropDialog.m_bWikiMinorEdit)) {
                        bl = true;
                        Helper.SetDocTitle(this.m_xModel, ((WikiArticle)object).GetTitle());
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        hashMap.put("Doc", ((WikiArticle)object).GetTitle());
                        hashMap.put("Url", ((WikiArticle)object).GetMainURL());
                        hashMap.put("CompleteUrl", ((WikiArticle)object).GetMainURL() + ((WikiArticle)object).GetTitle());
                        this.m_aSettings.addWikiDoc(hashMap);
                        this.m_aSettings.storeConfiguration();
                    } else {
                        Helper.ShowError(this.m_xContext, (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.m_xFrame.getContainerWindow()), 6, 0, null, false);
                    }
                }
            }
            catch (WikiCancelException wikiCancelException) {
            }
            catch (SSLException sSLException) {
                if (Helper.IsConnectionAllowed()) {
                    Helper.ShowError(this.m_xContext, (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.m_xFrame.getContainerWindow()), 6, 25, null, false);
                }
            }
            catch (Exception exception) {
                if (Helper.IsConnectionAllowed()) {
                    Helper.ShowError(this.m_xContext, (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.m_xFrame.getContainerWindow()), 6, 0, null, false);
                }
                exception.printStackTrace();
            }
            if (string != null) {
                try {
                    object = new File(new URI(string));
                    if (!((File)object).delete()) {
                        throw new Exception("could not remove" + string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return bl;
    }
}

