/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.document.bulk;

import java.util.List;
import java.util.Objects;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.index.VersionType;
import org.opensearch.protobufs.BulkRequest;
import org.opensearch.protobufs.BulkRequestBody;
import org.opensearch.protobufs.DeleteOperation;
import org.opensearch.protobufs.IndexOperation;
import org.opensearch.protobufs.OpType;
import org.opensearch.protobufs.OperationContainer;
import org.opensearch.protobufs.UpdateAction;
import org.opensearch.protobufs.UpdateOperation;
import org.opensearch.protobufs.WriteOperation;
import org.opensearch.script.Script;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.transport.grpc.proto.request.common.FetchSourceContextProtoUtils;
import org.opensearch.transport.grpc.proto.request.common.ScriptProtoUtils;
import org.opensearch.transport.grpc.proto.response.document.common.VersionTypeProtoUtils;

public class BulkRequestParserProtoUtils {
    protected BulkRequestParserProtoUtils() {
    }

    private static String valueOrDefault(String value, String globalDefault) {
        if (Strings.isNullOrEmpty((String)value) && !Strings.isNullOrEmpty((String)globalDefault)) {
            return globalDefault;
        }
        return value;
    }

    private static Boolean valueOrDefault(Boolean value, Boolean globalDefault) {
        if (Objects.isNull(value) && !Objects.isNull(globalDefault)) {
            return globalDefault;
        }
        return value;
    }

    public static DocWriteRequest<?>[] getDocWriteRequests(BulkRequest request, String defaultIndex, String defaultRouting, FetchSourceContext defaultFetchSourceContext, String defaultPipeline, Boolean defaultRequireAlias) {
        List bulkRequestBodyList = request.getRequestBodyList();
        DocWriteRequest[] docWriteRequests = new DocWriteRequest[bulkRequestBodyList.size()];
        for (int i = 0; i < bulkRequestBodyList.size(); ++i) {
            BulkRequestBody bulkRequestBodyEntry = (BulkRequestBody)bulkRequestBodyList.get(i);
            String index = defaultIndex;
            String id = null;
            String routing = BulkRequestParserProtoUtils.valueOrDefault(defaultRouting, request.getRouting());
            FetchSourceContext fetchSourceContext = defaultFetchSourceContext;
            OpType opType = null;
            long version = -3L;
            VersionType versionType = VersionType.INTERNAL;
            long ifSeqNo = -2L;
            long ifPrimaryTerm = 0L;
            int retryOnConflict = 0;
            String pipeline = BulkRequestParserProtoUtils.valueOrDefault(defaultPipeline, request.getPipeline());
            Boolean requireAlias = BulkRequestParserProtoUtils.valueOrDefault(defaultRequireAlias, request.getRequireAlias());
            OperationContainer operationContainer = bulkRequestBodyEntry.getOperationContainer();
            docWriteRequests[i] = switch (operationContainer.getOperationContainerCase()) {
                case OperationContainer.OperationContainerCase.CREATE -> BulkRequestParserProtoUtils.buildCreateRequest(operationContainer.getCreate(), bulkRequestBodyEntry.getObject().toByteArray(), index, id, routing, version, versionType, pipeline, ifSeqNo, ifPrimaryTerm, requireAlias);
                case OperationContainer.OperationContainerCase.INDEX -> BulkRequestParserProtoUtils.buildIndexRequest(operationContainer.getIndex(), bulkRequestBodyEntry.getObject().toByteArray(), opType, index, id, routing, version, versionType, pipeline, ifSeqNo, ifPrimaryTerm, requireAlias);
                case OperationContainer.OperationContainerCase.UPDATE -> BulkRequestParserProtoUtils.buildUpdateRequest(operationContainer.getUpdate(), bulkRequestBodyEntry.getObject().toByteArray(), bulkRequestBodyEntry, index, id, routing, fetchSourceContext, retryOnConflict, pipeline, ifSeqNo, ifPrimaryTerm, requireAlias);
                case OperationContainer.OperationContainerCase.DELETE -> BulkRequestParserProtoUtils.buildDeleteRequest(operationContainer.getDelete(), index, id, routing, version, versionType, ifSeqNo, ifPrimaryTerm);
                default -> throw new IllegalArgumentException("Invalid BulkRequestBody. An OperationContainer (create, index, update, or delete) must be provided.");
            };
        }
        return docWriteRequests;
    }

    public static IndexRequest buildCreateRequest(WriteOperation createOperation, byte[] document, String index, String id, String routing, long version, VersionType versionType, String pipeline, long ifSeqNo, long ifPrimaryTerm, boolean requireAlias) {
        index = createOperation.hasXIndex() ? createOperation.getXIndex() : index;
        id = createOperation.hasXId() ? createOperation.getXId() : id;
        routing = createOperation.hasRouting() ? createOperation.getRouting() : routing;
        pipeline = createOperation.hasPipeline() ? createOperation.getPipeline() : pipeline;
        requireAlias = createOperation.hasRequireAlias() ? createOperation.getRequireAlias() : requireAlias;
        IndexRequest indexRequest = new IndexRequest(index).id(id).routing(routing).version(version).versionType(versionType).create(true).setPipeline(pipeline).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).source(document, MediaTypeRegistry.JSON).setRequireAlias(requireAlias);
        return indexRequest;
    }

    public static IndexRequest buildIndexRequest(IndexOperation indexOperation, byte[] document, OpType opType, String index, String id, String routing, long version, VersionType versionType, String pipeline, long ifSeqNo, long ifPrimaryTerm, boolean requireAlias) {
        opType = indexOperation.hasOpType() ? indexOperation.getOpType() : opType;
        index = indexOperation.hasXIndex() ? indexOperation.getXIndex() : index;
        id = indexOperation.hasXId() ? indexOperation.getXId() : id;
        routing = indexOperation.hasRouting() ? indexOperation.getRouting() : routing;
        long l = version = indexOperation.hasVersion() ? indexOperation.getVersion() : version;
        if (indexOperation.hasVersionType()) {
            versionType = VersionTypeProtoUtils.fromProto(indexOperation.getVersionType());
        }
        pipeline = indexOperation.hasPipeline() ? indexOperation.getPipeline() : pipeline;
        ifSeqNo = indexOperation.hasIfSeqNo() ? indexOperation.getIfSeqNo() : ifSeqNo;
        ifPrimaryTerm = indexOperation.hasIfPrimaryTerm() ? indexOperation.getIfPrimaryTerm() : ifPrimaryTerm;
        boolean bl = requireAlias = indexOperation.hasRequireAlias() ? indexOperation.getRequireAlias() : requireAlias;
        IndexRequest indexRequest = opType == null ? new IndexRequest(index).id(id).routing(routing).version(version).versionType(versionType).setPipeline(pipeline).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).source(document, MediaTypeRegistry.JSON).setRequireAlias(requireAlias) : new IndexRequest(index).id(id).routing(routing).version(version).versionType(versionType).create(opType == OpType.OP_TYPE_CREATE).setPipeline(pipeline).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).source(document, MediaTypeRegistry.JSON).setRequireAlias(requireAlias);
        return indexRequest;
    }

    public static UpdateRequest buildUpdateRequest(UpdateOperation updateOperation, byte[] document, BulkRequestBody bulkRequestBody, String index, String id, String routing, FetchSourceContext fetchSourceContext, int retryOnConflict, String pipeline, long ifSeqNo, long ifPrimaryTerm, boolean requireAlias) {
        index = updateOperation.hasXIndex() ? updateOperation.getXIndex() : index;
        id = updateOperation.hasXId() ? updateOperation.getXId() : id;
        routing = updateOperation.hasRouting() ? updateOperation.getRouting() : routing;
        fetchSourceContext = bulkRequestBody.hasUpdateAction() && bulkRequestBody.getUpdateAction().hasXSource() ? FetchSourceContextProtoUtils.fromProto(bulkRequestBody.getUpdateAction().getXSource()) : fetchSourceContext;
        retryOnConflict = updateOperation.hasRetryOnConflict() ? updateOperation.getRetryOnConflict() : retryOnConflict;
        ifSeqNo = updateOperation.hasIfSeqNo() ? updateOperation.getIfSeqNo() : ifSeqNo;
        ifPrimaryTerm = updateOperation.hasIfPrimaryTerm() ? updateOperation.getIfPrimaryTerm() : ifPrimaryTerm;
        requireAlias = updateOperation.hasRequireAlias() ? updateOperation.getRequireAlias() : requireAlias;
        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(index)).id(id).routing(routing).retryOnConflict(retryOnConflict).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).setRequireAlias(requireAlias).routing(routing);
        updateRequest = BulkRequestParserProtoUtils.fromProto(updateRequest, document, bulkRequestBody, updateOperation);
        if (fetchSourceContext != null) {
            updateRequest.fetchSource(fetchSourceContext);
        }
        return updateRequest;
    }

    public static UpdateRequest fromProto(UpdateRequest updateRequest, byte[] document, BulkRequestBody bulkRequestBody, UpdateOperation updateOperation) {
        if (bulkRequestBody.hasUpdateAction()) {
            UpdateAction updateAction = bulkRequestBody.getUpdateAction();
            if (updateAction.hasScript()) {
                Script script = ScriptProtoUtils.parseFromProtoRequest(updateAction.getScript());
                updateRequest.script(script);
            }
            if (updateAction.hasScriptedUpsert()) {
                updateRequest.scriptedUpsert(updateAction.getScriptedUpsert());
            }
            if (updateAction.hasUpsert()) {
                updateRequest.upsert(new Object[]{updateAction.getUpsert(), MediaTypeRegistry.JSON});
            }
            if (updateAction.hasDocAsUpsert()) {
                updateRequest.docAsUpsert(updateAction.getDocAsUpsert());
            }
            if (updateAction.hasDetectNoop()) {
                updateRequest.detectNoop(updateAction.getDetectNoop());
            }
            if (updateAction.hasXSource()) {
                updateRequest.fetchSource(FetchSourceContextProtoUtils.fromProto(updateAction.getXSource()));
            }
        }
        updateRequest.doc(document, MediaTypeRegistry.JSON);
        if (updateOperation.hasIfSeqNo()) {
            updateRequest.setIfSeqNo(updateOperation.getIfSeqNo());
        }
        if (updateOperation.hasIfPrimaryTerm()) {
            updateRequest.setIfPrimaryTerm(updateOperation.getIfPrimaryTerm());
        }
        return updateRequest;
    }

    public static DeleteRequest buildDeleteRequest(DeleteOperation deleteOperation, String index, String id, String routing, long version, VersionType versionType, long ifSeqNo, long ifPrimaryTerm) {
        index = deleteOperation.hasXIndex() ? deleteOperation.getXIndex() : index;
        id = deleteOperation.hasXId() ? deleteOperation.getXId() : id;
        routing = deleteOperation.hasRouting() ? deleteOperation.getRouting() : routing;
        long l = version = deleteOperation.hasVersion() ? deleteOperation.getVersion() : version;
        if (deleteOperation.hasVersionType()) {
            versionType = VersionTypeProtoUtils.fromProto(deleteOperation.getVersionType());
        }
        ifSeqNo = deleteOperation.hasIfSeqNo() ? deleteOperation.getIfSeqNo() : ifSeqNo;
        ifPrimaryTerm = deleteOperation.hasIfPrimaryTerm() ? deleteOperation.getIfPrimaryTerm() : ifPrimaryTerm;
        DeleteRequest deleteRequest = new DeleteRequest(index).id(id).routing(routing).version(version).versionType(versionType).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm);
        return deleteRequest;
    }
}

