/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query;

import org.opensearch.index.query.ScriptQueryBuilder;
import org.opensearch.protobufs.ScriptQuery;
import org.opensearch.script.Script;
import org.opensearch.transport.grpc.proto.request.common.ScriptProtoUtils;

class ScriptQueryBuilderProtoUtils {
    private ScriptQueryBuilderProtoUtils() {
    }

    static ScriptQueryBuilder fromProto(ScriptQuery scriptQueryProto) {
        if (scriptQueryProto == null) {
            throw new IllegalArgumentException("ScriptQuery cannot be null");
        }
        if (!scriptQueryProto.hasScript()) {
            throw new IllegalArgumentException("script must be provided with a [script] query");
        }
        Script script = ScriptProtoUtils.parseFromProtoRequest(scriptQueryProto.getScript());
        float boost = 1.0f;
        String queryName = null;
        if (scriptQueryProto.hasBoost()) {
            boost = scriptQueryProto.getBoost();
        }
        if (scriptQueryProto.hasXName()) {
            queryName = scriptQueryProto.getXName();
        }
        return (ScriptQueryBuilder)((ScriptQueryBuilder)new ScriptQueryBuilder(script).boost(boost)).queryName(queryName);
    }
}

