/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation;

import java.util.function.Function;
import java.util.function.Supplier;
import org.opensearch.cluster.DiskUsage;
import org.opensearch.cluster.routing.allocation.DiskThresholdEvaluator;
import org.opensearch.cluster.routing.allocation.DiskThresholdSettings;
import org.opensearch.core.common.unit.ByteSizeValue;

public class WarmNodeDiskThresholdEvaluator
implements DiskThresholdEvaluator {
    private final DiskThresholdSettings diskThresholdSettings;
    private final Supplier<Double> dataToFileCacheSizeRatioSupplier;

    public WarmNodeDiskThresholdEvaluator(DiskThresholdSettings diskThresholdSettings, Supplier<Double> dataToFileCacheSizeRatioSupplier) {
        this.diskThresholdSettings = diskThresholdSettings;
        this.dataToFileCacheSizeRatioSupplier = dataToFileCacheSizeRatioSupplier;
    }

    @Override
    public boolean isNodeExceedingLowWatermark(DiskUsage diskUsage) {
        return this.isNodeExceedingWatermark(diskUsage, this::getFreeSpaceLowThreshold);
    }

    @Override
    public boolean isNodeExceedingHighWatermark(DiskUsage diskUsage) {
        return this.isNodeExceedingWatermark(diskUsage, this::getFreeSpaceHighThreshold);
    }

    @Override
    public boolean isNodeExceedingFloodStageWatermark(DiskUsage diskUsage) {
        return this.isNodeExceedingWatermark(diskUsage, this::getFreeSpaceFloodStageThreshold);
    }

    private boolean isNodeExceedingWatermark(DiskUsage diskUsage, Function<Long, Long> thresholdFunction) {
        long freeSpaceThreshold;
        long totalBytes = diskUsage.getTotalBytes();
        if (this.dataToFileCacheSizeRatioSupplier.get() <= 0.0 || totalBytes <= 0L) {
            return false;
        }
        long freeSpace = diskUsage.getFreeBytes();
        return freeSpace < (freeSpaceThreshold = thresholdFunction.apply(totalBytes).longValue());
    }

    @Override
    public long getFreeSpaceLowThreshold(long totalAddressableSpace) {
        return this.calculateFreeSpaceWatermarkThreshold(this.diskThresholdSettings.getFreeDiskThresholdLow(), this.diskThresholdSettings.getFreeBytesThresholdLow(), totalAddressableSpace);
    }

    @Override
    public long getFreeSpaceHighThreshold(long totalAddressableSpace) {
        return this.calculateFreeSpaceWatermarkThreshold(this.diskThresholdSettings.getFreeDiskThresholdHigh(), this.diskThresholdSettings.getFreeBytesThresholdHigh(), totalAddressableSpace);
    }

    @Override
    public long getFreeSpaceFloodStageThreshold(long totalAddressableSpace) {
        return this.calculateFreeSpaceWatermarkThreshold(this.diskThresholdSettings.getFreeDiskThresholdFloodStage(), this.diskThresholdSettings.getFreeBytesThresholdFloodStage(), totalAddressableSpace);
    }

    private long calculateFreeSpaceWatermarkThreshold(double freeDiskWatermarkThreshold, ByteSizeValue freeBytesWatermarkThreshold, long totalAddressableSpace) {
        if (freeDiskWatermarkThreshold > 0.0) {
            return (long)((double)totalAddressableSpace * freeDiskWatermarkThreshold / 100.0);
        }
        double dataToFileCacheSizeRatio = this.dataToFileCacheSizeRatioSupplier.get();
        if (freeBytesWatermarkThreshold != null && freeBytesWatermarkThreshold.getBytes() > 0L) {
            return freeBytesWatermarkThreshold.getBytes() * (long)dataToFileCacheSizeRatio;
        }
        return 0L;
    }
}

