/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

@ExperimentalApi
public class StarTreeFieldConfiguration
implements ToXContent {
    private final AtomicInteger maxLeafDocs = new AtomicInteger();
    private final Set<String> skipStarNodeCreationInDims;
    private final StarTreeBuildMode buildMode;

    public StarTreeFieldConfiguration(int maxLeafDocs, Set<String> skipStarNodeCreationInDims, StarTreeBuildMode buildMode) {
        this.maxLeafDocs.set(maxLeafDocs);
        this.skipStarNodeCreationInDims = skipStarNodeCreationInDims;
        this.buildMode = buildMode;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("max_leaf_docs", this.maxLeafDocs.get());
        builder.startArray("skip_star_node_creation_for_dimensions");
        for (String dim : this.skipStarNodeCreationInDims) {
            builder.value(dim);
        }
        builder.endArray();
        return builder;
    }

    public int maxLeafDocs() {
        return this.maxLeafDocs.get();
    }

    public StarTreeBuildMode getBuildMode() {
        return this.buildMode;
    }

    public Set<String> getSkipStarNodeCreationInDims() {
        return this.skipStarNodeCreationInDims;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StarTreeFieldConfiguration that = (StarTreeFieldConfiguration)o;
        return Objects.equals(this.maxLeafDocs.get(), that.maxLeafDocs.get()) && Objects.equals(this.skipStarNodeCreationInDims, that.skipStarNodeCreationInDims) && this.buildMode == that.buildMode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.maxLeafDocs.get(), this.skipStarNodeCreationInDims, this.buildMode});
    }

    @ExperimentalApi
    public static enum StarTreeBuildMode {
        ON_HEAP("onheap", 0),
        OFF_HEAP("offheap", 1);

        private final String typeName;
        private final byte buildModeOrdinal;

        private StarTreeBuildMode(String typeName, byte buildModeOrdinal) {
            this.typeName = typeName;
            this.buildModeOrdinal = buildModeOrdinal;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public byte getBuildModeOrdinal() {
            return this.buildModeOrdinal;
        }

        public static StarTreeBuildMode fromTypeName(String typeName) {
            for (StarTreeBuildMode starTreeBuildMode : StarTreeBuildMode.values()) {
                if (!starTreeBuildMode.getTypeName().equalsIgnoreCase(typeName)) continue;
                return starTreeBuildMode;
            }
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid star tree build mode: [%s] ", typeName));
        }

        public static StarTreeBuildMode fromBuildModeOrdinal(byte buildModeOrdinal) {
            for (StarTreeBuildMode starTreeBuildMode : StarTreeBuildMode.values()) {
                if (starTreeBuildMode.getBuildModeOrdinal() != buildModeOrdinal) continue;
                return starTreeBuildMode;
            }
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid star tree build mode: [%s] ", buildModeOrdinal));
        }
    }
}

